/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import com.rabbitmq.client.Channel;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.SignalType;

public class ChannelCloseHandlers {
    public static final BiConsumer<SignalType, Channel> SENDER_CHANNEL_CLOSE_HANDLER_INSTANCE = new SenderChannelCloseHandler();

    public static class SenderChannelCloseHandler
    implements BiConsumer<SignalType, Channel> {
        private static final Logger LOGGER = LoggerFactory.getLogger(SenderChannelCloseHandler.class);

        @Override
        public void accept(SignalType signalType, Channel channel) {
            int channelNumber = channel.getChannelNumber();
            LOGGER.debug("closing channel {} by signal {}", (Object)channelNumber, (Object)signalType);
            try {
                if (channel.isOpen() && channel.getConnection().isOpen()) {
                    channel.close();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Channel {} didn't close normally: {}", (Object)channelNumber, (Object)e.getMessage());
            }
        }
    }
}

