/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.assembler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.core.assembler.DatasetAssemblerVocab;
import org.apache.jena.sparql.util.graph.GraphUtils;

public abstract class NamedDatasetAssembler
extends DatasetAssembler {
    public static final Map<String, DatasetGraph> sharedDatasetPool = new ConcurrentHashMap<String, DatasetGraph>();

    protected NamedDatasetAssembler() {
    }

    @Override
    public final DatasetGraph createNamedDataset(Assembler a, Resource root2) {
        DatasetGraph dsg;
        String name = GraphUtils.getStringValue(root2, DatasetAssemblerVocab.pDatasetName);
        Map<String, DatasetGraph> pool = this.pool();
        if (name != null && pool != null && (dsg = this.pool().computeIfAbsent(name, n -> this.createDataset(a, root2))) != null) {
            return dsg;
        }
        return this.createDataset(a, root2);
    }

    public Map<String, DatasetGraph> pool() {
        return sharedDatasetPool;
    }
}

