/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

import java.util.regex.Pattern;
import org.apache.jena.rfc3986.Builder;
import org.apache.jena.rfc3986.IRI;
import org.apache.jena.rfc3986.IRI3986;

public class RFC3986 {
    static final String altRFC3986regex = "(([^:/?#]*):)?(//((([^/?#@]*)@)?(\\[[^/?#]*\\]|([^/?#:]*))?(:([^/?#]*))?))?([^#?]*)?(\\?([^#]*))?(#(.*))?";
    public static final Pattern rfc3986regex = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");

    public static void checkSyntax(String iristr) {
        IRI3986.checkSyntax(iristr);
    }

    public static IRI3986 create(String iristr) {
        return IRI3986.create(iristr);
    }

    public static IRI3986 createAny(String iristr) {
        IRI3986 iri = IRI3986.createAny(iristr);
        return iri;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static IRI3986 create(IRI iriOther) {
        if (iriOther instanceof IRI3986) {
            IRI3986 ref3986 = (IRI3986)iriOther;
            return ref3986;
        }
        return RFC3986.newBuilder().scheme(iriOther.scheme()).authority(iriOther.authority()).path(iriOther.path()).query(iriOther.query()).fragment(iriOther.fragment()).build();
    }

    public static IRI3986 normalize(IRI3986 iri) {
        return iri.normalize();
    }

    public static IRI3986 resolve(IRI3986 base, IRI3986 iri) {
        return base.resolve(iri);
    }

    public static IRI3986 relativize(IRI3986 base, IRI3986 iri) {
        return iri.relativize(base);
    }

    public static IRI3986 createByRegex(String iriStr) {
        return IRI3986.createByRegex(iriStr);
    }
}

