/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.datatypes.BaseDatatype;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.PersonalityConfigException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.OntModelControls;
import org.apache.jena.ontapi.UnionGraph;
import org.apache.jena.ontapi.common.EnhNodeFactory;
import org.apache.jena.ontapi.common.OntConfig;
import org.apache.jena.ontapi.common.OntEnhGraph;
import org.apache.jena.ontapi.common.OntEnhNodeFactories;
import org.apache.jena.ontapi.common.OntPersonalities;
import org.apache.jena.ontapi.common.OntPersonality;
import org.apache.jena.ontapi.impl.OntModelEvent;
import org.apache.jena.ontapi.impl.UnionGraphImpl;
import org.apache.jena.ontapi.impl.objects.OntClassImpl;
import org.apache.jena.ontapi.impl.objects.OntDataRangeImpl;
import org.apache.jena.ontapi.impl.objects.OntDisjointImpl;
import org.apache.jena.ontapi.impl.objects.OntFacetRestrictionImpl;
import org.apache.jena.ontapi.impl.objects.OntIndividualImpl;
import org.apache.jena.ontapi.impl.objects.OntListImpl;
import org.apache.jena.ontapi.impl.objects.OntObjectImpl;
import org.apache.jena.ontapi.impl.objects.OntSWRLImpl;
import org.apache.jena.ontapi.impl.objects.OntStatementImpl;
import org.apache.jena.ontapi.model.OntAnnotationProperty;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDataProperty;
import org.apache.jena.ontapi.model.OntDataRange;
import org.apache.jena.ontapi.model.OntDisjoint;
import org.apache.jena.ontapi.model.OntEntity;
import org.apache.jena.ontapi.model.OntFacetRestriction;
import org.apache.jena.ontapi.model.OntID;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntList;
import org.apache.jena.ontapi.model.OntModel;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.ontapi.model.OntSWRL;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.ontapi.utils.Graphs;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.ontapi.utils.OntModels;
import org.apache.jena.ontapi.utils.StdModels;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.IteratorFactory;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.reasoner.Derivation;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ValidityReport;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.ReasonerVocabulary;

public class OntGraphModelImpl
extends ModelCom
implements OntModel,
OntEnhGraph,
InfModel {
    protected final Map<String, RDFDatatype> dtTypes = new HashMap<String, RDFDatatype>();
    private final ThreadLocal<Set<Node>> visited = ThreadLocal.withInitial(HashSet::new);
    private Model deductionsModel = null;
    private final Set<Class<? extends OntEntity>> supportedEntityTypes;
    public final Map<String, Object> propertyStore = new HashMap<String, Object>();

    public OntGraphModelImpl(UnionGraph graph, OntPersonality personality) {
        this((Graph)graph, personality);
    }

    public OntGraphModelImpl(InfGraph graph, OntPersonality personality) {
        this((Graph)graph, personality);
    }

    protected OntGraphModelImpl(Graph graph, OntPersonality personality) {
        super(OntGraphModelImpl.makeGraph(graph), OntPersonality.asJenaPersonality(personality));
        this.supportedEntityTypes = OntEntity.TYPES.stream().filter(personality::supports).collect(Collectors.toSet());
    }

    protected static Graph makeGraph(Graph given) {
        Objects.requireNonNull(given);
        if (given instanceof InfGraph) {
            Graph raw = ((InfGraph)given).getRawGraph();
            if (raw instanceof UnionGraph) {
                return given;
            }
            throw new IllegalArgumentException("The specified InfGraph does not wrap UnionGraph, instead it wraps " + raw.getClass().getSimpleName());
        }
        if (given instanceof UnionGraph) {
            return given;
        }
        throw new IllegalArgumentException("The specified graph is not UnionGraph or InfGraph: " + given.getClass().getSimpleName());
    }

    public static <M extends EnhGraph, O extends OntObject> ExtendedIterator<O> listOntObjects(M m, Class<? extends O> type) {
        OntPersonality p = ((OntEnhGraph)m).getOntPersonality();
        if (p.supports(type)) {
            ExtendedIterator<EnhNode> res = p.getObjectFactory(type).iterator(m);
            return res;
        }
        return NullIterator.instance();
    }

    public static <M extends OntModel & OntEnhGraph> ExtendedIterator<OntIndividual> listIndividuals(M model, Set<String> reserved, ExtendedIterator<Triple> assertions) {
        HashSet seen = new HashSet();
        boolean useSimplifiedClassChecking = ((OntEnhGraph)model).getOntPersonality().getConfig().getBoolean(OntModelControls.USE_SIMPLIFIED_TYPE_CHECKING_WHILE_LIST_INDIVIDUALS);
        boolean isRDFS = OntPersonalities.isRDFS(((OntEnhGraph)model).getOntPersonality());
        return assertions.mapWith(t -> {
            if (t.getObject().isURI() && reserved.contains(t.getObject().getURI())) {
                return null;
            }
            if (seen.remove(t)) {
                return null;
            }
            if (!OntGraphModelImpl.testIsClass(model, t.getObject(), useSimplifiedClassChecking, isRDFS)) {
                return null;
            }
            return model.asStatement((Triple)t);
        }).filterKeep(s -> {
            if (s == null) {
                return false;
            }
            OntIndividual i = s.getSubject().getAs(OntIndividual.class);
            if (i == null) {
                return false;
            }
            ((OntIndividualImpl)i).listClasses().forEachRemaining(x -> {
                if (s.getObject().equals(x)) {
                    return;
                }
                seen.add(Triple.create((Node)i.asNode(), (Node)RDF.Nodes.type, (Node)x.asNode()));
            });
            return true;
        }).mapWith(s -> s.getSubject(OntIndividual.class));
    }

    private static <M extends OntModel & OntEnhGraph> boolean testIsClass(M model, Node candidate, boolean simpleCheck, boolean isRDFS) {
        if (simpleCheck) {
            if (isRDFS) {
                return OntGraphModelImpl.testIsRDFSClass(model, candidate);
            }
            return OntGraphModelImpl.testIsOWLClass(model, candidate);
        }
        OntClass clazz = ((OntEnhGraph)model).safeFindNodeAs(candidate, OntClass.class);
        return clazz != null && clazz.canAsAssertionClass();
    }

    private static <M extends OntModel & OntEnhGraph> boolean testIsOWLClass(M model, Node candidate) {
        if (((OntEnhGraph)model).getOntPersonality().getPunnings().getNamedClasses().contains(candidate)) {
            return false;
        }
        if (((OntEnhGraph)model).getOntPersonality().getBuiltins().getNamedClasses().contains(candidate)) {
            return true;
        }
        return Graphs.hasOneOfType(candidate, model.getGraph(), Set.of(OWL2.Class.asNode(), OWL2.Restriction.asNode()));
    }

    private static boolean testIsRDFSClass(Model model, Node candidate) {
        return model.getGraph().contains(candidate, RDF.type.asNode(), RDFS.Class.asNode());
    }

    private static <X> Stream<X> asStream(Graph graph, ExtendedIterator<X> it, boolean withSize) {
        int characteristics = Graphs.getSpliteratorCharacteristics(graph);
        long size = -1L;
        if (withSize && Graphs.isSized(graph)) {
            size = Graphs.size(graph);
            characteristics |= 0x40;
        }
        return Iterators.asStream(it, size, characteristics);
    }

    public static void checkFeature(OntModel m, OntModelControls setting, String featureName) {
        OntJenaException.checkSupported(OntGraphModelImpl.configValue(m, setting), "Feature " + featureName + " is disabled. Profile " + OntEnhGraph.asPersonalityModel(m).getOntPersonality().getName());
    }

    public static boolean configValue(OntModel m, OntModelControls setting) {
        OntConfig config = OntModels.config(m);
        return config != null && config.getBoolean(setting);
    }

    @Override
    public OntPersonality getOntPersonality() {
        return (OntPersonality)super.getPersonality();
    }

    public UnionGraph getUnionGraph() {
        Graph graph = super.getGraph();
        if (graph instanceof InfGraph) {
            Graph raw = ((InfGraph)graph).getRawGraph();
            if (raw instanceof UnionGraph) {
                return (UnionGraph)raw;
            }
            throw new IllegalStateException("The encapsulated InfGraph does not wrap UnionGraph, instead it wraps " + raw.getClass().getSimpleName());
        }
        if (graph instanceof UnionGraph) {
            return (UnionGraph)graph;
        }
        throw new IllegalStateException("The model wraps " + graph.getClass().getSimpleName() + ", that is illegal");
    }

    @Override
    public Graph getBaseGraph() {
        return this.getUnionGraph().getBaseGraph();
    }

    @Override
    public Model getBaseModel() {
        return new ModelCom(this.getBaseGraph());
    }

    @Override
    public OntGraphModelImpl register(ModelChangedListener listener) {
        this.getUnionGraph().getEventManager().register(this.adapt(listener));
        return this;
    }

    @Override
    public OntGraphModelImpl unregister(ModelChangedListener listener) {
        this.getUnionGraph().getEventManager().unregister(this.adapt(listener));
        return this;
    }

    @Override
    public OntGraphModelImpl notifyEvent(Object event) {
        UnionGraph ug = this.getUnionGraph();
        ug.getEventManager().notifyEvent(ug, event);
        return this;
    }

    @Override
    public OntID getID() {
        this.checkType(OntID.class);
        Optional<OntID> id = this.id();
        if (id.isEmpty() && !OntGraphModelImpl.configValue(this, OntModelControls.USE_GENERATE_ONTOLOGY_HEADER_IF_ABSENT_STRATEGY)) {
            throw new OntJenaException.IllegalState("No ontology header found, use OntModel#setID method instead");
        }
        return id.orElseGet(() -> this.setID(null));
    }

    @Override
    public OntIndividual createIndividual(String uri, OntClass type) {
        if (uri == null) {
            this.checkType(OntIndividual.Anonymous.class);
        }
        return OntModel.super.createIndividual(uri, type);
    }

    @Override
    public Optional<OntID> id() {
        this.checkType(OntID.class);
        return Graphs.ontologyNode(this.getBaseGraph(), OntGraphModelImpl.configValue(this, OntModelControls.USE_CHOOSE_MOST_SUITABLE_ONTOLOGY_HEADER_STRATEGY)).map(x -> this.getNodeAs((Node)x, (Class)OntID.class));
    }

    @Override
    public OntID setID(String uri) {
        this.checkType(OntID.class);
        UnionGraph ug = this.getUnionGraph();
        UnionGraph.EventManager em = ug.getEventManager();
        em.notifyEvent(ug, (Object)OntModelEvent.startChangeIDEvent());
        Node id = Graphs.createOntologyHeaderNode(this.getBaseGraph(), uri);
        OntID res = this.getNodeAs(id, OntID.class);
        em.notifyEvent(ug, (Object)OntModelEvent.finishChangeIDEvent());
        return res;
    }

    @Override
    public OntGraphModelImpl addImport(OntModel m) {
        this.checkType(OntID.class);
        if (Objects.requireNonNull(m, "Null model specified.").getID().isAnon()) {
            throw new OntJenaException.IllegalArgument("Anonymous sub models are not allowed.");
        }
        String importsURI = m.id().map(OntID::getImportsIRI).orElseThrow(() -> new IllegalArgumentException("Attempt to import unnamed ontology"));
        if (importsURI.equals(this.getID().getURI())) {
            throw new OntJenaException.IllegalArgument("Attempt to import ontology with the same name: " + importsURI);
        }
        if (this.hasImport(importsURI)) {
            throw new OntJenaException.IllegalArgument("Ontology <" + importsURI + "> is already in imports.");
        }
        Graph g = m.getGraph();
        if (g instanceof InfGraph) {
            g = ((InfGraph)g).getRawGraph();
        }
        if (g instanceof UnionGraph && !Graphs.isOntUnionGraph((UnionGraph)g, OntGraphModelImpl.configValue(this, OntModelControls.USE_CHOOSE_MOST_SUITABLE_ONTOLOGY_HEADER_STRATEGY))) {
            throw new OntJenaException.IllegalArgument("Ontology <" + importsURI + "> has wrong structure.");
        }
        this.addImportModel(g, importsURI);
        return this;
    }

    @Override
    public boolean hasImport(OntModel m) {
        Objects.requireNonNull(m);
        return this.findImportAsRawModel(x -> Graphs.isSameBase(x.getGraph(), m.getGraph())).isPresent();
    }

    @Override
    public boolean hasImport(String uri) {
        return this.findImportAsRawModel(x -> Objects.equals(x.getID().getImportsIRI(), uri)).isPresent();
    }

    @Override
    public OntGraphModelImpl removeImport(OntModel m) {
        Objects.requireNonNull(m);
        Graph g = m.getGraph();
        Graph data = g instanceof InfGraph ? ((InfGraph)g).getRawGraph() : g;
        this.findImportAsRawModel(it -> Graphs.isSameBase(it.getGraph(), data)).ifPresent(it -> this.removeImportModel(it.getGraph(), it.getID().getImportsIRI()));
        return this;
    }

    @Override
    public OntGraphModelImpl removeImport(String uri) {
        this.findImportAsRawModel(x -> Objects.equals(uri, x.getID().getImportsIRI())).ifPresent(x -> this.removeImportModel(x.getGraph(), x.getID().getImportsIRI()));
        return this;
    }

    @Override
    public Stream<OntModel> imports() {
        return this.imports(this.getOntPersonality());
    }

    public Stream<OntModel> imports(OntPersonality personality) {
        return Iterators.asStream(this.listImportModels(personality, this.getReasoner()));
    }

    protected Optional<OntGraphModelImpl> findImportAsRawModel(Predicate<OntGraphModelImpl> filter) {
        return Iterators.findFirst(this.listImportModels(this.getOntPersonality(), null).filterKeep(filter));
    }

    protected void addImportModel(Graph graph, String uri) {
        this.getUnionGraph().addSubGraph(graph);
        this.getID().addImport(uri);
        this.rebind();
    }

    protected void removeImportModel(Graph graph, String uri) {
        this.getUnionGraph().removeSubGraph(graph);
        this.getID().removeImport(uri);
        this.rebind();
    }

    public final ExtendedIterator<OntGraphModelImpl> listImportModels(OntPersonality personality, Reasoner reasoner) {
        return this.listImportGraphs().mapWith(u -> {
            UnionGraph g = reasoner != null ? reasoner.bind((Graph)u) : u;
            return new OntGraphModelImpl((Graph)g, personality);
        });
    }

    protected final ExtendedIterator<UnionGraph> listImportGraphs() {
        UnionGraph u = this.getUnionGraph();
        ExtendedIterator subGraphs = u instanceof UnionGraphImpl ? ((UnionGraphImpl)u).getSubGraphs().listGraphs() : WrappedIterator.create(u.subGraphs().iterator());
        Set<String> imports = Graphs.getImports(u.getBaseGraph(), OntGraphModelImpl.configValue(this, OntModelControls.USE_CHOOSE_MOST_SUITABLE_ONTOLOGY_HEADER_STRATEGY));
        return subGraphs.filterKeep(x -> x instanceof UnionGraph).mapWith(x -> (UnionGraph)x).filterKeep(it -> Graphs.findOntologyNameNode(it.getBaseGraph(), OntGraphModelImpl.configValue(this, OntModelControls.USE_CHOOSE_MOST_SUITABLE_ONTOLOGY_HEADER_STRATEGY)).filter(Node::isURI).map(Node::getURI).filter(imports::contains).isPresent());
    }

    public OntGraphModelImpl getTopModel() {
        if (this.independent()) {
            return this;
        }
        OntPersonality personality = this.getOntPersonality();
        return new OntGraphModelImpl(new UnionGraphImpl(this.getBaseGraph(), false), personality);
    }

    public boolean independent() {
        return !this.getUnionGraph().hasSubGraph();
    }

    public <E extends OntObjectImpl> boolean isBuiltIn(E e) {
        return this.getOntPersonality().getBuiltins().get(e.objectType()).contains(e.asNode());
    }

    @Override
    public <O extends OntObject> Stream<O> ontObjects(Class<? extends O> type) {
        return Iterators.asStream(this.listOntObjects(type), Graphs.getSpliteratorCharacteristics(this.getGraph()));
    }

    public <O extends OntObject> ExtendedIterator<O> listOntObjects(Class<? extends O> type) {
        return OntGraphModelImpl.listOntObjects(this, type);
    }

    public <O extends OntObject> ExtendedIterator<O> listLocalOntObjects(Class<? extends O> type) {
        return OntGraphModelImpl.listOntObjects(this.getTopModel(), type);
    }

    @Override
    public Stream<OntEntity> ontEntities() {
        return this.supportedEntityTypes.stream().flatMap(this::ontObjects);
    }

    public ExtendedIterator<OntEntity> listOntEntities() {
        return Iterators.flatMap(Iterators.create(this.supportedEntityTypes), this::listOntObjects);
    }

    public ExtendedIterator<OntEntity> listLocalOntEntities() {
        return Iterators.flatMap(Iterators.create(this.supportedEntityTypes), this::listLocalOntObjects);
    }

    public Stream<OntEntity> ambiguousEntities(boolean withImports) {
        return this.ontEntities().filter(e -> withImports || e.isLocal()).filter(e -> this.supportedEntityTypes.stream().filter(view -> e.canAs((Class)view) && (withImports || ((OntEntity)e.as((Class)view)).isLocal())).count() > 1L);
    }

    @Override
    public Stream<OntIndividual> individuals() {
        return Iterators.asStream(this.listIndividuals(), Graphs.getSpliteratorCharacteristics(this.getGraph()));
    }

    public ExtendedIterator<OntIndividual> listIndividuals() {
        Model capabilities;
        OntPersonality personality = this.getOntPersonality();
        boolean isRDFS = OntPersonalities.isRDFS(personality);
        boolean withOWLThing = OntPersonalities.supportsOWLThing(personality);
        if (!isRDFS && withOWLThing && (capabilities = this.getReasonerCapabilities()) != null && capabilities.contains(null, ReasonerVocabulary.supportsP, (RDFNode)ReasonerVocabulary.individualAsThingP)) {
            return this.listStatements(null, RDF.type, (RDFNode)OWL2.Thing).mapWith(it -> (OntIndividual)it.getSubject().as(OntIndividual.class));
        }
        return OntGraphModelImpl.listIndividuals(this, personality.forbidden(OntClass.Named.class), (ExtendedIterator<Triple>)this.getGraph().find(Node.ANY, RDF.Nodes.type, Node.ANY));
    }

    @Override
    public Stream<OntClass> hierarchyRoots() {
        return Iterators.asStream(this.listHierarchyRoots(), Graphs.getSpliteratorCharacteristics(this.getGraph()));
    }

    public ExtendedIterator<OntClass> listHierarchyRoots() {
        Model capabilities;
        if (OntPersonalities.supportsOWLThing(this.getOntPersonality()) && (capabilities = this.getReasonerCapabilities()) != null && capabilities.contains(null, ReasonerVocabulary.supportsP, (RDFNode)ReasonerVocabulary.directSubClassOf)) {
            return this.listStatements(null, ReasonerVocabulary.directSubClassOf, (RDFNode)OWL2.Thing).mapWith(it -> (OntClass)it.getSubject().as(OntClass.class));
        }
        Set<Node> reserved = this.getOntPersonality().getReserved().getAllResources();
        return this.listOntObjects(OntClass.class).filterDrop(c -> reserved.contains(c.asNode())).filterKeep(OntClass::isHierarchyRoot);
    }

    @Override
    public <E extends OntEntity> E getOntEntity(Class<E> type, String uri) {
        return (E)((OntEntity)this.findNodeAs(NodeFactory.createURI((String)OntJenaException.notNull(uri, "Null uri.")), type));
    }

    public <T extends OntEntity> T createOntEntity(Class<T> type, String iri) {
        try {
            return (T)((OntEntity)this.createOntObject(type, iri));
        }
        catch (OntJenaException.Creation ex) {
            throw new OntJenaException.Creation(String.format("Creation of %s <%s> is not allowed by the configuration. Profile: %s", OntEnhNodeFactories.viewAsString(type), iri, this.getOntPersonality().getName()), (Throwable)((Object)ex));
        }
    }

    public <T extends OntObject> T createOntObject(Class<T> type, String uri) {
        OntPersonality personality = this.getOntPersonality();
        OntJenaException.checkSupported(personality.supports(type), "Attempt to create resource <" + uri + ">. Profile " + personality.getName() + " does not support language construct " + OntEnhNodeFactories.viewAsString(type));
        Node node = Graphs.createNode(uri);
        EnhNodeFactory factory = personality.getObjectFactory(type);
        return (T)((OntObject)factory.createInGraph(node, (EnhGraph)this).as(type));
    }

    @Override
    public OntGraphModelImpl removeOntObject(OntObject obj) {
        obj.clearAnnotations().content().peek(OntStatement::clearAnnotations).collect(Collectors.toSet()).forEach(this::remove);
        return this;
    }

    @Override
    public OntGraphModelImpl removeOntStatement(OntStatement statement) {
        return this.remove(statement.clearAnnotations());
    }

    @Override
    public Stream<OntStatement> statements() {
        Graph g = this.getGraph();
        return OntGraphModelImpl.asStream(g, g.find().mapWith(this::asStatement), true);
    }

    @Override
    public Stream<OntStatement> statements(Resource s, Property p, RDFNode o) {
        return OntGraphModelImpl.asStream(this.getGraph(), this.listOntStatements(s, p, o), StdModels.isANY(s, p, o));
    }

    @Override
    public Stream<OntStatement> localStatements(Resource s, Property p, RDFNode o) {
        return OntGraphModelImpl.asStream(this.getBaseGraph(), this.listLocalStatements(s, p, o), StdModels.isANY(s, p, o));
    }

    public StmtIterator listStatements(Resource s, Property p, RDFNode o) {
        return StdModels.createStmtIterator((ExtendedIterator<Triple>)this.getGraph().find(OntGraphModelImpl.asNode((RDFNode)s), OntGraphModelImpl.asNode((RDFNode)p), OntGraphModelImpl.asNode((RDFNode)o)), this::asStatement);
    }

    public ExtendedIterator<OntStatement> listOntStatements(Resource s, Property p, RDFNode o) {
        return Iterators.create(this.getGraph().find(OntGraphModelImpl.asNode((RDFNode)s), OntGraphModelImpl.asNode((RDFNode)p), OntGraphModelImpl.asNode((RDFNode)o)).mapWith(this::asStatement));
    }

    public ExtendedIterator<OntStatement> listLocalStatements(Resource s, Property p, RDFNode o) {
        return Iterators.create(this.getBaseGraph().find(OntGraphModelImpl.asNode((RDFNode)s), OntGraphModelImpl.asNode((RDFNode)p), OntGraphModelImpl.asNode((RDFNode)o)).mapWith(this::asStatement));
    }

    public OntStatementImpl createStatement(Resource s, Property p, RDFNode o) {
        return OntStatementImpl.createOntStatementImpl(s, p, o, this);
    }

    @Override
    public OntStatementImpl asStatement(Triple triple) {
        return OntStatementImpl.createOntStatementImpl(triple, this);
    }

    public boolean containsLocal(Resource s, Property p, RDFNode o) {
        return this.getBaseGraph().contains(OntGraphModelImpl.asNode((RDFNode)s), OntGraphModelImpl.asNode((RDFNode)p), OntGraphModelImpl.asNode((RDFNode)o));
    }

    public <E extends RDFNode> OntListImpl<E> asOntList(RDFList list, OntObject subject, Property predicate, Class<E> type) {
        return this.asOntList(list, subject, predicate, false, null, type);
    }

    public <E extends RDFNode> OntListImpl<E> asOntList(RDFList list, OntObject subject, Property predicate, boolean checkRecursions, Resource listType, Class<E> elementType) {
        OntListImpl.checkRequiredInputs(subject, predicate, (RDFNode)list, listType, elementType);
        return checkRecursions ? OntListImpl.asSafeOntList(list, this, subject, predicate, listType, elementType) : OntListImpl.asOntList(list, this, subject, predicate, listType, elementType);
    }

    public <E extends RDFNode> OntListImpl<E> createOntList(OntObject subject, Property predicate, Class<E> type, Iterator<E> elements) {
        return this.createOntList(subject, predicate, null, type, elements);
    }

    public <E extends RDFNode> OntListImpl<E> createOntList(OntObject subject, Property predicate, Resource listType, Class<E> elementType, Iterator<E> elements) {
        OntListImpl.checkRequiredInputs(subject, predicate, listType, elementType);
        return OntListImpl.create(this, subject, predicate, listType, elementType, Iterators.create(elements));
    }

    public ExtendedIterator<Resource> listAnnotations(Resource t, Resource s, Property p, RDFNode o) {
        return this.getGraph().find(Node.ANY, OWL2.annotatedSource.asNode(), s.asNode()).mapWith(this::asStatement).filterKeep(x -> (OWL2.Axiom == t ? x.belongsToOWLAxiom() : x.belongsToOWLAnnotation()) && x.hasAnnotatedProperty(p) && x.hasAnnotatedTarget(o)).mapWith(Statement::getSubject);
    }

    public OntGraphModelImpl deleteOntList(OntObject subject, Property predicate, OntList<?> object) {
        Objects.requireNonNull(subject);
        Objects.requireNonNull(predicate);
        OntJenaException.notNull(object, "Null list for subject " + String.valueOf(subject) + " and predicate " + String.valueOf(predicate));
        boolean hasNil = !object.isNil() && this.contains(subject, predicate, (RDFNode)RDF.nil);
        object.getMainStatement().clearAnnotations();
        object.clear();
        if (!hasNil) {
            return this.remove(subject, predicate, (RDFNode)object);
        }
        return this;
    }

    @Override
    public OntDisjoint.Classes createDisjointClasses(Collection<OntClass> classes) {
        if (classes.isEmpty()) {
            throw new IllegalArgumentException("Empty list is specified");
        }
        this.checkType(OntDisjoint.Classes.class);
        return this.checkCreate(model -> OntDisjointImpl.createDisjointClasses(model, classes.stream()), OntDisjoint.Classes.class);
    }

    @Override
    public OntDisjoint.Individuals createDifferentIndividuals(Collection<OntIndividual> individuals) {
        if (individuals.isEmpty()) {
            throw new IllegalArgumentException("Empty list is specified");
        }
        this.checkType(OntDisjoint.Individuals.class);
        return this.checkCreate(model -> OntDisjointImpl.createDifferentIndividuals(model, individuals.stream()), OntDisjoint.Individuals.class);
    }

    @Override
    public OntDisjoint.ObjectProperties createDisjointObjectProperties(Collection<OntObjectProperty> properties) {
        if (properties.isEmpty()) {
            throw new IllegalArgumentException("Empty list is specified");
        }
        this.checkType(OntDisjoint.ObjectProperties.class);
        return this.checkCreate(model -> OntDisjointImpl.createDisjointObjectProperties(model, properties.stream()), OntDisjoint.ObjectProperties.class);
    }

    @Override
    public OntDisjoint.DataProperties createDisjointDataProperties(Collection<OntDataProperty> properties) {
        if (properties.isEmpty()) {
            throw new IllegalArgumentException("Empty list is specified");
        }
        this.checkType(OntDisjoint.DataProperties.class);
        return this.checkCreate(model -> OntDisjointImpl.createDisjointDataProperties(model, properties.stream()), OntDisjoint.DataProperties.class);
    }

    public <T extends OntFacetRestriction> T createFacetRestriction(Class<T> view, Literal literal) {
        this.checkType(OntFacetRestriction.class);
        return OntFacetRestrictionImpl.create(this, view, literal);
    }

    @Override
    public OntDataRange.OneOf createDataOneOf(Collection<Literal> values) {
        this.checkType(OntDataRange.OneOf.class);
        return this.checkCreate(model -> OntDataRangeImpl.createOneOf(model, values.stream()), OntDataRange.OneOf.class);
    }

    @Override
    public OntDataRange.Restriction createDataRestriction(OntDataRange.Named datatype, Collection<OntFacetRestriction> values) {
        this.checkType(OntDataRange.Restriction.class);
        return OntDataRangeImpl.createRestriction(this, datatype, values.stream());
    }

    @Override
    public OntDataRange.ComplementOf createDataComplementOf(OntDataRange other) {
        this.checkType(OntDataRange.ComplementOf.class);
        return OntDataRangeImpl.createComplementOf(this, other);
    }

    @Override
    public OntDataRange.UnionOf createDataUnionOf(Collection<OntDataRange> values) {
        this.checkType(OntDataRange.UnionOf.class);
        return OntDataRangeImpl.createUnionOf(this, values.stream());
    }

    @Override
    public OntDataRange.IntersectionOf createDataIntersectionOf(Collection<OntDataRange> values) {
        this.checkType(OntDataRange.IntersectionOf.class);
        return OntDataRangeImpl.createIntersectionOf(this, values.stream());
    }

    @Override
    public OntClass.ObjectSomeValuesFrom createObjectSomeValuesFrom(OntObjectProperty property, OntClass ce) {
        this.checkType(OntClass.ObjectSomeValuesFrom.class);
        return this.checkCreate(model -> OntClassImpl.createComponentRestrictionCE(model, OntClass.ObjectSomeValuesFrom.class, property, (RDFNode)ce, OWL2.someValuesFrom), OntClass.ObjectSomeValuesFrom.class);
    }

    @Override
    public OntClass.DataSomeValuesFrom createDataSomeValuesFrom(OntDataProperty property, OntDataRange dr) {
        this.checkType(OntClass.DataSomeValuesFrom.class);
        return this.checkCreate(model -> OntClassImpl.createComponentRestrictionCE(model, OntClass.DataSomeValuesFrom.class, property, (RDFNode)dr, OWL2.someValuesFrom), OntClass.DataSomeValuesFrom.class);
    }

    @Override
    public OntClass.ObjectAllValuesFrom createObjectAllValuesFrom(OntObjectProperty property, OntClass ce) {
        this.checkType(OntClass.ObjectAllValuesFrom.class);
        return this.checkCreate(model -> OntClassImpl.createComponentRestrictionCE(model, OntClass.ObjectAllValuesFrom.class, property, (RDFNode)ce, OWL2.allValuesFrom), OntClass.ObjectAllValuesFrom.class);
    }

    @Override
    public OntClass.DataAllValuesFrom createDataAllValuesFrom(OntDataProperty property, OntDataRange dr) {
        this.checkType(OntClass.DataAllValuesFrom.class);
        return OntClassImpl.createComponentRestrictionCE(this, OntClass.DataAllValuesFrom.class, property, (RDFNode)dr, OWL2.allValuesFrom);
    }

    @Override
    public OntClass.ObjectHasValue createObjectHasValue(OntObjectProperty property, OntIndividual individual) {
        this.checkType(OntClass.ObjectHasValue.class);
        return OntClassImpl.createComponentRestrictionCE(this, OntClass.ObjectHasValue.class, property, (RDFNode)individual, OWL2.hasValue);
    }

    @Override
    public OntClass.DataHasValue createDataHasValue(OntDataProperty property, Literal literal) {
        this.checkType(OntClass.DataHasValue.class);
        return OntClassImpl.createComponentRestrictionCE(this, OntClass.DataHasValue.class, property, (RDFNode)literal, OWL2.hasValue);
    }

    @Override
    public OntClass.ObjectMinCardinality createObjectMinCardinality(OntObjectProperty property, int cardinality, OntClass ce) {
        this.checkType(OntClass.ObjectMinCardinality.class);
        return OntClassImpl.createCardinalityRestrictionCE(this, OntClass.ObjectMinCardinality.class, property, cardinality, ce);
    }

    @Override
    public OntClass.DataMinCardinality createDataMinCardinality(OntDataProperty property, int cardinality, OntDataRange dr) {
        this.checkType(OntClass.DataMinCardinality.class);
        return OntClassImpl.createCardinalityRestrictionCE(this, OntClass.DataMinCardinality.class, property, cardinality, dr);
    }

    @Override
    public OntClass.ObjectMaxCardinality createObjectMaxCardinality(OntObjectProperty property, int cardinality, OntClass ce) {
        this.checkType(OntClass.ObjectMaxCardinality.class);
        return this.checkCreate(model -> OntClassImpl.createCardinalityRestrictionCE(model, OntClass.ObjectMaxCardinality.class, property, cardinality, ce), OntClass.ObjectMaxCardinality.class);
    }

    @Override
    public OntClass.DataMaxCardinality createDataMaxCardinality(OntDataProperty property, int cardinality, OntDataRange dr) {
        this.checkType(OntClass.DataMaxCardinality.class);
        return this.checkCreate(model -> OntClassImpl.createCardinalityRestrictionCE(model, OntClass.DataMaxCardinality.class, property, cardinality, dr), OntClass.DataMaxCardinality.class);
    }

    @Override
    public OntClass.ObjectCardinality createObjectCardinality(OntObjectProperty property, int cardinality, OntClass ce) {
        this.checkType(OntClass.ObjectCardinality.class);
        return OntClassImpl.createCardinalityRestrictionCE(this, OntClass.ObjectCardinality.class, property, cardinality, ce);
    }

    @Override
    public OntClass.DataCardinality createDataCardinality(OntDataProperty property, int cardinality, OntDataRange dr) {
        this.checkType(OntClass.DataCardinality.class);
        return OntClassImpl.createCardinalityRestrictionCE(this, OntClass.DataCardinality.class, property, cardinality, dr);
    }

    @Override
    public OntClass.UnionOf createObjectUnionOf(Collection<OntClass> classes) {
        this.checkType(OntClass.UnionOf.class);
        return this.checkCreate(model -> OntClassImpl.createComponentsCE(model, OntClass.UnionOf.class, OntClass.class, OWL2.unionOf, classes.stream()), OntClass.UnionOf.class);
    }

    @Override
    public OntClass.IntersectionOf createObjectIntersectionOf(Collection<OntClass> classes) {
        this.checkType(OntClass.IntersectionOf.class);
        return this.checkCreate(model -> OntClassImpl.createComponentsCE(model, OntClass.IntersectionOf.class, OntClass.class, OWL2.intersectionOf, classes.stream()), OntClass.IntersectionOf.class);
    }

    @Override
    public OntClass.OneOf createObjectOneOf(Collection<OntIndividual> individuals) {
        this.checkType(OntClass.OneOf.class);
        return this.checkCreate(model -> OntClassImpl.createComponentsCE(model, OntClass.OneOf.class, OntIndividual.class, OWL2.oneOf, individuals.stream()), OntClass.OneOf.class);
    }

    @Override
    public OntClass.HasSelf createHasSelf(OntObjectProperty property) {
        this.checkType(OntClass.HasSelf.class);
        return OntClassImpl.createHasSelf(this, property);
    }

    @Override
    public OntClass.NaryDataAllValuesFrom createDataAllValuesFrom(Collection<OntDataProperty> properties, OntDataRange dr) {
        this.checkType(OntClass.NaryDataAllValuesFrom.class);
        return OntClassImpl.createNaryRestrictionCE(this, OntClass.NaryDataAllValuesFrom.class, dr, properties);
    }

    @Override
    public OntClass.NaryDataSomeValuesFrom createDataSomeValuesFrom(Collection<OntDataProperty> properties, OntDataRange dr) {
        this.checkType(OntClass.NaryDataSomeValuesFrom.class);
        return OntClassImpl.createNaryRestrictionCE(this, OntClass.NaryDataSomeValuesFrom.class, dr, properties);
    }

    @Override
    public OntClass.ComplementOf createObjectComplementOf(OntClass ce) {
        this.checkType(OntClass.ComplementOf.class);
        return this.checkCreate(model -> OntClassImpl.createComplementOf(model, ce), OntClass.ComplementOf.class);
    }

    @Override
    public OntSWRL.Variable createSWRLVariable(String uri) {
        this.checkType(OntSWRL.Variable.class);
        return OntSWRLImpl.createVariable(this, uri);
    }

    @Override
    public OntSWRL.Atom.WithBuiltin createBuiltInSWRLAtom(Resource predicate, Collection<OntSWRL.DArg> arguments) {
        this.checkType(OntSWRL.Atom.WithBuiltin.class);
        return OntSWRLImpl.createBuiltInAtom(this, predicate, arguments);
    }

    @Override
    public OntSWRL.Atom.WithClass createClassSWRLAtom(OntClass clazz, OntSWRL.IArg arg) {
        this.checkType(OntSWRL.Atom.WithClass.class);
        return OntSWRLImpl.createClassAtom(this, clazz, arg);
    }

    @Override
    public OntSWRL.Atom.WithDataRange createDataRangeSWRLAtom(OntDataRange range, OntSWRL.DArg arg) {
        this.checkType(OntSWRL.Atom.WithDataRange.class);
        return OntSWRLImpl.createDataRangeAtom(this, range, arg);
    }

    @Override
    public OntSWRL.Atom.WithDataProperty createDataPropertySWRLAtom(OntDataProperty dataProperty, OntSWRL.IArg firstArg, OntSWRL.DArg secondArg) {
        this.checkType(OntSWRL.Atom.WithDataProperty.class);
        return OntSWRLImpl.createDataPropertyAtom(this, dataProperty, firstArg, secondArg);
    }

    @Override
    public OntSWRL.Atom.WithObjectProperty createObjectPropertySWRLAtom(OntObjectProperty dataProperty, OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        this.checkType(OntSWRL.Atom.WithObjectProperty.class);
        return OntSWRLImpl.createObjectPropertyAtom(this, dataProperty, firstArg, secondArg);
    }

    @Override
    public OntSWRL.Atom.WithDifferentIndividuals createDifferentIndividualsSWRLAtom(OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        this.checkType(OntSWRL.Atom.WithDifferentIndividuals.class);
        return OntSWRLImpl.createDifferentIndividualsAtom(this, firstArg, secondArg);
    }

    @Override
    public OntSWRL.Atom.WithSameIndividuals createSameIndividualsSWRLAtom(OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        this.checkType(OntSWRL.Atom.WithSameIndividuals.class);
        return OntSWRLImpl.createSameIndividualsAtom(this, firstArg, secondArg);
    }

    @Override
    public OntSWRL.Imp createSWRLImp(Collection<OntSWRL.Atom<?>> head, Collection<OntSWRL.Atom<?>> body) {
        this.checkType(OntSWRL.Imp.class);
        return OntSWRLImpl.createImp(this, head, body);
    }

    protected <X extends OntObject> X checkCreate(Function<OntGraphModelImpl, X> creator, Class<X> type) {
        Graph thisGraph = this.getGraph();
        Graph bg = GraphMemFactory.createDefaultGraph();
        UnionGraphImpl ug = new UnionGraphImpl(bg){

            @Override
            protected void addParent(Graph graph) {
            }
        };
        ug.addSubGraph(thisGraph);
        try {
            OntGraphModelImpl m = new OntGraphModelImpl(ug, this.getOntPersonality());
            OntObject res = (OntObject)creator.apply(m);
            bg.find().forEach(arg_0 -> ((Graph)thisGraph).add(arg_0));
            return (X)((OntObject)res.inModel(this).as(type));
        }
        catch (OntJenaException.Conversion e) {
            throw new OntJenaException.Unsupported("Unable to create object " + OntEnhNodeFactories.viewAsString(type) + "; probably, it is disallowed by profile " + this.getOntPersonality().getName());
        }
    }

    public RDFDatatype getRDFDatatype(String uri) {
        return this.dtTypes.computeIfAbsent(uri, u -> {
            RDFDatatype res = TypeMapper.getInstance().getTypeByName(u);
            return res == null ? new BaseDatatype(u) : res;
        });
    }

    public PrefixMapping getPrefixMapping() {
        return this.getGraph().getPrefixMapping();
    }

    @Override
    public OntGraphModelImpl setNsPrefix(String prefix, String uri) {
        this.getPrefixMapping().setNsPrefix(prefix, uri);
        return this;
    }

    @Override
    public OntGraphModelImpl removeNsPrefix(String prefix) {
        this.getPrefixMapping().removeNsPrefix(prefix);
        return this;
    }

    @Override
    public OntGraphModelImpl clearNsPrefixMap() {
        this.getPrefixMapping().clearNsPrefixMap();
        return this;
    }

    @Override
    public OntGraphModelImpl setNsPrefixes(PrefixMapping pm) {
        this.getPrefixMapping().setNsPrefixes(pm);
        return this;
    }

    @Override
    public OntGraphModelImpl setNsPrefixes(Map<String, String> map) {
        this.getPrefixMapping().setNsPrefixes(map);
        return this;
    }

    @Override
    public OntGraphModelImpl withDefaultMappings(PrefixMapping other) {
        this.getPrefixMapping().withDefaultMappings(other);
        return this;
    }

    @Override
    public OntGraphModelImpl lock() {
        this.getPrefixMapping().lock();
        return this;
    }

    @Override
    public OntGraphModelImpl add(Statement s) {
        super.add(s);
        return this;
    }

    @Override
    public OntGraphModelImpl remove(Statement s) {
        super.remove(s);
        return this;
    }

    @Override
    public OntGraphModelImpl add(Resource s, Property p, RDFNode o) {
        super.add(s, p, o);
        return this;
    }

    @Override
    public OntGraphModelImpl remove(Resource s, Property p, RDFNode o) {
        super.remove(s, p, o);
        return this;
    }

    @Override
    public OntGraphModelImpl add(Model data) {
        UnionGraph ug = this.getUnionGraph();
        UnionGraph.EventManager em = ug.getEventManager();
        em.notifyEvent(ug, (Object)OntModelEvent.startAddDataGraphEvent(data.getGraph()));
        this.getBaseModel().add(data);
        em.notifyEvent(ug, (Object)OntModelEvent.finishAddDataGraphEvent(data.getGraph()));
        return this;
    }

    @Override
    public OntGraphModelImpl remove(Model data) {
        UnionGraph ug = this.getUnionGraph();
        UnionGraph.EventManager em = ug.getEventManager();
        em.notifyEvent(ug, (Object)OntModelEvent.startDeleteDataGraphEvent(data.getGraph()));
        this.getBaseModel().remove(data);
        em.notifyEvent(ug, (Object)OntModelEvent.finishDeleteDataGraphEvent(data.getGraph()));
        return this;
    }

    @Override
    public OntGraphModelImpl add(StmtIterator iter) {
        super.add(iter);
        return this;
    }

    @Override
    public OntGraphModelImpl remove(StmtIterator iter) {
        super.remove(iter);
        return this;
    }

    @Override
    public OntGraphModelImpl add(Statement[] statements) {
        super.add(statements);
        return this;
    }

    @Override
    public OntGraphModelImpl remove(Statement[] statements) {
        super.remove(statements);
        return this;
    }

    @Override
    public OntGraphModelImpl add(List<Statement> statements) {
        super.add(statements);
        return this;
    }

    @Override
    public OntGraphModelImpl remove(List<Statement> statements) {
        super.remove(statements);
        return this;
    }

    @Override
    public OntGraphModelImpl removeAll(Resource s, Property p, RDFNode o) {
        super.removeAll(s, p, o);
        return this;
    }

    @Override
    public OntGraphModelImpl removeAll() {
        super.removeAll();
        return this;
    }

    @Override
    public OntGraphModelImpl addLiteral(Resource s, Property p, boolean v) {
        super.addLiteral(s, p, v);
        return this;
    }

    @Override
    public OntGraphModelImpl addLiteral(Resource s, Property p, long v) {
        super.addLiteral(s, p, v);
        return this;
    }

    @Override
    public OntGraphModelImpl addLiteral(Resource s, Property p, int v) {
        super.addLiteral(s, p, v);
        return this;
    }

    @Override
    public OntGraphModelImpl addLiteral(Resource s, Property p, char v) {
        super.addLiteral(s, p, v);
        return this;
    }

    @Override
    public OntGraphModelImpl addLiteral(Resource s, Property p, float v) {
        super.addLiteral(s, p, v);
        return this;
    }

    @Override
    public OntGraphModelImpl addLiteral(Resource s, Property p, double v) {
        super.addLiteral(s, p, v);
        return this;
    }

    @Override
    public OntGraphModelImpl addLiteral(Resource s, Property p, Literal o) {
        super.addLiteral(s, p, o);
        return this;
    }

    @Override
    public OntGraphModelImpl add(Resource s, Property p, String lex) {
        super.add(s, p, lex);
        return this;
    }

    @Override
    public OntGraphModelImpl add(Resource s, Property p, String lex, RDFDatatype datatype) {
        super.add(s, p, lex, datatype);
        return this;
    }

    @Override
    public OntGraphModelImpl add(Resource s, Property p, String lex, String lang) {
        super.add(s, p, lex, lang);
        return this;
    }

    @Override
    public OntGraphModelImpl read(String url) {
        return this.read((Model it) -> it.read(url));
    }

    @Override
    public OntGraphModelImpl read(Reader reader, String base) {
        return this.read((Model it) -> it.read(reader, base));
    }

    @Override
    public OntGraphModelImpl read(InputStream reader, String base) {
        return this.read((Model it) -> it.read(reader, base));
    }

    @Override
    public OntGraphModelImpl read(String url, String lang) {
        return this.read((Model it) -> it.read(url, lang));
    }

    @Override
    public OntGraphModelImpl read(String url, String base, String lang) {
        return this.read((Model it) -> it.read(url, base, lang));
    }

    @Override
    public OntGraphModelImpl read(Reader reader, String base, String lang) {
        return this.read((Model it) -> it.read(reader, base, lang));
    }

    @Override
    public OntGraphModelImpl read(InputStream reader, String base, String lang) {
        return this.read((Model it) -> it.read(reader, base, lang));
    }

    private OntGraphModelImpl read(Consumer<Model> reader) {
        UnionGraph ug = this.getUnionGraph();
        UnionGraph.EventManager em = ug.getEventManager();
        em.notifyEvent(ug, OntModelEvent.startReadDataGraphEvent());
        reader.accept(this.getBaseModel());
        em.notifyEvent(ug, OntModelEvent.finishReadDataGraphEvent());
        this.rebind();
        return this;
    }

    @Override
    public OntGraphModelImpl write(Writer writer) {
        this.getBaseModel().write(writer);
        return this;
    }

    @Override
    public OntGraphModelImpl write(Writer writer, String lang) {
        this.getBaseModel().write(writer, lang);
        return this;
    }

    @Override
    public OntGraphModelImpl write(Writer writer, String lang, String base) {
        this.getBaseModel().write(writer, lang, base);
        return this;
    }

    @Override
    public OntGraphModelImpl write(OutputStream out) {
        this.getBaseModel().write(out);
        return this;
    }

    @Override
    public OntGraphModelImpl write(OutputStream out, String lang) {
        this.getBaseModel().write(out, lang);
        return this;
    }

    @Override
    public OntGraphModelImpl write(OutputStream out, String lang, String base) {
        this.getBaseModel().write(out, lang, base);
        return this;
    }

    @Override
    public OntModel writeAll(Writer writer, String lang, String base) {
        super.write(writer, lang, base);
        return this;
    }

    @Override
    public OntModel writeAll(Writer writer, String lang) {
        super.write(writer, lang);
        return this;
    }

    @Override
    public OntModel writeAll(OutputStream out, String lang, String base) {
        super.write(out, lang, base);
        return this;
    }

    @Override
    public OntModel writeAll(OutputStream out, String lang) {
        super.write(out, lang);
        return this;
    }

    @Override
    public OntAnnotationProperty getRDFSComment() {
        return this.findNodeAs(RDFS.Nodes.comment, OntAnnotationProperty.class);
    }

    @Override
    public OntAnnotationProperty getRDFSLabel() {
        return this.findNodeAs(RDFS.Nodes.label, OntAnnotationProperty.class);
    }

    @Override
    public OntClass.Named getOWLThing() {
        return this.findNodeAs(OWL2.Thing.asNode(), OntClass.Named.class);
    }

    @Override
    public OntDataRange.Named getRDFSLiteral() {
        return this.findNodeAs(RDFS.Literal.asNode(), OntDataRange.Named.class);
    }

    @Override
    public OntClass.Named getOWLNothing() {
        return this.findNodeAs(OWL2.Nothing.asNode(), OntClass.Named.class);
    }

    @Override
    public OntObjectProperty.Named getOWLTopObjectProperty() {
        return this.findNodeAs(OWL2.topObjectProperty.asNode(), OntObjectProperty.Named.class);
    }

    @Override
    public OntObjectProperty.Named getOWLBottomObjectProperty() {
        return this.findNodeAs(OWL2.bottomObjectProperty.asNode(), OntObjectProperty.Named.class);
    }

    @Override
    public OntDataProperty getOWLTopDataProperty() {
        return this.findNodeAs(OWL2.topDataProperty.asNode(), OntDataProperty.class);
    }

    @Override
    public OntDataProperty getOWLBottomDataProperty() {
        return this.findNodeAs(OWL2.bottomDataProperty.asNode(), OntDataProperty.class);
    }

    public Reasoner getReasoner() {
        InfGraph g = this.getInfGraph();
        return g != null ? g.getReasoner() : null;
    }

    public void setDerivationLogging(boolean logOn) {
        InfGraph graph = this.getInfGraph();
        if (graph != null) {
            graph.setDerivationLogging(logOn);
        }
    }

    public Iterator<Derivation> getDerivation(Statement statement) {
        return this.getGraph() instanceof InfGraph ? ((InfGraph)this.getGraph()).getDerivation(statement.asTriple()) : null;
    }

    public InfGraph getInfGraph() {
        return this.graph instanceof InfGraph ? (InfGraph)this.graph : null;
    }

    public void rebind() {
        InfGraph graph = this.getInfGraph();
        if (graph != null) {
            graph.rebind();
        }
    }

    public void prepare() {
        InfGraph graph = this.getInfGraph();
        if (graph != null) {
            graph.prepare();
        }
    }

    public void reset() {
        InfGraph graph = this.getInfGraph();
        if (graph != null) {
            graph.reset();
        }
    }

    public ValidityReport validate() {
        InfGraph graph = this.getInfGraph();
        return graph != null ? graph.validate() : null;
    }

    public StmtIterator listStatements(Resource subject, Property predicate, RDFNode object, Model posit) {
        InfGraph graph = this.getInfGraph();
        if (graph != null) {
            Graph gp = posit == null ? GraphMemFactory.createDefaultGraph() : posit.getGraph();
            ExtendedIterator iter = graph.find(OntGraphModelImpl.asNode((RDFNode)subject), OntGraphModelImpl.asNode((RDFNode)predicate), OntGraphModelImpl.asNode((RDFNode)object), gp);
            return IteratorFactory.asStmtIterator((Iterator)iter, (ModelCom)this);
        }
        return null;
    }

    @Override
    public InfModel asInferenceModel() {
        if (this.getInfGraph() != null) {
            return this;
        }
        throw new OntJenaException.Unsupported("No reasoner attached. Inference is not supported");
    }

    public Model getDeductionsModel() {
        if (this.deductionsModel == null) {
            Graph deductionsGraph;
            InfGraph infGraph = this.getInfGraph();
            if (infGraph != null && (deductionsGraph = infGraph.getDeductionsGraph()) != null) {
                this.deductionsModel = new ModelCom(deductionsGraph);
            }
        } else {
            Objects.requireNonNull(this.getInfGraph()).prepare();
        }
        return this.deductionsModel;
    }

    public Model getRawModel() {
        return this.getBaseModel();
    }

    private Model getReasonerCapabilities() {
        Reasoner reasoner = this.getReasoner();
        return reasoner != null ? reasoner.getReasonerCapabilities() : null;
    }

    @Override
    public <N extends RDFNode> N findNodeAs(Node node, Class<N> type) {
        try {
            return this.getNodeAs(node, type);
        }
        catch (OntJenaException.Conversion ignore) {
            return null;
        }
    }

    @Override
    public <N extends RDFNode> N getNodeAs(Node node, Class<N> type) {
        try {
            return this.getNodeAsInternal(node, type);
        }
        catch (OntJenaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OntJenaException.Conversion(String.format("Failed to convert node <%s> to <%s>. Profile <%s>", node, OntEnhNodeFactories.viewAsString(type), this.getOntPersonality().getName()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <N extends RDFNode> N safeFindNodeAs(Node node, Class<N> type) {
        Set<Node> nodes = this.visited.get();
        try {
            if (nodes.add(node)) {
                N n = this.getNodeAsInternal(node, type);
                return n;
            }
            try {
                throw new OntJenaException.Recursion("Can't cast to " + OntEnhNodeFactories.viewAsString(type) + ": graph contains a recursion for node <" + String.valueOf(node) + ">");
            }
            catch (PersonalityConfigException | OntJenaException.Conversion r) {
                N n = null;
                return n;
            }
        }
        finally {
            nodes.remove(node);
        }
    }

    protected <N extends RDFNode> N getNodeAsInternal(Node node, Class<N> type) {
        return (N)super.getNodeAs(Objects.requireNonNull(node, "Null node"), Objects.requireNonNull(type, "Null class view."));
    }
}

