/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.ASortedMap;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.jena.RdfBeanMeta;
import org.apache.juneau.jena.RdfBeanPropertyMeta;
import org.apache.juneau.jena.RdfClassMeta;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfCommon;
import org.apache.juneau.jena.RdfMetaProvider;
import org.apache.juneau.jena.RdfSerializerBuilder;
import org.apache.juneau.jena.RdfSerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlBeanMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlMetaProvider;

@ConfigurableContext(prefixes={"RdfCommon", "RdfSerializer"})
public class RdfSerializer
extends WriterSerializer
implements RdfCommon,
RdfMetaProvider {
    private static final Namespace DEFAULT_JUNEAU_NS = Namespace.create((String)"j", (String)"http://www.apache.org/juneau/");
    private static final Namespace DEFAULT_JUNEAUBP_NS = Namespace.create((String)"jp", (String)"http://www.apache.org/juneaubp/");
    static final String PREFIX = "RdfSerializer";
    public static final String RDF_addBeanTypes = "RdfSerializer.addBeanTypes.b";
    public static final String RDF_addLiteralTypes = "RdfSerializer.addLiteralTypes.b";
    public static final String RDF_addRootProperty = "RdfSerializer.addRootProperty.b";
    public static final String RDF_autoDetectNamespaces = "RdfSerializer.autoDetectNamespaces.b";
    public static final String RDF_namespaces = "RdfSerializer.namespaces.ls";
    public static final String RDF_useXmlNamespaces = "RdfSerializer.useXmlNamespaces.b";
    private final boolean addLiteralTypes;
    private final boolean addRootProperty;
    private final boolean useXmlNamespaces;
    private final boolean looseCollections;
    private final boolean autoDetectNamespaces;
    private final boolean addBeanTypes;
    private final String rdfLanguage;
    private final Namespace juneauNs;
    private final Namespace juneauBpNs;
    private final RdfCollectionFormat collectionFormat;
    final Map<String, Object> jenaProperties;
    final Namespace[] namespaces;
    private final Map<ClassMeta<?>, RdfClassMeta> rdfClassMetas = new ConcurrentHashMap();
    private final Map<BeanMeta<?>, RdfBeanMeta> rdfBeanMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, RdfBeanPropertyMeta> rdfBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, RdfBeanPropertyMeta>();
    private final Map<ClassMeta<?>, XmlClassMeta> xmlClassMetas = new ConcurrentHashMap();
    private final Map<BeanMeta<?>, XmlBeanMeta> xmlBeanMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, XmlBeanPropertyMeta> xmlBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, XmlBeanPropertyMeta>();

    public RdfSerializer(PropertyStore ps, String produces, String accept) {
        super(ps, produces, accept);
        this.addLiteralTypes = this.getBooleanProperty(RDF_addLiteralTypes, false);
        this.addRootProperty = this.getBooleanProperty(RDF_addRootProperty, false);
        this.useXmlNamespaces = this.getBooleanProperty(RDF_useXmlNamespaces, true);
        this.looseCollections = this.getBooleanProperty("RdfCommon.looseCollections.b", false);
        this.autoDetectNamespaces = this.getBooleanProperty(RDF_autoDetectNamespaces, true);
        this.rdfLanguage = this.getStringProperty("RdfCommon.language.s", "RDF/XML-ABBREV");
        this.juneauNs = (Namespace)this.getProperty("RdfCommon.juneauNs.s", Namespace.class, DEFAULT_JUNEAU_NS);
        this.juneauBpNs = (Namespace)this.getProperty("RdfCommon.juneauBpNs.s", Namespace.class, DEFAULT_JUNEAUBP_NS);
        this.collectionFormat = (RdfCollectionFormat)((Object)this.getProperty("RdfCommon.collectionFormat.s", RdfCollectionFormat.class, (Object)RdfCollectionFormat.DEFAULT));
        this.namespaces = (Namespace[])this.getProperty(RDF_namespaces, Namespace[].class, new Namespace[0]);
        this.addBeanTypes = this.getBooleanProperty(RDF_addBeanTypes, this.getBooleanProperty("Serializer.addBeanTypes.b", false));
        ASortedMap m = ASortedMap.of();
        for (String k : this.getPropertyKeys("RdfCommon")) {
            if (!k.startsWith("jena.")) continue;
            m.put((Object)k.substring(5), this.getProperty("RdfCommon." + k));
        }
        this.jenaProperties = m.unmodifiable();
    }

    public RdfSerializer(PropertyStore ps) {
        this(ps, RdfSerializer.getProduces(ps), null);
    }

    private static String getProduces(PropertyStore ps) {
        String rdfLanguage;
        switch (rdfLanguage = (String)ps.getProperty("RdfCommon.language.s", String.class, (Object)"RDF/XML-ABBREV")) {
            case "RDF/XML": {
                return "text/xml+rdf+abbrev";
            }
            case "RDF/XML-ABBREV": {
                return "text/xml+rdf";
            }
            case "N-TRIPLE": {
                return "text/n-triple";
            }
            case "N3": {
                return "text/n3";
            }
            case "N3-PP": {
                return "text/n3-pp";
            }
            case "N3-PLAIN": {
                return "text/n3-plain";
            }
            case "N3-TRIPLES": {
                return "text/n3-triples";
            }
            case "TURTLE": {
                return "text/turtle";
            }
        }
        return "text/xml+rdf";
    }

    public RdfSerializerBuilder builder() {
        return new RdfSerializerBuilder(this.getPropertyStore());
    }

    public static RdfSerializerBuilder create() {
        return new RdfSerializerBuilder();
    }

    public RdfSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    public RdfSerializerSession createSession(SerializerSessionArgs args) {
        return new RdfSerializerSession(this, args);
    }

    @Override
    public RdfClassMeta getRdfClassMeta(ClassMeta<?> cm) {
        RdfClassMeta m = this.rdfClassMetas.get(cm);
        if (m == null) {
            m = new RdfClassMeta(cm, this);
            this.rdfClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public RdfBeanMeta getRdfBeanMeta(BeanMeta<?> bm) {
        RdfBeanMeta m = this.rdfBeanMetas.get(bm);
        if (m == null) {
            m = new RdfBeanMeta(bm, this);
            this.rdfBeanMetas.put(bm, m);
        }
        return m;
    }

    @Override
    public RdfBeanPropertyMeta getRdfBeanPropertyMeta(BeanPropertyMeta bpm) {
        RdfBeanPropertyMeta m = this.rdfBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new RdfBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.rdfBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    public XmlClassMeta getXmlClassMeta(ClassMeta<?> cm) {
        XmlClassMeta m = this.xmlClassMetas.get(cm);
        if (m == null) {
            m = new XmlClassMeta(cm, (XmlMetaProvider)this);
            this.xmlClassMetas.put(cm, m);
        }
        return m;
    }

    public XmlBeanMeta getXmlBeanMeta(BeanMeta<?> bm) {
        XmlBeanMeta m = this.xmlBeanMetas.get(bm);
        if (m == null) {
            m = new XmlBeanMeta(bm, (XmlMetaProvider)this);
            this.xmlBeanMetas.put(bm, m);
        }
        return m;
    }

    public XmlBeanPropertyMeta getXmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        XmlBeanPropertyMeta m = this.xmlBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new XmlBeanPropertyMeta(bpm.getDelegateFor(), (XmlMetaProvider)this);
            this.xmlBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    protected final RdfCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    protected final Namespace getJuneauBpNs() {
        return this.juneauBpNs;
    }

    protected final Namespace getJuneauNs() {
        return this.juneauNs;
    }

    protected final String getLanguage() {
        return this.rdfLanguage;
    }

    protected final boolean isLooseCollections() {
        return this.looseCollections;
    }

    protected final Map<String, Object> getJenaProperties() {
        return this.jenaProperties;
    }

    protected final boolean isAddBeanTypes() {
        return this.addBeanTypes;
    }

    protected final boolean isAddLiteralTypes() {
        return this.addLiteralTypes;
    }

    protected final boolean isAddRootProp() {
        return this.addRootProperty;
    }

    protected final boolean isAutoDetectNamespaces() {
        return this.autoDetectNamespaces;
    }

    public Namespace[] getNamespaces() {
        return this.namespaces;
    }

    protected final boolean isUseXmlNamespaces() {
        return this.useXmlNamespaces;
    }

    public OMap toMap() {
        return super.toMap().a(PREFIX, (Object)new DefaultFilteringOMap().a("addLiteralTypes", (Object)this.addLiteralTypes).a("addRootProperty", (Object)this.addRootProperty).a("useXmlNamespaces", (Object)this.useXmlNamespaces).a("looseCollections", (Object)this.looseCollections).a("autoDetectNamespaces", (Object)this.autoDetectNamespaces).a("rdfLanguage", (Object)this.rdfLanguage).a("juneauNs", (Object)this.juneauNs).a("juneauBpNs", (Object)this.juneauBpNs).a("collectionFormat", (Object)this.collectionFormat).a("namespaces", (Object)this.namespaces).a("addBeanTypes", (Object)this.addBeanTypes));
    }
}

