/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.Context;
import org.apache.juneau.ContextCache;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConfigAnnotationFilter;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;

public abstract class ContextBuilder {
    private final PropertyStoreBuilder psb;

    public ContextBuilder() {
        this.psb = PropertyStore.create();
    }

    public ContextBuilder(PropertyStore ps) {
        if (ps == null) {
            ps = PropertyStore.DEFAULT;
        }
        this.psb = ps.builder();
    }

    protected ContextBuilder(PropertyStoreBuilder psb) {
        this.psb = psb;
    }

    protected PropertyStoreBuilder getPropertyStoreBuilder() {
        return this.psb;
    }

    public abstract Context build();

    @FluentSetter
    public ContextBuilder apply(PropertyStore copyFrom) {
        this.psb.apply(copyFrom);
        return this;
    }

    @FluentSetter
    public ContextBuilder applyAnnotations(AnnotationList al, VarResolverSession r) {
        this.psb.applyAnnotations(al, r);
        return this;
    }

    @FluentSetter
    public ContextBuilder applyAnnotations(Class<?> ... fromClasses) {
        for (Class<?> c : fromClasses) {
            this.applyAnnotations(ClassInfo.of(c).getAnnotationList(ConfigAnnotationFilter.INSTANCE), VarResolver.DEFAULT.createSession());
        }
        return this;
    }

    @FluentSetter
    public ContextBuilder applyAnnotations(Method ... fromMethods) {
        for (Method m : fromMethods) {
            this.applyAnnotations(MethodInfo.of(m).getAnnotationList(ConfigAnnotationFilter.INSTANCE), VarResolver.DEFAULT.createSession());
        }
        return this;
    }

    public <T extends Context> T build(Class<T> c) {
        return ContextCache.INSTANCE.create(c, this.getPropertyStore());
    }

    public PropertyStore getPropertyStore() {
        return this.psb.build();
    }

    @FluentSetter
    public ContextBuilder debug() {
        return this.set("Context.debug.b", true);
    }

    @FluentSetter
    public ContextBuilder locale(Locale value) {
        return this.set("Context.locale.s", value);
    }

    @FluentSetter
    public ContextBuilder mediaType(MediaType value) {
        return this.set("Context.mediaType.s", value);
    }

    @FluentSetter
    public ContextBuilder timeZone(TimeZone value) {
        return this.set("Context.timeZone.s", value);
    }

    @FluentSetter
    public ContextBuilder set(String name, Object value) {
        this.psb.set(name, value);
        return this;
    }

    public Object peek(String key) {
        return this.psb.peek(key);
    }

    public <T> T peek(Class<T> c, String key) {
        return this.psb.peek(c, key);
    }

    @FluentSetter
    public ContextBuilder set(Map<String, Object> properties) {
        this.psb.set(properties);
        return this;
    }

    @FluentSetter
    public ContextBuilder add(Map<String, Object> properties) {
        this.psb.add(properties);
        return this;
    }

    @FluentSetter
    public ContextBuilder addTo(String name, Object value) {
        this.psb.addTo(name, value);
        return this;
    }

    @FluentSetter
    public ContextBuilder appendTo(String name, Object value) {
        this.psb.appendTo(name, value);
        return this;
    }

    @FluentSetter
    public ContextBuilder prependTo(String name, Object value) {
        this.psb.prependTo(name, value);
        return this;
    }

    @FluentSetter
    public ContextBuilder putTo(String name, String key, Object value) {
        this.psb.putTo(name, key, value);
        return this;
    }

    @FluentSetter
    public ContextBuilder putAllTo(String name, Object value) {
        this.psb.putAllTo(name, value);
        return this;
    }

    @FluentSetter
    public ContextBuilder removeFrom(String name, Object value) {
        this.psb.removeFrom(name, value);
        return this;
    }
}

