/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.soap;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.soap.SoapXmlBeanPropertyMeta;
import org.apache.juneau.soap.SoapXmlClassMeta;
import org.apache.juneau.soap.SoapXmlCommon;
import org.apache.juneau.soap.SoapXmlMetaProvider;
import org.apache.juneau.soap.SoapXmlSerializerBuilder;
import org.apache.juneau.soap.SoapXmlSerializerSession;
import org.apache.juneau.xml.XmlSerializer;

@ConfigurableContext
public final class SoapXmlSerializer
extends XmlSerializer
implements SoapXmlMetaProvider,
SoapXmlCommon {
    static final String PREFIX = "SoapXmlSerializer";
    public static final String SOAPXML_SOAPAction = "SoapXmlSerializer.SOAPAction.s";
    final String soapAction;
    private final Map<ClassMeta<?>, SoapXmlClassMeta> soapXmlClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, SoapXmlBeanPropertyMeta> soapXmlBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, SoapXmlBeanPropertyMeta>();

    public SoapXmlSerializer(PropertyStore ps) {
        super(ps, "text/xml", "text/xml+soap");
        this.soapAction = this.getStringProperty(SOAPXML_SOAPAction, "http://www.w3.org/2003/05/soap-envelope");
    }

    @Override
    public SoapXmlSerializerBuilder builder() {
        return new SoapXmlSerializerBuilder(this.getPropertyStore());
    }

    public static SoapXmlSerializerBuilder create() {
        return new SoapXmlSerializerBuilder();
    }

    @Override
    public SoapXmlSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public SoapXmlSerializerSession createSession(SerializerSessionArgs args) {
        return new SoapXmlSerializerSession(this, args);
    }

    @Override
    public SoapXmlClassMeta getSoapXmlClassMeta(ClassMeta<?> cm) {
        SoapXmlClassMeta m = this.soapXmlClassMetas.get(cm);
        if (m == null) {
            m = new SoapXmlClassMeta(cm, this);
            this.soapXmlClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public SoapXmlBeanPropertyMeta getSoapXmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return SoapXmlBeanPropertyMeta.DEFAULT;
        }
        SoapXmlBeanPropertyMeta m = this.soapXmlBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new SoapXmlBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.soapXmlBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap().a("soapAction", this.soapAction));
    }
}

