/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.util.function.Supplier;
import org.apache.juneau.internal.StringUtils;

public class Verify {
    private final Object o;
    private Supplier<String> msg;

    public static Verify verify(Object o) {
        return new Verify(o);
    }

    protected Verify(Object o) {
        this.o = o;
    }

    public Verify msg(String msg, Object args) {
        this.msg = () -> StringUtils.format(msg, args);
        return this;
    }

    public String isType(Class<?> type) {
        if (type == null && this.o == null) {
            return null;
        }
        if (type != null && type.isInstance(this.o)) {
            return null;
        }
        return this.msg != null ? this.msg.get() : StringUtils.format("Expected type [{0}] but was [{1}].", type, this.o == null ? null : this.o.getClass());
    }

    public String is(Object expected) {
        if (expected == this.o) {
            return null;
        }
        if (expected == null || this.o == null) {
            return this.msg != null ? this.msg.get() : StringUtils.format("Expected [{0}] but was [{1}].", expected, this.o);
        }
        if (!expected.equals(this.o)) {
            return this.msg != null ? this.msg.get() : StringUtils.format("Expected [{0}] but was [{1}].", expected, this.o);
        }
        return null;
    }

    public String isTrue() {
        return this.is(true);
    }

    public String isFalse() {
        return this.is(false);
    }
}

