/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.json.JsonBeanPropertyMeta;
import org.apache.juneau.json.JsonClassMeta;
import org.apache.juneau.json.JsonCommon;
import org.apache.juneau.json.JsonMetaProvider;
import org.apache.juneau.json.JsonParserBuilder;
import org.apache.juneau.json.JsonParserSession;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.ReaderParser;

@ConfigurableContext
public class JsonParser
extends ReaderParser
implements JsonMetaProvider,
JsonCommon {
    static final String PREFIX = "JsonParser";
    public static final String JSON_validateEnd = "JsonParser.validateEnd.b";
    public static final JsonParser DEFAULT = new JsonParser(PropertyStore.DEFAULT);
    public static final JsonParser DEFAULT_STRICT = new Strict(PropertyStore.DEFAULT);
    private final boolean validateEnd;
    private final Map<ClassMeta<?>, JsonClassMeta> jsonClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, JsonBeanPropertyMeta> jsonBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, JsonBeanPropertyMeta>();

    public JsonParser(PropertyStore ps) {
        this(ps, "application/json", "text/json");
    }

    public JsonParser(PropertyStore ps, String ... consumes) {
        super(ps, consumes);
        this.validateEnd = this.getBooleanProperty(JSON_validateEnd, false);
    }

    @Override
    public JsonParserBuilder builder() {
        return new JsonParserBuilder(this.getPropertyStore());
    }

    public static JsonParserBuilder create() {
        return new JsonParserBuilder();
    }

    @Override
    public JsonParserSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public JsonParserSession createSession(ParserSessionArgs args) {
        return new JsonParserSession(this, args);
    }

    @Override
    public JsonClassMeta getJsonClassMeta(ClassMeta<?> cm) {
        JsonClassMeta m = this.jsonClassMetas.get(cm);
        if (m == null) {
            m = new JsonClassMeta(cm, this);
            this.jsonClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public JsonBeanPropertyMeta getJsonBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return JsonBeanPropertyMeta.DEFAULT;
        }
        JsonBeanPropertyMeta m = this.jsonBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new JsonBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.jsonBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    protected final boolean isValidateEnd() {
        return this.validateEnd;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap());
    }

    public static class Strict
    extends JsonParser {
        public Strict(PropertyStore ps) {
            super(ps.builder().setDefault("Parser.strict.b", true).setDefault(JsonParser.JSON_validateEnd, true).build());
        }
    }
}

