/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParserSession;

public class ParserListener {
    public <T> void onUnknownBeanProperty(ParserSession session, String propertyName, Class<T> beanClass, T bean) {
        this.onError(session, null, StringUtils.format("Unknown property ''{0}'' encountered while trying to parse into class ''{1}'' at location {2}", propertyName, beanClass, session.getPosition()));
    }

    public void onBeanSetterException(ParserSession session, Throwable t, BeanPropertyMeta p) {
        this.onError(session, t, StringUtils.format("Could not call setValue() on property ''{0}'' of class ''{1}'', exception = {2}", p.getName(), p.getBeanMeta().getClassMeta(), t.getLocalizedMessage()));
    }

    public void onError(ParserSession session, Throwable t, String msg) {
    }

    public static final class Null
    extends ParserListener {
    }
}

