/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.internal.ConfigMap;
import org.apache.juneau.config.internal.ConfigMapEntry;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;

public class Entry {
    private final ConfigMapEntry configEntry;
    private final Config config;
    private final String value;

    protected Entry(Config config, ConfigMap configMap, String sectionName, String entryName) {
        this.configEntry = configMap.getEntry(sectionName, entryName);
        this.config = config;
        this.value = this.configEntry == null ? null : config.removeMods(this.configEntry.getModifiers(), this.configEntry.getValue());
    }

    public boolean isPresent() {
        return !this.isNull();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public String get() {
        if (this.isNull()) {
            throw new NullPointerException("Value was null");
        }
        return this.toString();
    }

    public String orElse(String def) {
        return this.isNull() ? def : this.get();
    }

    public String orElseGet(Supplier<String> def) {
        return this.isNull() ? def.get() : this.get();
    }

    public <T> Optional<T> as(Class<T> type) {
        return this.as(type, new Type[0]);
    }

    public <T> Optional<T> as(Type type, Type ... args) {
        return this.as(this.config.parser, type, args);
    }

    public <T> Optional<T> as(Parser parser, Type type, Type ... args) {
        if (this.isNull()) {
            return CollectionUtils.empty();
        }
        try {
            Object v = this.toString();
            if (type == String.class) {
                return this.asString();
            }
            if (type == String[].class) {
                return this.asStringArray();
            }
            if (type == byte[].class) {
                return this.asBytes();
            }
            if (type == Integer.TYPE || type == Integer.TYPE || type == Integer.class) {
                return this.asInteger();
            }
            if (type == Long.TYPE || type == Long.class) {
                return this.asLong();
            }
            if (type == JsonMap.class) {
                return this.asMap();
            }
            if (type == JsonList.class) {
                return this.asList();
            }
            if (this.isEmpty()) {
                return CollectionUtils.empty();
            }
            if (this.isSimpleType(type)) {
                return CollectionUtils.optional(this.config.beanSession.convertToType(v, (Class)type));
            }
            if (parser instanceof JsonParser) {
                char s1 = StringUtils.firstNonWhitespaceChar((String)v);
                if (this.isArray(type) && s1 != '[') {
                    v = "[" + (String)v + "]";
                } else if (s1 != '[' && s1 != '{' && !"null".equals(v)) {
                    v = "'" + (String)v + "'";
                }
            }
            return CollectionUtils.optional(parser.parse((String)v, type, args));
        }
        catch (ParseException e) {
            throw new BeanRuntimeException((Throwable)e, null, "Value could not be parsed.", new Object[0]);
        }
    }

    public <T> Optional<T> as(Parser parser, Class<T> type) {
        return this.as(parser, type, new Type[0]);
    }

    public String toString() {
        return this.isPresent() ? this.config.varSession.resolve(this.value) : null;
    }

    public Optional<String> asString() {
        return CollectionUtils.optional(this.isPresent() ? this.config.varSession.resolve(this.value) : null);
    }

    public Optional<String[]> asStringArray() {
        if (!this.isPresent()) {
            return CollectionUtils.empty();
        }
        String v = this.toString();
        char s1 = StringUtils.firstNonWhitespaceChar(v);
        char s2 = StringUtils.lastNonWhitespaceChar(v);
        if (s1 == '[' && s2 == ']' && this.config.parser instanceof JsonParser) {
            try {
                return CollectionUtils.optional(this.config.parser.parse(v, String[].class));
            }
            catch (ParseException e) {
                throw new BeanRuntimeException(e);
            }
        }
        return CollectionUtils.optional(StringUtils.split(v));
    }

    public Optional<Integer> asInteger() {
        return CollectionUtils.optional(this.isEmpty() ? null : Integer.valueOf(StringUtils.parseIntWithSuffix(this.toString())));
    }

    public Optional<Boolean> asBoolean() {
        return CollectionUtils.optional(this.isEmpty() ? null : Boolean.valueOf(Boolean.parseBoolean(this.toString())));
    }

    public Optional<Long> asLong() {
        return CollectionUtils.optional(this.isEmpty() ? null : Long.valueOf(StringUtils.parseLongWithSuffix(this.toString())));
    }

    public Optional<Double> asDouble() {
        return CollectionUtils.optional(this.isEmpty() ? null : Double.valueOf(this.toString()));
    }

    public Optional<Float> asFloat() {
        return CollectionUtils.optional(this.isEmpty() ? null : Float.valueOf(this.toString()));
    }

    public Optional<byte[]> asBytes() {
        if (this.isNull()) {
            return CollectionUtils.empty();
        }
        String s = this.toString();
        if (s.indexOf(10) != -1) {
            s = s.replaceAll("\n", "");
        }
        try {
            if (this.config.binaryFormat == BinaryFormat.HEX) {
                return CollectionUtils.optional(StringUtils.fromHex(s));
            }
            if (this.config.binaryFormat == BinaryFormat.SPACED_HEX) {
                return CollectionUtils.optional(StringUtils.fromSpacedHex(s));
            }
            return CollectionUtils.optional(StringUtils.base64Decode(s));
        }
        catch (Exception e) {
            throw new BeanRuntimeException((Throwable)e, null, "Value could not be converted to a byte array.", new Object[0]);
        }
    }

    public Optional<JsonMap> asMap() throws ParseException {
        return this.asMap(this.config.parser);
    }

    public Optional<JsonMap> asMap(Parser parser) throws ParseException {
        char s1;
        if (this.isNull()) {
            return CollectionUtils.empty();
        }
        if (parser == null) {
            parser = this.config.parser;
        }
        Object s = this.toString();
        if (parser instanceof JsonParser && (s1 = StringUtils.firstNonWhitespaceChar((String)s)) != '{' && !"null".equals(s)) {
            s = "{" + (String)s + "}";
        }
        return CollectionUtils.optional(JsonMap.ofText((CharSequence)s, parser));
    }

    public Optional<JsonList> asList() throws ParseException {
        return this.asList(this.config.parser);
    }

    public Optional<JsonList> asList(Parser parser) throws ParseException {
        char s1;
        if (this.isNull()) {
            return CollectionUtils.empty();
        }
        if (parser == null) {
            parser = this.config.parser;
        }
        Object s = this.toString();
        if (parser instanceof JsonParser && (s1 = StringUtils.firstNonWhitespaceChar((String)s)) != '[' && !"null".equals(s)) {
            s = "[" + (String)s + "]";
        }
        return CollectionUtils.optional(JsonList.ofText((CharSequence)s, parser));
    }

    public String getKey() {
        return this.configEntry.getKey();
    }

    public String getValue() {
        return this.configEntry.getValue();
    }

    public String getComment() {
        return this.configEntry.getComment();
    }

    public List<String> getPreLines() {
        return this.configEntry.getPreLines();
    }

    public String getModifiers() {
        return this.configEntry.getModifiers();
    }

    private boolean isEmpty() {
        return StringUtils.isEmpty(this.value);
    }

    private boolean isNull() {
        return this.value == null;
    }

    private boolean isArray(Type t) {
        if (!(t instanceof Class)) {
            return false;
        }
        Class c = (Class)t;
        return c.isArray();
    }

    private boolean isSimpleType(Type t) {
        if (!(t instanceof Class)) {
            return false;
        }
        Class c = (Class)t;
        return c == String.class || c.isPrimitive() || c.isAssignableFrom(Number.class) || c == Boolean.class || c.isEnum();
    }
}

