/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.CollectionUtils;

public class ReflectionMap<V> {
    final ClassEntry<V>[] classEntries;
    final MethodEntry<V>[] methodEntries;
    final FieldEntry<V>[] fieldEntries;
    final ConstructorEntry<V>[] constructorEntries;

    public static <V> Builder<V> create(Class<V> c) {
        return new Builder();
    }

    protected ReflectionMap(Builder<V> b) {
        this.classEntries = b.classEntries.toArray(new ClassEntry[b.classEntries.size()]);
        this.methodEntries = b.methodEntries.toArray(new MethodEntry[b.methodEntries.size()]);
        this.fieldEntries = b.fieldEntries.toArray(new FieldEntry[b.fieldEntries.size()]);
        this.constructorEntries = b.constructorEntries.toArray(new ConstructorEntry[b.constructorEntries.size()]);
    }

    static void splitNames(String key, Consumer<String> consumer) {
        if (key.indexOf(44) == -1) {
            consumer.accept(key);
        } else {
            int m = 0;
            boolean escaped = false;
            for (int i = 0; i < key.length(); ++i) {
                char c = key.charAt(i);
                if (c == '(') {
                    escaped = true;
                    continue;
                }
                if (c == ')') {
                    escaped = false;
                    continue;
                }
                if (c != ',' || escaped) continue;
                consumer.accept(key.substring(m, i).trim());
                m = i + 1;
            }
            consumer.accept(key.substring(m).trim());
        }
    }

    public Optional<V> find(Class<?> c, Class<? extends V> ofType) {
        for (ClassEntry<V> e : this.classEntries) {
            if (!e.matches(c) || ofType != null && !ofType.isInstance(e.value)) continue;
            return CollectionUtils.optional(e.value);
        }
        return CollectionUtils.empty();
    }

    public Optional<V> find(Class<?> c) {
        return this.find(c, null);
    }

    public List<V> findAll(Class<?> c, Class<? extends V> ofType) {
        List list = null;
        for (ClassEntry<V> e : this.classEntries) {
            if (!e.matches(c) || e.value == null || ofType != null && !ofType.isInstance(e.value)) continue;
            list = ReflectionMap.lazyAdd(list, e.value);
        }
        return ReflectionMap.lazyList(list);
    }

    public List<V> findAll(Class<?> c) {
        List list = null;
        for (ClassEntry<V> e : this.classEntries) {
            if (!e.matches(c) || e.value == null) continue;
            list = ReflectionMap.lazyAdd(list, e.value);
        }
        return ReflectionMap.lazyList(list);
    }

    public V[] appendAll(Class<?> c, Class<? extends V> ofType, V[] array) {
        List<V> list = null;
        for (ClassEntry<V> e : this.classEntries) {
            if (!e.matches(c) || e.value == null || ofType != null && !ofType.isInstance(e.value)) continue;
            list = ReflectionMap.lazyAdd(array, list, e.value);
        }
        return ReflectionMap.lazyArray(array, list);
    }

    private static <V> List<V> lazyAdd(List<V> list, V v) {
        if (list == null) {
            list = CollectionUtils.list(new Object[0]);
        }
        list.add(v);
        return list;
    }

    public Optional<V> find(Method m, Class<? extends V> ofType) {
        for (MethodEntry<V> e : this.methodEntries) {
            if (!e.matches(m) || ofType != null && !ofType.isInstance(e.value)) continue;
            return CollectionUtils.optional(e.value);
        }
        return CollectionUtils.empty();
    }

    public Optional<V> find(Method m) {
        return this.find(m, null);
    }

    public List<V> findAll(Method m, Class<? extends V> ofType) {
        List list = null;
        for (MethodEntry<V> e : this.methodEntries) {
            if (!e.matches(m) || e.value == null || ofType != null && !ofType.isInstance(e.value)) continue;
            list = ReflectionMap.lazyAdd(list, e.value);
        }
        return ReflectionMap.lazyList(list);
    }

    public List<V> findAll(Method m) {
        List list = null;
        for (MethodEntry<V> e : this.methodEntries) {
            if (!e.matches(m) || e.value == null) continue;
            list = ReflectionMap.lazyAdd(list, e.value);
        }
        return ReflectionMap.lazyList(list);
    }

    public V[] appendAll(Method m, Class<? extends V> ofType, V[] array) {
        List<V> list = null;
        for (MethodEntry<V> e : this.methodEntries) {
            if (!e.matches(m) || e.value == null || ofType != null && !ofType.isInstance(e.value)) continue;
            list = ReflectionMap.lazyAdd(array, list, e.value);
        }
        return ReflectionMap.lazyArray(array, list);
    }

    public Optional<V> find(Field f, Class<? extends V> ofType) {
        for (FieldEntry<V> e : this.fieldEntries) {
            if (!e.matches(f) || ofType != null && !ofType.isInstance(e.value)) continue;
            return CollectionUtils.optional(e.value);
        }
        return CollectionUtils.empty();
    }

    public Optional<V> find(Field f) {
        return this.find(f, null);
    }

    public List<V> findAll(Field f, Class<? extends V> ofType) {
        List list = null;
        for (FieldEntry<V> e : this.fieldEntries) {
            if (!e.matches(f) || e.value == null || ofType != null && !ofType.isInstance(e.value)) continue;
            list = ReflectionMap.lazyAdd(list, e.value);
        }
        return ReflectionMap.lazyList(list);
    }

    public List<V> findAll(Field f) {
        List list = null;
        for (FieldEntry<V> e : this.fieldEntries) {
            if (!e.matches(f) || e.value == null) continue;
            list = ReflectionMap.lazyAdd(list, e.value);
        }
        return ReflectionMap.lazyList(list);
    }

    public V[] appendAll(Field f, Class<? extends V> ofType, V[] array) {
        List<V> list = null;
        for (FieldEntry<V> e : this.fieldEntries) {
            if (!e.matches(f) || e.value == null || ofType != null && !ofType.isInstance(e.value)) continue;
            list = ReflectionMap.lazyAdd(array, list, e.value);
        }
        return ReflectionMap.lazyArray(array, list);
    }

    public Optional<V> find(Constructor<?> c, Class<? extends V> ofType) {
        for (ConstructorEntry<V> e : this.constructorEntries) {
            if (!e.matches(c) || ofType != null && !ofType.isInstance(e.value)) continue;
            return CollectionUtils.optional(e.value);
        }
        return CollectionUtils.empty();
    }

    public Optional<V> find(Constructor<?> c) {
        return this.find(c, null);
    }

    public List<V> findAll(Constructor<?> c, Class<? extends V> ofType) {
        List list = null;
        for (ConstructorEntry<V> e : this.constructorEntries) {
            if (!e.matches(c) || e.value == null || ofType != null && !ofType.isInstance(e.value)) continue;
            list = ReflectionMap.lazyAdd(list, e.value);
        }
        return ReflectionMap.lazyList(list);
    }

    public List<V> findAll(Constructor<?> c) {
        List list = null;
        for (ConstructorEntry<V> e : this.constructorEntries) {
            if (!e.matches(c) || e.value == null) continue;
            list = ReflectionMap.lazyAdd(list, e.value);
        }
        return ReflectionMap.lazyList(list);
    }

    public V[] appendAll(Constructor<?> c, Class<? extends V> ofType, V[] array) {
        List<V> list = null;
        for (ConstructorEntry<V> e : this.constructorEntries) {
            if (!e.matches(c) || e.value == null || ofType != null && !ofType.isInstance(e.value)) continue;
            list = ReflectionMap.lazyAdd(array, list, e.value);
        }
        return ReflectionMap.lazyArray(array, list);
    }

    static boolean argsMatch(String[] names, Class<?>[] args) {
        if (names == null) {
            return true;
        }
        if (names.length != args.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            String n = names[i];
            Class<?> a = args[i];
            if (StringUtils.eq(n, a.getSimpleName()) || StringUtils.eq(n, a.getName())) continue;
            return false;
        }
        return true;
    }

    static String simpleClassName(String name) {
        int i = name.indexOf(46);
        if (i == -1) {
            return name;
        }
        return null;
    }

    static boolean classMatches(String simpleName, String fullName, Class<?> c) {
        String cSimple = c.getSimpleName();
        String cFull = c.getName();
        if (StringUtils.eq(simpleName, cSimple) || StringUtils.eq(fullName, cFull) || "*".equals(simpleName)) {
            return true;
        }
        if (cFull.indexOf(36) != -1) {
            Package p = c.getPackage();
            if (p != null) {
                cFull = cFull.substring(p.getName().length() + 1);
            }
            if (StringUtils.eq(simpleName, cFull)) {
                return true;
            }
            int i = cFull.indexOf(36);
            while (i != -1) {
                if (StringUtils.eq(simpleName, cFull = cFull.substring(i + 1))) {
                    return true;
                }
                i = cFull.indexOf(36);
            }
        }
        return false;
    }

    public String toString() {
        return JsonMap.filteredMap().append("classEntries", this.classEntries).append("methodEntries", this.methodEntries).append("fieldEntries", this.fieldEntries).append("constructorEntries", this.constructorEntries).asString();
    }

    private static <V> List<V> lazyList(List<V> list) {
        return list == null ? Collections.emptyList() : list;
    }

    private static <V> List<V> lazyAdd(V[] array, List<V> list, V v) {
        if (list == null) {
            list = CollectionUtils.list(array);
        }
        list.add(v);
        return list;
    }

    private static <V> V[] lazyArray(V[] array, List<V> list) {
        if (list == null) {
            return array;
        }
        array = (Object[])Array.newInstance(array.getClass().getComponentType(), list.size());
        list.toArray(array);
        return array;
    }

    public static class Builder<V> {
        final List<ClassEntry<V>> classEntries;
        final List<MethodEntry<V>> methodEntries;
        final List<FieldEntry<V>> fieldEntries;
        final List<ConstructorEntry<V>> constructorEntries;

        protected Builder() {
            this.classEntries = CollectionUtils.list(new ClassEntry[0]);
            this.methodEntries = CollectionUtils.list(new MethodEntry[0]);
            this.fieldEntries = CollectionUtils.list(new FieldEntry[0]);
            this.constructorEntries = CollectionUtils.list(new ConstructorEntry[0]);
        }

        protected Builder(Builder<V> copyFrom) {
            this.classEntries = CollectionUtils.copyOf(copyFrom.classEntries);
            this.methodEntries = CollectionUtils.copyOf(copyFrom.methodEntries);
            this.fieldEntries = CollectionUtils.copyOf(copyFrom.fieldEntries);
            this.constructorEntries = CollectionUtils.copyOf(copyFrom.constructorEntries);
        }

        public Builder<V> append(String key, V value) {
            if (StringUtils.isEmpty(key)) {
                throw new BasicRuntimeException("Invalid reflection signature: [{0}]", key);
            }
            try {
                ReflectionMap.splitNames(key, k -> {
                    if (k.endsWith(")")) {
                        int i = k.substring(0, k.indexOf(40)).lastIndexOf(46);
                        if (i == -1 || Character.isUpperCase(k.charAt(i + 1))) {
                            this.constructorEntries.add(new ConstructorEntry<Object>((String)k, value));
                        } else {
                            this.methodEntries.add(new MethodEntry<Object>((String)k, value));
                        }
                    } else {
                        int i = k.lastIndexOf(46);
                        if (i == -1) {
                            this.classEntries.add(new ClassEntry<Object>((String)k, value));
                        } else if (Character.isUpperCase(k.charAt(i + 1))) {
                            this.classEntries.add(new ClassEntry<Object>((String)k, value));
                            this.fieldEntries.add(new FieldEntry<Object>((String)k, value));
                        } else {
                            this.methodEntries.add(new MethodEntry<Object>((String)k, value));
                            this.fieldEntries.add(new FieldEntry<Object>((String)k, value));
                        }
                    }
                });
            }
            catch (IndexOutOfBoundsException e) {
                throw new BasicRuntimeException("Invalid reflection signature: [{0}]", key);
            }
            return this;
        }

        public ReflectionMap<V> build() {
            return new ReflectionMap(this);
        }

        public Builder<V> copy() {
            return new Builder<V>(this);
        }
    }

    static class ClassEntry<V> {
        final String simpleName;
        final String fullName;
        final V value;

        ClassEntry(String name, V value) {
            this.simpleName = ReflectionMap.simpleClassName(name);
            this.fullName = name;
            this.value = value;
        }

        public boolean matches(Class<?> c) {
            if (c == null) {
                return false;
            }
            return ReflectionMap.classMatches(this.simpleName, this.fullName, c);
        }

        public String toString() {
            return JsonMap.filteredMap().append("simpleName", this.simpleName).append("fullName", this.fullName).append("value", this.value).asString();
        }
    }

    static class MethodEntry<V> {
        String simpleClassName;
        String fullClassName;
        String methodName;
        String[] args;
        V value;

        MethodEntry(String name, V value) {
            int i = name.indexOf(40);
            String[] stringArray = this.args = i == -1 ? null : StringUtils.splitMethodArgs(name.substring(i + 1, name.length() - 1));
            if (this.args != null) {
                for (int j = 0; j < this.args.length; ++j) {
                    int k = this.args[j].indexOf(60);
                    if (k > 0) {
                        this.args[j] = this.args[j].substring(0, k);
                    }
                    if (!this.args[j].endsWith("[]")) continue;
                    int l = 0;
                    while (this.args[j].endsWith("[]")) {
                        ++l;
                        this.args[j] = this.args[j].substring(0, this.args[j].length() - 2);
                    }
                    StringBuilder sb = new StringBuilder(this.args[j].length() + l + 2);
                    for (int m = 0; m < l; ++m) {
                        sb.append('[');
                    }
                    sb.append('L').append(this.args[j]).append(';');
                    this.args[j] = sb.toString();
                }
            }
            name = i == -1 ? name : name.substring(0, i);
            i = name.lastIndexOf(46);
            String s1 = name.substring(0, i).trim();
            String s2 = name.substring(i + 1).trim();
            this.simpleClassName = ReflectionMap.simpleClassName(s1);
            this.fullClassName = s1;
            this.methodName = s2;
            this.value = value;
        }

        public boolean matches(Method m) {
            if (m == null) {
                return false;
            }
            Class<?> c = m.getDeclaringClass();
            return ReflectionMap.classMatches(this.simpleClassName, this.fullClassName, c) && StringUtils.eq(m.getName(), this.methodName) && ReflectionMap.argsMatch(this.args, m.getParameterTypes());
        }

        public String toString() {
            return JsonMap.filteredMap().append("simpleClassName", this.simpleClassName).append("fullClassName", this.fullClassName).append("methodName", this.methodName).append("args", this.args).append("value", this.value).asString();
        }
    }

    static class FieldEntry<V> {
        String simpleClassName;
        String fullClassName;
        String fieldName;
        V value;

        FieldEntry(String name, V value) {
            int i = name.lastIndexOf(46);
            String s1 = name.substring(0, i);
            String s2 = name.substring(i + 1);
            this.simpleClassName = ReflectionMap.simpleClassName(s1);
            this.fullClassName = s1;
            this.fieldName = s2;
            this.value = value;
        }

        public boolean matches(Field f) {
            if (f == null) {
                return false;
            }
            Class<?> c = f.getDeclaringClass();
            return ReflectionMap.classMatches(this.simpleClassName, this.fullClassName, c) && StringUtils.eq(f.getName(), this.fieldName);
        }

        public String toString() {
            return JsonMap.filteredMap().append("simpleClassName", this.simpleClassName).append("fullClassName", this.fullClassName).append("fieldName", this.fieldName).append("value", this.value).asString();
        }
    }

    static class ConstructorEntry<V> {
        String simpleClassName;
        String fullClassName;
        String[] args;
        V value;

        ConstructorEntry(String name, V value) {
            int i = name.indexOf(40);
            this.args = StringUtils.split(name.substring(i + 1, name.length() - 1));
            name = name.substring(0, i).trim();
            this.simpleClassName = ReflectionMap.simpleClassName(name);
            this.fullClassName = name;
            this.value = value;
        }

        public boolean matches(Constructor<?> m) {
            if (m == null) {
                return false;
            }
            Class<?> c = m.getDeclaringClass();
            return ReflectionMap.classMatches(this.simpleClassName, this.fullClassName, c) && ReflectionMap.argsMatch(this.args, m.getParameterTypes());
        }

        public String toString() {
            return JsonMap.filteredMap().append("simpleClassName", this.simpleClassName).append("fullClassName", this.fullClassName).append("args", this.args).append("value", this.value).asString();
        }
    }
}

