/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.objecttools;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.objecttools.AbstractMatcher;
import org.apache.juneau.objecttools.MatcherFactory;
import org.apache.juneau.objecttools.NumberMatcherFactory;
import org.apache.juneau.objecttools.ObjectTool;
import org.apache.juneau.objecttools.SearchArgs;
import org.apache.juneau.objecttools.StringMatcherFactory;
import org.apache.juneau.objecttools.TimeMatcherFactory;

public final class ObjectSearcher
implements ObjectTool<SearchArgs> {
    public static final ObjectSearcher DEFAULT = new ObjectSearcher(new MatcherFactory[0]);
    final MatcherFactory[] factories;

    public static ObjectSearcher create(MatcherFactory ... factories) {
        return new ObjectSearcher(factories);
    }

    public ObjectSearcher(MatcherFactory ... factories) {
        MatcherFactory[] matcherFactoryArray;
        if (factories.length == 0) {
            MatcherFactory[] matcherFactoryArray2 = new MatcherFactory[3];
            matcherFactoryArray2[0] = NumberMatcherFactory.DEFAULT;
            matcherFactoryArray2[1] = TimeMatcherFactory.DEFAULT;
            matcherFactoryArray = matcherFactoryArray2;
            matcherFactoryArray2[2] = StringMatcherFactory.DEFAULT;
        } else {
            matcherFactoryArray = factories;
        }
        this.factories = matcherFactoryArray;
    }

    public <R> List<R> run(Object input, String searchArgs) {
        Object r = this.run(BeanContext.DEFAULT_SESSION, input, SearchArgs.create(searchArgs));
        if (r instanceof List) {
            return (List)r;
        }
        if (r instanceof Collection) {
            return new ArrayList((Collection)r);
        }
        if (r.getClass().isArray()) {
            return Arrays.asList((Object[])r);
        }
        return null;
    }

    @Override
    public Object run(BeanSession session, Object input, SearchArgs args) {
        ClassMeta<Object> type = session.getClassMetaForObject(input);
        Map<String, String> search = args.getSearch();
        if (search.isEmpty() || type == null || !type.isCollectionOrArray()) {
            return input;
        }
        ArrayList<Object> l = null;
        RowMatcher rowMatcher = new RowMatcher(session, search);
        if (type.isCollection()) {
            Collection c = (Collection)input;
            ArrayList<Object> l2 = l = CollectionUtils.list(c.size());
            c.forEach(x -> {
                if (rowMatcher.matches(x)) {
                    l2.add(x);
                }
            });
        } else {
            int size = Array.getLength(input);
            l = CollectionUtils.list(size);
            for (int i = 0; i < size; ++i) {
                Object o = Array.get(input, i);
                if (!rowMatcher.matches(o)) continue;
                l.add(o);
            }
        }
        return l;
    }

    private class RowMatcher {
        Map<String, ColumnMatcher> entryMatchers = new HashMap<String, ColumnMatcher>();
        BeanSession bs;

        RowMatcher(BeanSession bs, Map query) {
            this.bs = bs;
            query.forEach((k, v) -> this.entryMatchers.put(StringUtils.stringify((Object)k), new ColumnMatcher(bs, StringUtils.stringify((Object)v))));
        }

        boolean matches(Object o) {
            if (o == null) {
                return false;
            }
            ClassMeta<Object> cm = this.bs.getClassMetaForObject(o);
            if (cm.isMapOrBean()) {
                BeanMap<Object> m = cm.isMap() ? (BeanMap<Object>)o : this.bs.toBeanMap(o);
                for (Map.Entry<String, ColumnMatcher> e : this.entryMatchers.entrySet()) {
                    String key = e.getKey();
                    Object val = null;
                    val = m instanceof BeanMap ? m.getRaw(key) : (Object)m.get(key);
                    if (e.getValue().matches(val)) continue;
                    return false;
                }
                return true;
            }
            if (cm.isCollection()) {
                for (Object o2 : (Collection)o) {
                    if (this.matches(o2)) continue;
                    return false;
                }
                return true;
            }
            if (cm.isArray()) {
                for (int i = 0; i < Array.getLength(o); ++i) {
                    if (this.matches(Array.get(o, i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private class ColumnMatcher {
        String searchPattern;
        AbstractMatcher[] matchers;
        BeanSession bs;

        ColumnMatcher(BeanSession bs, String searchPattern) {
            this.bs = bs;
            this.searchPattern = searchPattern;
            this.matchers = new AbstractMatcher[ObjectSearcher.this.factories.length];
        }

        boolean matches(Object o) {
            ClassMeta<Object> cm = this.bs.getClassMetaForObject(o);
            if (cm == null) {
                return false;
            }
            if (cm.isCollection()) {
                for (Object o2 : (Collection)o) {
                    if (!this.matches(o2)) continue;
                    return true;
                }
                return false;
            }
            if (cm.isArray()) {
                for (int i = 0; i < Array.getLength(o); ++i) {
                    if (!this.matches(Array.get(o, i))) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < ObjectSearcher.this.factories.length; ++i) {
                if (!ObjectSearcher.this.factories[i].canMatch(cm)) continue;
                if (this.matchers[i] == null) {
                    this.matchers[i] = ObjectSearcher.this.factories[i].create(this.searchPattern);
                }
                return this.matchers[i].matches(cm, o);
            }
            return false;
        }
    }
}

