/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.lang.reflect.Type;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.ParseException;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.Value;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.assertions.FluentZonedDateTimeAssertion;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.http.header.BasicBooleanHeader;
import org.apache.juneau.http.header.BasicCsvHeader;
import org.apache.juneau.http.header.BasicDateHeader;
import org.apache.juneau.http.header.BasicEntityTagHeader;
import org.apache.juneau.http.header.BasicEntityTagsHeader;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.http.header.BasicIntegerHeader;
import org.apache.juneau.http.header.BasicLongHeader;
import org.apache.juneau.http.header.BasicStringHeader;
import org.apache.juneau.http.header.BasicStringRangesHeader;
import org.apache.juneau.http.header.BasicUriHeader;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SimplePartParser;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.rest.client.RestRequest;
import org.apache.juneau.rest.client.RestResponse;
import org.apache.juneau.rest.client.assertion.FluentResponseHeaderAssertion;

public class ResponseHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    static final Header NULL_HEADER = new Header(){

        public String getName() {
            return null;
        }

        public String getValue() {
            return null;
        }

        public HeaderElement[] getElements() throws ParseException {
            return new HeaderElement[0];
        }
    };
    private final HeaderElement[] elements;
    private final RestRequest request;
    private final RestResponse response;
    private HttpPartParserSession parser;
    private HttpPartSchema schema;

    public ResponseHeader(String name, RestRequest request, RestResponse response, Header header) {
        super(name, (Object)(header == null ? null : header.getValue()));
        this.request = request;
        this.response = response;
        this.elements = header == null ? new HeaderElement[]{} : header.getElements();
        this.parser(null);
    }

    public ResponseHeader schema(HttpPartSchema value) {
        this.schema = value;
        return this;
    }

    public ResponseHeader parser(HttpPartParserSession value) {
        this.parser = value == null ? SimplePartParser.DEFAULT_SESSION : value;
        return this;
    }

    public Optional<Integer> asInteger() {
        return this.asIntegerHeader().asInteger();
    }

    public Optional<Boolean> asBoolean() {
        return this.asBooleanHeader().asBoolean();
    }

    public Optional<Long> asLong() {
        return this.asLongHeader().asLong();
    }

    public Optional<ZonedDateTime> asDate() {
        return this.asDateHeader().asZonedDateTime();
    }

    public Optional<String[]> asCsvArray() {
        return this.asCsvHeader().asArray();
    }

    public <T extends BasicHeader> T asHeader(Class<T> c) {
        try {
            ClassInfo ci = ClassInfo.of(c);
            ConstructorInfo cc = ci.getPublicConstructor(x -> x.hasParamTypes(new Class[]{String.class}));
            if (cc != null) {
                return (T)((BasicHeader)cc.invoke(new Object[]{this.getValue()}));
            }
            cc = ci.getPublicConstructor(x -> x.hasParamTypes(new Class[]{String.class, String.class}));
            if (cc != null) {
                return (T)((BasicHeader)cc.invoke(new Object[]{this.getName(), this.getValue()}));
            }
        }
        catch (Throwable e) {
            if (e instanceof ExecutableException) {
                e = ((ExecutableException)e).getCause();
            }
            throw ThrowableUtils.asRuntimeException((Throwable)e);
        }
        throw new BasicRuntimeException("Could not determine a method to construct type {0}", new Object[]{ClassUtils.className(c)});
    }

    public BasicCsvHeader asCsvHeader() {
        return new BasicCsvHeader(this.getName(), this.getValue());
    }

    public BasicDateHeader asDateHeader() {
        return new BasicDateHeader(this.getName(), this.getValue());
    }

    public BasicEntityTagsHeader asEntityTagsHeader() {
        return new BasicEntityTagsHeader(this.getName(), this.getValue());
    }

    public BasicEntityTagHeader asEntityTagHeader() {
        return new BasicEntityTagHeader(this.getName(), this.getValue());
    }

    public BasicIntegerHeader asIntegerHeader() {
        return new BasicIntegerHeader(this.getName(), this.getValue());
    }

    public BasicBooleanHeader asBooleanHeader() {
        return new BasicBooleanHeader(this.getName(), this.getValue());
    }

    public BasicLongHeader asLongHeader() {
        return new BasicLongHeader(this.getName(), this.getValue());
    }

    public BasicStringRangesHeader asStringRangesHeader() {
        return new BasicStringRangesHeader(this.getName(), this.getValue());
    }

    public BasicStringHeader asStringHeader() {
        return new BasicStringHeader(this.getName(), this.getValue());
    }

    public BasicUriHeader asUriHeader() {
        return new BasicUriHeader(this.getName(), this.getValue());
    }

    public RestResponse asString(Value<String> value) {
        value.set((Object)this.orElse(null));
        return this.response;
    }

    public <T> Optional<T> as(Type type, Type ... args) {
        return this.as(this.request.getClassMeta(type, args));
    }

    public <T> RestResponse as(Value<T> value, Type type, Type ... args) {
        value.set(this.as(type, args).orElse(null));
        return this.response;
    }

    public <T> Optional<T> as(Class<T> type) {
        return this.as(this.request.getClassMeta(type));
    }

    public <T> RestResponse as(Value<T> value, Class<T> type) {
        value.set(this.as(type).orElse(null));
        return this.response;
    }

    public <T> Optional<T> as(ClassMeta<T> type) {
        try {
            return CollectionUtils.optional((Object)this.parser.parse(HttpPartType.HEADER, this.schema, this.getValue(), type));
        }
        catch (org.apache.juneau.parser.ParseException e) {
            throw new BasicRuntimeException((Throwable)e, "Could not parse response header {0}.", new Object[]{this.getName()});
        }
    }

    public <T> RestResponse as(Value<T> value, ClassMeta<T> type) {
        value.set(this.as(type).orElse(null));
        return this.response;
    }

    public Matcher asMatcher(Pattern pattern) {
        return pattern.matcher(this.orElse(""));
    }

    public Matcher asMatcher(String regex) {
        return this.asMatcher(regex, 0);
    }

    public Matcher asMatcher(String regex, int flags) {
        return this.asMatcher(Pattern.compile(regex, flags));
    }

    public FluentResponseHeaderAssertion<ResponseHeader> assertValue() {
        return new FluentResponseHeaderAssertion<ResponseHeader>(this, this);
    }

    public FluentStringAssertion<ResponseHeader> assertString() {
        return new FluentResponseHeaderAssertion<ResponseHeader>(this, this).asString();
    }

    public FluentIntegerAssertion<ResponseHeader> assertInteger() {
        return new FluentResponseHeaderAssertion<ResponseHeader>(this, this).asInteger();
    }

    public FluentLongAssertion<ResponseHeader> assertLong() {
        return new FluentResponseHeaderAssertion<ResponseHeader>(this, this).asLong();
    }

    public FluentZonedDateTimeAssertion<ResponseHeader> assertZonedDateTime() {
        return new FluentResponseHeaderAssertion<ResponseHeader>(this, this).asZonedDateTime();
    }

    public RestResponse response() {
        return this.response;
    }

    public HeaderElement[] getElements() throws ParseException {
        return this.elements;
    }
}

