/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.objecttools;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.juneau.ExecutableException;

public class ObjectMerger {
    public static <T> T merge(Class<T> interfaceClass, T ... pojos) {
        return ObjectMerger.merge(interfaceClass, false, pojos);
    }

    public static <T> T merge(Class<T> interfaceClass, boolean callAllNonGetters, T ... pojos) {
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new MergeInvocationHandler(callAllNonGetters, pojos));
    }

    private static class MergeInvocationHandler
    implements InvocationHandler {
        private final Object[] pojos;
        private final boolean callAllNonGetters;

        public MergeInvocationHandler(boolean callAllNonGetters, Object ... pojos) {
            this.callAllNonGetters = callAllNonGetters;
            this.pojos = pojos;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws ExecutableException {
            Object r = null;
            boolean isGetter = args == null && method.getReturnType() != Void.class;
            for (Object pojo : this.pojos) {
                if (pojo == null) continue;
                try {
                    r = method.invoke(pojo, args);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new ExecutableException(e);
                }
                if (!(isGetter ? r != null : !this.callAllNonGetters)) continue;
                return r;
            }
            return r;
        }
    }
}

