/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.juneau.ValueListener;
import org.apache.juneau.reflect.ClassInfo;

public class Value<T> {
    private T t;
    private ValueListener<T> listener;

    public static <T> Value<T> of(T object) {
        return new Value<T>(object);
    }

    public static <T> Value<T> empty() {
        return new Value<Object>(null);
    }

    public static Type getParameterType(Type t) {
        Class c;
        if (t instanceof ParameterizedType) {
            Type[] ta;
            ParameterizedType pt = (ParameterizedType)t;
            if (pt.getRawType() == Value.class && (ta = pt.getActualTypeArguments()).length > 0) {
                return ta[0];
            }
        } else if (t instanceof Class && Value.class.isAssignableFrom(c = (Class)t)) {
            return ClassInfo.of(c).getParameterType(0, Value.class);
        }
        return null;
    }

    public static Type unwrap(Type t) {
        Type x = Value.getParameterType(t);
        return x != null ? x : t;
    }

    public static boolean isType(Type t) {
        return t instanceof ParameterizedType && ((ParameterizedType)t).getRawType() == Value.class || t instanceof Class && Value.class.isAssignableFrom((Class)t);
    }

    public Value() {
    }

    public Value(T t) {
        this.set(t);
    }

    public Value<T> listener(ValueListener<T> listener) {
        this.listener = listener;
        return this;
    }

    public Value<T> set(T t) {
        this.t = t;
        if (this.listener != null) {
            this.listener.onSet(t);
        }
        return this;
    }

    public Value<T> setIfEmpty(T t) {
        if (this.isEmpty()) {
            this.set(t);
        }
        return this;
    }

    public T get() {
        return this.t;
    }

    public T getAndUnset() {
        T t2 = this.t;
        this.t = null;
        return t2;
    }

    public boolean isPresent() {
        return this.get() != null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.t != null) {
            consumer.accept(this.t);
        }
    }

    public <T2> Value<T2> map(Function<? super T, T2> mapper) {
        if (this.t != null) {
            return Value.of(mapper.apply(this.t));
        }
        return Value.empty();
    }

    public T orElse(T def) {
        return this.t == null ? def : this.t;
    }

    public boolean isEmpty() {
        return this.t == null;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.t != null ? this.t : other.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.t != null) {
            return this.t;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public String toString() {
        return "Value(" + String.valueOf(this.t) + ")";
    }
}

