/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import org.apache.http.StatusLine;
import org.apache.juneau.Context;
import org.apache.juneau.ContextSession;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestSession;
import org.apache.juneau.rest.converter.RestConverter;
import org.apache.juneau.rest.guard.RestGuard;
import org.apache.juneau.rest.logger.CallLogger;

public class RestOpSession
extends ContextSession {
    private final RestOpContext ctx;
    private final RestSession session;
    private final RestRequest req;
    private final RestResponse res;

    public static Builder create(RestOpContext ctx, RestSession session) {
        return new Builder(ctx, session);
    }

    protected RestOpSession(Builder builder) {
        super((ContextSession.Builder)builder);
        this.ctx = builder.ctx;
        this.session = builder.session;
        try {
            this.req = (RestRequest)((Object)this.session.getBeanStore().add(RestRequest.class, (Object)this.ctx.createRequest(this.session)));
            this.res = (RestResponse)((Object)this.session.getBeanStore().add(RestResponse.class, (Object)this.ctx.createResponse(this.session, this.req)));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerError((Throwable)e);
        }
    }

    public RestOpContext getContext() {
        return this.ctx;
    }

    public void run() throws Throwable {
        for (RestGuard guard : this.ctx.getGuards()) {
            if (guard.guard(this.req, this.res)) continue;
            return;
        }
        this.ctx.getMethodInvoker().invoke(this);
        if (this.res.hasContent()) {
            for (RestConverter converter : this.ctx.getConverters()) {
                this.res.setContent(converter.convert(this.req, this.res.getContent().orElse(null)));
            }
        }
    }

    public RestRequest getRequest() {
        return this.req;
    }

    public RestResponse getResponse() {
        return this.res;
    }

    public BeanStore getBeanStore() {
        return this.session.getBeanStore();
    }

    public RestContext getRestContext() {
        return this.session.getContext();
    }

    public RestSession getRestSession() {
        return this.session;
    }

    public RestOpSession status(StatusLine value) {
        this.session.status(value);
        return this;
    }

    public RestOpSession finish() {
        try {
            this.res.flushBuffer();
            this.req.close();
        }
        catch (Exception e) {
            this.session.exception(e);
        }
        return this;
    }

    public static class Builder
    extends ContextSession.Builder {
        final RestOpContext ctx;
        final RestSession session;

        public Builder(RestOpContext ctx, RestSession session) {
            super((Context)ctx);
            this.ctx = ctx;
            this.session = session;
        }

        public Builder logger(CallLogger value) {
            this.session.logger(value);
            return this;
        }

        public Builder debug(boolean value) throws IOException {
            this.session.debug(value);
            return this;
        }

        public RestOpSession build() {
            return new RestOpSession(this);
        }
    }
}

