/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.apache.juneau.annotation.TargetedAnnotationBuilder;
import org.apache.juneau.annotation.TargetedAnnotationImpl;
import org.apache.juneau.annotation.TargetedAnnotationMBuilder;
import org.apache.juneau.rest.annotation.RestInject;

public class RestInjectAnnotation {
    public static final RestInject DEFAULT = RestInjectAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static String name(RestInject a) {
        if (a == null) {
            return "";
        }
        if (!a.name().isEmpty()) {
            return a.name();
        }
        return a.value();
    }

    public static class Builder
    extends TargetedAnnotationMBuilder {
        String name;
        String value;
        String[] methodScope;

        protected Builder() {
            super(RestInject.class);
        }

        public RestInject build() {
            return new Impl(this);
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder methodScope(String ... value) {
            this.methodScope = value;
            return this;
        }

        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }
    }

    @Documented
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public RestInject[] value();
    }

    private static class Impl
    extends TargetedAnnotationImpl
    implements RestInject {
        private final String name;
        private final String value;
        private final String[] methodScope;

        Impl(Builder b) {
            super((TargetedAnnotationBuilder)b);
            this.name = b.name;
            this.value = b.value;
            this.methodScope = b.methodScope;
            this.postConstruct();
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String[] methodScope() {
            return this.methodScope;
        }
    }
}

