/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.build.DownloadBlocker;
import aQute.bnd.build.LibraryHandler;
import aQute.bnd.build.LoggingProgressPlugin;
import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectTracker;
import aQute.bnd.build.Run;
import aQute.bnd.build.WorkspaceClassIndex;
import aQute.bnd.build.WorkspaceExternalPluginHandler;
import aQute.bnd.build.WorkspaceLayout;
import aQute.bnd.build.WorkspaceLock;
import aQute.bnd.build.WorkspaceNotifier;
import aQute.bnd.build.WorkspaceRepository;
import aQute.bnd.build.WorkspaceRepositoryDynamic;
import aQute.bnd.build.api.OnWorkspace;
import aQute.bnd.exceptions.BiFunctionWithException;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.exceptions.FunctionWithException;
import aQute.bnd.exporter.executable.ExecutableJarExporter;
import aQute.bnd.exporter.runbundles.RunbundlesExporter;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.http.HttpClient;
import aQute.bnd.maven.support.Maven;
import aQute.bnd.memoize.CloseableMemoize;
import aQute.bnd.memoize.Memoize;
import aQute.bnd.osgi.About;
import aQute.bnd.osgi.BundleId;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Macro;
import aQute.bnd.osgi.PluginsContainer;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.osgi.repository.AggregateRepository;
import aQute.bnd.osgi.repository.AugmentRepository;
import aQute.bnd.osgi.repository.WorkspaceRepositoryMarker;
import aQute.bnd.osgi.resource.RequirementBuilder;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.remoteworkspace.server.RemoteWorkspaceServer;
import aQute.bnd.resource.repository.ResourceRepositoryImpl;
import aQute.bnd.result.Result;
import aQute.bnd.service.BndListener;
import aQute.bnd.service.RepositoryListenerPlugin;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.action.Action;
import aQute.bnd.service.extension.ExtensionActivator;
import aQute.bnd.service.lifecycle.LifeCyclePlugin;
import aQute.bnd.service.repository.Prepare;
import aQute.bnd.service.repository.RepositoryDigest;
import aQute.bnd.service.repository.SearchableRepository;
import aQute.bnd.stream.MapStream;
import aQute.bnd.url.MultiURLConnectionHandler;
import aQute.bnd.util.home.Home;
import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import aQute.lib.collections.Iterables;
import aQute.lib.deployer.FileRepo;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.lib.io.NonClosingInputStream;
import aQute.lib.settings.Settings;
import aQute.lib.strings.Strings;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.lib.zip.ZipUtil;
import aQute.libg.glob.Glob;
import aQute.libg.uri.URIUtil;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.Repository;
import org.osgi.util.promise.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Workspace
extends Processor {
    static final Logger logger = LoggerFactory.getLogger(Workspace.class);
    public static final File BND_DEFAULT_WS = IO.getFile(Home.getUserHomeBnd() + "/default-ws");
    public static final String BND_CACHE_REPONAME = "bnd-cache";
    public static final String EXT = "ext";
    public static final String BUILDFILE = "build.bnd";
    public static final String CNFDIR = "cnf";
    public static final String CACHEDIR = "cache/" + About.CURRENT;
    public static final String STANDALONE_REPO_CLASS = "aQute.bnd.repository.osgi.OSGiRepository";
    static final int BUFFER_SIZE = 65536;
    private static final String PLUGIN_STANDALONE = "-plugin.standalone_";
    private static final Map<File, WeakReference<Workspace>> cache = Workspace.newHashMap();
    private static final Memoize<Processor> defaults = Memoize.supplier(() -> {
        UTF8Properties props = new UTF8Properties();
        try (InputStream propStream = Workspace.class.getResourceAsStream("defaults.bnd");){
            if (propStream != null) {
                props.load(propStream);
            } else {
                System.err.println("Cannot load defaults");
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to load bnd defaults.", e);
        }
        return new Processor(props, false);
    });
    final Map<String, Action> commands = Workspace.newMap();
    final Maven maven;
    private final AtomicBoolean offline = new AtomicBoolean();
    Settings settings = new Settings(Home.getUserHomeBnd() + "/settings.json");
    WorkspaceRepository workspaceRepo = new WorkspaceRepository(this);
    static String overallDriver = "unset";
    static Parameters overallGestalt = new Parameters();
    final ThreadLocal<Reporter> signalBusy = new ThreadLocal();
    ResourceRepositoryImpl resourceRepositoryImpl;
    private String driver;
    private final WorkspaceLayout layout;
    final Set<Project> trail = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile WorkspaceData data = new WorkspaceData();
    private File buildDir;
    private final ProjectTracker projects = new ProjectTracker(this);
    private final WorkspaceLock workspaceLock = new WorkspaceLock(true);
    private static final long WORKSPACE_LOCK_DEFAULT_TIMEOUTMS = 120000L;
    final WorkspaceNotifier notifier = new WorkspaceNotifier(this);
    public static boolean remoteWorkspaces = false;
    static final String _globalHelp = "${global;<name>[;<default>]}, get a global setting from ~/.bnd/settings.json";
    static final String _repodigestsHelp = "${repodigests;[;<repo names>]...}, get the repository digests";
    static final String _gestaltHelp = "${gestalt;<part>[;key[;<value>]]} has too many arguments";
    private static final MethodType defaultConstructor = MethodType.methodType(Void.TYPE);
    private static final Pattern ESCAPE_P = Pattern.compile("([\"'])(.*)\\1");
    static final String _projectswhereHelp = "${projectswhere[;<key>;<glob>]} - Make sure this cannot be called recursively at startup";
    private static final ThreadLocal<Boolean> projectswhereCycleCheck = new ThreadLocal();
    static final String _findprovidersHelp = "${findproviders;<namespace>[;<filter>[;('ALL'|'REPOS'|'WORKSPACE')]]}";

    public static Project getProject(File projectDir) throws Exception {
        projectDir = projectDir.getAbsoluteFile();
        assert (projectDir.isDirectory());
        Workspace ws = Workspace.getWorkspace(projectDir.getParentFile());
        return ws.getProject(projectDir.getName());
    }

    public static Processor getDefaults() {
        return defaults.get();
    }

    public static Workspace createDefaultWorkspace() throws Exception {
        File build = IO.getFile(BND_DEFAULT_WS, "cnf/build.bnd");
        if (!build.exists()) {
            build.getParentFile().mkdirs();
            IO.store((Object)"", build);
        }
        Workspace ws = new Workspace(BND_DEFAULT_WS, CNFDIR);
        ws.open();
        return ws;
    }

    public static Workspace getWorkspace(File workspaceDir) throws Exception {
        return Workspace.getWorkspace(workspaceDir, CNFDIR);
    }

    public static Workspace getWorkspaceWithoutException(File workspaceDir) throws Exception {
        try {
            return Workspace.getWorkspace(workspaceDir);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Workspace findWorkspace(File base) throws Exception {
        for (File rover = base; rover != null; rover = rover.getParentFile()) {
            File file = IO.getFile(rover, "cnf/build.bnd");
            if (!file.isFile()) continue;
            return Workspace.getWorkspace(rover);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workspace getWorkspace(File workspaceDir, String bndDir) throws Exception {
        workspaceDir = workspaceDir.getAbsoluteFile();
        while (workspaceDir.isDirectory()) {
            File test = new File(workspaceDir, CNFDIR);
            if (!test.exists()) {
                test = new File(workspaceDir, bndDir);
            }
            if (test.isDirectory()) break;
            if (test.isFile()) {
                String redirect = IO.collect(test).trim();
                workspaceDir = test = Workspace.getFile(test.getParentFile(), redirect).getAbsoluteFile();
            }
            if (test.exists()) continue;
            throw new IllegalArgumentException("No Workspace found from: " + workspaceDir);
        }
        Map<File, WeakReference<Workspace>> map = cache;
        synchronized (map) {
            Workspace ws;
            WeakReference<Workspace> wsr = cache.get(workspaceDir);
            if (wsr == null || (ws = (Workspace)wsr.get()) == null) {
                ws = new Workspace(workspaceDir, bndDir);
                cache.put(workspaceDir, new WeakReference<Workspace>(ws));
                ws.open();
            }
            return ws;
        }
    }

    public Workspace(File workspaceDir) throws Exception {
        this(workspaceDir, CNFDIR);
        this.open();
    }

    public Workspace(File workspaceDir, String bndDir) throws Exception {
        super(new Processor(Workspace.getDefaults()));
        this.maven = new Maven(Processor.getExecutor(), this);
        this.layout = WorkspaceLayout.BND;
        this.addClose(this.notifier);
        workspaceDir = workspaceDir.getAbsoluteFile();
        this.setBase(workspaceDir);
        this.addBasicPlugin(new LoggingProgressPlugin());
        this.setFileSystem(workspaceDir, bndDir);
        this.fixupVersionDefaults();
    }

    private Workspace(WorkspaceLayout layout) throws Exception {
        super(new Processor(Workspace.getDefaults()));
        this.maven = new Maven(Processor.getExecutor(), this);
        this.layout = layout;
        this.setBuildDir(IO.getFile(BND_DEFAULT_WS, CNFDIR));
    }

    public void open() {
        if (this.isInteractive()) {
            this.projects.forceRefresh();
        }
        this.notifier.mute = false;
        this.forceInitialization();
        this.notifier.projects(this.projects.getAllProjects());
    }

    private void fixupVersionDefaults() throws IOException {
        Properties props = this.getParent().getProperties();
        assert (props.isEmpty()) : "This should only once be called";
        Version actual = new Version(About.CURRENT.getMajor(), About.CURRENT.getMinor(), 0);
        String version = Strings.trim(this.getProperty("-versiondefaults", actual.toString()));
        URL url = Workspace.class.getResource(version + ".bnd");
        if (url == null) {
            this.error("%s = %s, this is not a valid released bnd version. Using current version %s", "-versiondefaults", version, actual);
            url = Workspace.class.getResource(actual + ".bnd");
            assert (url != null) : "We must have a specific defaults resource";
        }
        try (InputStream in = url.openStream();){
            props.load(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileSystem(File workspaceDir, String bndDir) throws Exception {
        workspaceDir = workspaceDir.getAbsoluteFile();
        IO.mkdirs(workspaceDir);
        assert (workspaceDir.isDirectory());
        Map<File, WeakReference<Workspace>> map = cache;
        synchronized (map) {
            WeakReference<Workspace> wsr = cache.get(this.getBase());
            if (wsr != null && wsr.get() == this) {
                cache.remove(this.getBase());
                cache.put(workspaceDir, wsr);
            }
        }
        File buildDir = new File(workspaceDir, bndDir).getAbsoluteFile();
        if (!buildDir.isDirectory()) {
            buildDir = new File(workspaceDir, CNFDIR).getAbsoluteFile();
        }
        this.setBuildDir(buildDir);
        File buildFile = new File(buildDir, BUILDFILE).getAbsoluteFile();
        if (!buildFile.isFile()) {
            this.warning("No Build File in %s, creating it", workspaceDir);
            IO.store((Object)"", buildFile);
        }
        this.setProperties(buildFile, workspaceDir);
        Attrs sysProps = OSGiHeader.parseProperties(this.mergeProperties("-systemproperties"));
        sysProps.forEach((BiConsumer<? super String, ? super String>)((BiConsumer<String, String>)System::setProperty));
    }

    public Project getProjectFromFile(File projectDir) {
        try {
            projectDir = projectDir.getCanonicalFile();
            if (!projectDir.isDirectory()) {
                return null;
            }
            if (this.getBase().getCanonicalFile().equals(projectDir.getParentFile())) {
                return this.getProject(projectDir.getName());
            }
            return null;
        }
        catch (IOException e) {
            throw Exceptions.duck(e);
        }
    }

    public Project getProject(String bsn) {
        return this.projects.getProject(bsn).orElse(null);
    }

    public boolean isPresent(String name) {
        return this.projects.getProject(name).isPresent();
    }

    @Override
    public boolean refresh() {
        try {
            return this.writeLocked(() -> {
                this.refreshData();
                if (super.refresh()) {
                    for (Project project : this.getAllProjects()) {
                        project.propertiesChanged();
                    }
                    return true;
                }
                return false;
            });
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    public void refreshProjects() {
        this.projects.refresh();
    }

    public void forceRefreshProjects() {
        this.projects.forceRefresh();
    }

    @Override
    public void propertiesChanged() {
        try {
            this.writeLocked(() -> {
                this.refreshData();
                File extDir = new File(this.getBuildDir(), EXT);
                for (File extension : IO.listFiles(extDir, (dir, name) -> name.endsWith(".bnd"))) {
                    String extensionName = extension.getName();
                    extensionName = extensionName.substring(0, extensionName.length() - ".bnd".length());
                    try {
                        this.doIncludeFile(extension, false, this.getProperties(), "ext." + extensionName);
                    }
                    catch (Exception e) {
                        this.exception(e, "PropertiesChanged: %s", e);
                    }
                }
                super.propertiesChanged();
                if (this.doExtend(this)) {
                    super.propertiesChanged();
                }
                this.forceInitialization();
                return null;
            });
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    private void forceInitialization() {
        if (this.notifier.mute) {
            return;
        }
        int revision = this.notifier.initialized();
        if (this.isInteractive()) {
            Promise<List<RepositoryPlugin>> repos = this.getInitializedRepositories();
            repos.onSuccess(r -> this.notifier.ifSameRevision(revision, WorkspaceNotifier.ET.REPOS, r));
            repos.onFailure(e -> this.notifier.ifSameRevision(revision, WorkspaceNotifier.ET.REPOS, Collections.emptyList()));
            for (Project p : this.getAllProjects()) {
                p.propertiesChanged();
            }
        }
    }

    public String _workspace(String[] args) {
        return IO.absolutePath(this.getBase());
    }

    public void addCommand(String menu, Action action) {
        this.commands.put(menu, action);
    }

    public void removeCommand(String menu) {
        this.commands.remove(menu);
    }

    public void fillActions(Map<String, Action> all) {
        all.putAll(this.commands);
    }

    public Collection<Project> getAllProjects() {
        return this.projects.getAllProjects();
    }

    public Collection<Project> getCurrentProjects() {
        return this.getAllProjects();
    }

    public void changedFile(File f) {
        List<BndListener> listeners = this.getPlugins(BndListener.class);
        for (BndListener l : listeners) {
            try {
                l.changed(f);
            }
            catch (Exception e) {
                logger.debug("Exception in a BndListener changed method call", (Throwable)e);
            }
        }
    }

    public void bracket(boolean begin) {
        List<BndListener> listeners = this.getPlugins(BndListener.class);
        for (BndListener l : listeners) {
            try {
                if (begin) {
                    l.begin();
                    continue;
                }
                l.end();
            }
            catch (Exception e) {
                if (begin) {
                    logger.debug("Exception in a BndListener begin method call", (Throwable)e);
                    continue;
                }
                logger.debug("Exception in a BndListener end method call", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal(Reporter reporter) {
        if (this.signalBusy.get() != null) {
            return;
        }
        this.signalBusy.set(reporter);
        try {
            List<BndListener> listeners = this.getPlugins(BndListener.class);
            for (BndListener l : listeners) {
                try {
                    l.signal(this);
                }
                catch (Exception e) {
                    logger.debug("Exception in a BndListener signal method call", (Throwable)e);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.signalBusy.set(null);
        }
    }

    @Override
    public void signal() {
        this.signal(this);
    }

    public void syncCache() throws Exception {
        CachedFileRepo cf = new CachedFileRepo();
        cf.init();
        cf.close();
    }

    public List<RepositoryPlugin> getRepositories() {
        return this.data.repositories.get();
    }

    private List<RepositoryPlugin> initRepositories() {
        List<RepositoryPlugin> plugins = this.getPlugins(RepositoryPlugin.class);
        for (RepositoryPlugin repo : plugins) {
            if (!(repo instanceof Prepare)) continue;
            try {
                ((Prepare)((Object)repo)).prepare();
            }
            catch (Exception e) {
                throw Exceptions.duck(e);
            }
        }
        return plugins;
    }

    public Promise<List<RepositoryPlugin>> getInitializedRepositories() {
        try {
            List<RepositoryPlugin> repositories = this.getRepositories();
            ArrayList<Promise<Void>> promises = new ArrayList<Promise<Void>>();
            for (RepositoryPlugin repo : repositories) {
                promises.add(repo.sync());
            }
            return Workspace.getPromiseFactory().all(promises).map(l -> repositories);
        }
        catch (Exception e) {
            return Workspace.getPromiseFactory().failed((Throwable)e);
        }
    }

    public Collection<Project> getBuildOrder() throws Exception {
        LinkedHashSet<Project> result = new LinkedHashSet<Project>();
        for (Project project : this.getAllProjects()) {
            Collection<Project> dependsOn = project.getDependson();
            this.getBuildOrder(dependsOn, result);
            result.add(project);
        }
        return result;
    }

    private void getBuildOrder(Collection<Project> dependsOn, Set<Project> result) throws Exception {
        for (Project project : dependsOn) {
            Collection<Project> subProjects = project.getDependson();
            for (Project subProject : subProjects) {
                result.add(subProject);
            }
            result.add(project);
        }
    }

    public static Workspace getWorkspace(String path) throws Exception {
        File file = IO.getFile(new File(""), path);
        return Workspace.getWorkspace(file);
    }

    public Maven getMaven() {
        return this.maven;
    }

    @Override
    protected void setTypeSpecificPlugins(PluginsContainer pluginsContainer) {
        try {
            super.setTypeSpecificPlugins(pluginsContainer);
            pluginsContainer.add(this.maven);
            pluginsContainer.add(this.settings);
            if (!Workspace.isTrue(this.getProperty("-nobuildincache"))) {
                CachedFileRepo repo = new CachedFileRepo();
                pluginsContainer.add(repo);
            }
            this.resourceRepositoryImpl = new ResourceRepositoryImpl();
            this.resourceRepositoryImpl.setCache(IO.getFile(this.getProperty(CACHEDIR, Home.getUserHomeBnd() + "/caches/shas")));
            this.resourceRepositoryImpl.setExecutor(Workspace.getExecutor());
            this.resourceRepositoryImpl.setIndexFile(Workspace.getFile(this.getBuildDir(), "repo.json"));
            this.resourceRepositoryImpl.setURLConnector(new MultiURLConnectionHandler(pluginsContainer));
            this.customize(this.resourceRepositoryImpl, null, pluginsContainer);
            pluginsContainer.add(this.resourceRepositoryImpl);
            pluginsContainer.add(new ExecutableJarExporter());
            pluginsContainer.add(new RunbundlesExporter());
            HttpClient client = new HttpClient();
            try {
                client.setOffline(this.getOffline());
                client.setRegistry(pluginsContainer);
                client.readSettings(this);
            }
            catch (Exception e) {
                this.exception(e, "Failed to load the communication settings", new Object[0]);
            }
            pluginsContainer.add(client);
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    @Override
    protected void addExtensions(PluginsContainer pluginsContainer) {
        Parameters extensions = this.getMergedParameters("-extension");
        HashMap<DownloadBlocker, Attrs> blockers = new HashMap<DownloadBlocker, Attrs>();
        for (Map.Entry<String, Attrs> entry : extensions.entrySet()) {
            String bsn = Workspace.removeDuplicateMarker(entry.getKey());
            String stringRange = entry.getValue().get("version");
            logger.debug("Adding extension {}-{}", (Object)bsn, (Object)stringRange);
            if (stringRange == null) {
                stringRange = Version.LOWEST.toString();
            } else if (!VersionRange.isVersionRange(stringRange)) {
                this.error("Invalid version range %s on extension %s", stringRange, bsn);
                continue;
            }
            try {
                SortedSet<SearchableRepository.ResourceDescriptor> matches = this.resourceRepositoryImpl.find(null, bsn, new VersionRange(stringRange));
                if (matches.isEmpty()) {
                    this.error("Extension %s;version=%s not found in base repo", bsn, stringRange);
                    continue;
                }
                DownloadBlocker blocker = new DownloadBlocker(this);
                blockers.put(blocker, entry.getValue());
                this.resourceRepositoryImpl.getResource(matches.last().id, blocker);
            }
            catch (Exception e) {
                this.error("Failed to load extension %s-%s, %s", bsn, stringRange, e);
            }
        }
        logger.debug("Found extensions {}", blockers);
        for (Map.Entry<String, Attrs> entry : blockers.entrySet()) {
            try {
                String reason = ((DownloadBlocker)((Object)entry.getKey())).getReason();
                if (reason != null) {
                    this.error("Extension load failed: %s", reason);
                    continue;
                }
                URLClassLoader cl = new URLClassLoader(new URL[]{((DownloadBlocker)((Object)entry.getKey())).getFile().toURI().toURL()}, this.getClass().getClassLoader());
                for (URL manifest : Iterables.iterable(cl.getResources("META-INF/MANIFEST.MF"))) {
                    InputStream is = manifest.openStream();
                    try {
                        Manifest m = new Manifest(is);
                        Parameters activators = new Parameters(m.getMainAttributes().getValue("Extension-Activator"), this);
                        for (Map.Entry<String, Attrs> e : activators.entrySet()) {
                            try {
                                Class<?> c = cl.loadClass(e.getKey());
                                ExtensionActivator extensionActivator = (ExtensionActivator)Workspace.newInstance(c);
                                this.customize(extensionActivator, entry.getValue(), pluginsContainer);
                                List<?> plugins = extensionActivator.activate(this, entry.getValue());
                                pluginsContainer.add(extensionActivator);
                                if (plugins == null) continue;
                                pluginsContainer.addAll((Collection<? extends Object>)plugins);
                            }
                            catch (ClassNotFoundException cnfe) {
                                this.error("Loading extension %s, extension activator missing: %s (ignored)", entry, e.getKey());
                            }
                        }
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
            catch (Exception e) {
                this.error("failed to install extension %s due to %s", entry, e);
            }
        }
    }

    public boolean isOffline() {
        return this.offline.get();
    }

    public AtomicBoolean getOffline() {
        return this.offline;
    }

    public Workspace setOffline(boolean on) {
        this.offline.set(on);
        return this;
    }

    public String _global(String[] args) throws Exception {
        Macro.verifyCommand(args, _globalHelp, null, 2, 3);
        String key = args[1];
        if (key.equals("key.public")) {
            return Hex.toHexString(this.settings.getPublicKey());
        }
        if (key.equals("key.private")) {
            return Hex.toHexString(this.settings.getPrivateKey());
        }
        String s = this.settings.get(key);
        if (s != null) {
            return s;
        }
        if (args.length == 3) {
            return args[2];
        }
        return null;
    }

    public String _user(String[] args) throws Exception {
        return this._global(args);
    }

    public Object _repodigests(String[] args) throws Exception {
        Macro.verifyCommand(args, _repodigestsHelp, null, 1, 10000);
        List<RepositoryPlugin> repos = this.getRepositories();
        if (args.length > 1) {
            Iterator<RepositoryPlugin> it = repos.iterator();
            block2: while (it.hasNext()) {
                String name = it.next().getName();
                for (int i = 1; i < args.length; ++i) {
                    if (name.equals(args[i])) continue block2;
                }
                it.remove();
            }
        }
        ArrayList<String> digests = new ArrayList<String>();
        for (RepositoryPlugin repo : repos) {
            try {
                if (repo instanceof RepositoryDigest) {
                    byte[] digest = ((RepositoryDigest)((Object)repo)).getDigest();
                    digests.add(Hex.toHexString(digest));
                    continue;
                }
                if (args.length == 1) continue;
                this.error("Specified repo %s for ${repodigests} was named but it is not found", repo.getName());
            }
            catch (Exception e) {
                if (args.length == 1) continue;
                this.error("Specified repo %s for digests is not found", repo.getName());
            }
        }
        return Workspace.join(digests, ",");
    }

    public static Run getRun(File file) throws Exception {
        if (!file.isFile()) {
            return null;
        }
        File projectDir = file.getParentFile();
        File workspaceDir = projectDir.getParentFile();
        if (!workspaceDir.isDirectory()) {
            return null;
        }
        Workspace ws = Workspace.getWorkspaceWithoutException(workspaceDir);
        if (ws == null) {
            return null;
        }
        return new Run(ws, projectDir, file);
    }

    @Override
    public void report(Map<String, Object> table) throws Exception {
        super.report(table);
        table.put("Workspace", this.toString());
        table.put("Plugins", this.getPlugins(Object.class));
        table.put("Repos", this.getRepositories());
        table.put("Projects in build order", this.getBuildOrder());
    }

    public File getCache(String name) {
        return Workspace.getFile(this.buildDir, CACHEDIR + "/" + name);
    }

    public WorkspaceRepository getWorkspaceRepository() {
        return this.workspaceRepo;
    }

    public void checkStructure() {
        if (!this.getBuildDir().isDirectory()) {
            this.error("No directory for cnf %s", this.getBuildDir());
        } else {
            File build = IO.getFile(this.getBuildDir(), BUILDFILE);
            if (build.isFile()) {
                this.error("No %s file in %s", BUILDFILE, this.getBuildDir());
            }
        }
    }

    public File getBuildDir() {
        return this.buildDir;
    }

    public void setBuildDir(File buildDir) {
        this.buildDir = buildDir;
    }

    public boolean isValid() {
        return IO.getFile(this.getBuildDir(), BUILDFILE).isFile();
    }

    public RepositoryPlugin getRepository(String repo) throws Exception {
        for (RepositoryPlugin r : this.getRepositories()) {
            if (!repo.equals(r.getName())) continue;
            return r;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.notifier.closing(this);
        WorkspaceData oldData = this.data;
        this.data = new WorkspaceData();
        IO.close(oldData);
        Map<File, WeakReference<Workspace>> map = cache;
        synchronized (map) {
            WeakReference<Workspace> wsr = cache.get(this.getBase());
            if (wsr != null && wsr.get() == this) {
                cache.remove(this.getBase());
            }
        }
        this.projects.close();
        try {
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void refreshData() {
        WorkspaceData oldData = this.data;
        this.data = new WorkspaceData();
        oldData.close();
    }

    public String getDriver() {
        if (this.driver == null) {
            this.driver = this.getProperty("-bnd-driver", null);
            if (this.driver != null) {
                this.driver = this.driver.trim();
            }
        }
        if (this.driver != null) {
            return this.driver;
        }
        return overallDriver;
    }

    public static void setDriver(String driver) {
        overallDriver = driver;
    }

    public String _driver(String[] args) {
        if (args.length == 1) {
            return this.getDriver();
        }
        String driver = this.getDriver();
        if (driver == null) {
            driver = this.getProperty("-bnd-driver");
        }
        if (driver != null) {
            for (int i = 1; i < args.length; ++i) {
                if (!args[i].equalsIgnoreCase(driver)) continue;
                return driver;
            }
        }
        return "";
    }

    public static void addGestalt(String part, Attrs attrs) {
        overallGestalt.compute(part, (k, already) -> {
            if (already == null) {
                already = attrs != null ? attrs : new Attrs();
            } else if (attrs != null) {
                already.putAll(attrs);
            }
            return already;
        });
    }

    public Attrs getGestalt(String part) {
        return this.getGestalt().get(part);
    }

    public Parameters getGestalt() {
        return this.data.gestalt.get();
    }

    public WorkspaceLayout getLayout() {
        return this.layout;
    }

    public String _gestalt(String[] args) {
        if (args.length >= 2) {
            Attrs attrs = this.getGestalt(args[1]);
            if (attrs == null) {
                return "";
            }
            if (args.length == 2) {
                return args[1];
            }
            String s = attrs.get(args[2]);
            if (args.length == 3) {
                if (s == null) {
                    s = "";
                }
                return s;
            }
            if (args.length == 4) {
                if (args[3].equals(s)) {
                    return s;
                }
                return "";
            }
        }
        throw new IllegalArgumentException(_gestaltHelp);
    }

    @Override
    public String toString() {
        return "Workspace [" + this.getBase().getName() + "]";
    }

    public boolean addPlugin(Class<?> plugin, String alias, Map<String, String> parameters, boolean force) throws Exception {
        BndPlugin ann = plugin.getAnnotation(BndPlugin.class);
        if (alias == null) {
            if (ann != null) {
                alias = ann.name();
            } else {
                alias = Strings.getLastSegment(plugin.getName()).toLowerCase(Locale.ROOT);
                if (alias.endsWith("plugin")) {
                    alias = alias.substring(0, alias.length() - "plugin".length());
                }
            }
        }
        if (!Verifier.isBsn(alias)) {
            this.error("Not a valid plugin name %s", alias);
        }
        File ext = this.getFile("cnf/ext");
        IO.mkdirs(ext);
        File f = new File(ext, alias + ".bnd");
        if (!force) {
            if (f.exists()) {
                this.error("Plugin %s already exists", alias);
                return false;
            }
        } else {
            IO.delete(f);
        }
        Object l = Workspace.newInstance(plugin);
        try (Formatter setup = new Formatter();){
            setup.format("#\n# Plugin %s setup\n#\n", alias);
            setup.format("-plugin.%s = %s", alias, plugin.getName());
            MapStream.of(parameters).mapValue(this::escaped).forEachOrdered((k, v) -> setup.format("; \\\n \t%s = '%s'", k, v));
            setup.format("\n\n", new Object[0]);
            String out = setup.toString();
            if (l instanceof LifeCyclePlugin) {
                out = ((LifeCyclePlugin)l).augmentSetup(out, alias, parameters);
                ((LifeCyclePlugin)l).init(this);
            }
            logger.debug("setup {}", (Object)out);
            IO.store((Object)out, f);
        }
        this.refresh();
        for (LifeCyclePlugin lp : this.getPlugins(LifeCyclePlugin.class)) {
            lp.addedPlugin(this, plugin.getName(), alias, parameters);
        }
        return true;
    }

    private static <T> T newInstance(Class<T> rawClass) throws Exception {
        try {
            return (T)MethodHandles.publicLookup().findConstructor(rawClass, defaultConstructor).invoke();
        }
        catch (Error | Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private Object escaped(String value) {
        Matcher matcher = ESCAPE_P.matcher(value);
        if (matcher.matches()) {
            value = matcher.group(2);
        }
        return value.replaceAll("'", "\\'");
    }

    public boolean removePlugin(String alias) {
        File ext = this.getFile("cnf/ext");
        File f = new File(ext, alias + ".bnd");
        if (!f.exists()) {
            this.error("No such plugin %s", alias);
            return false;
        }
        IO.delete(f);
        this.refresh();
        return true;
    }

    public static Workspace createStandaloneWorkspace(Processor run, URI base) throws Exception {
        Workspace ws = new Workspace(WorkspaceLayout.STANDALONE);
        AtomicBoolean copyAll = new AtomicBoolean(false);
        AtomicInteger counter = new AtomicInteger();
        Parameters standalone = new Parameters(run.getProperty("-standalone"), ws);
        standalone.stream().filterKey(locationStr -> {
            if ("true".equalsIgnoreCase((String)locationStr)) {
                copyAll.set(true);
                return false;
            }
            return true;
        }).map(BiFunctionWithException.asBiFunction((locationStr, attrs) -> {
            String index = String.format("%02d", counter.incrementAndGet());
            String name = attrs.get("name");
            if (name == null) {
                name = "repo".concat(index);
            }
            URI resolvedLocation = URIUtil.resolve(base, locationStr);
            try (Formatter f = new Formatter(Locale.US);){
                f.format("aQute.bnd.repository.osgi.OSGiRepository; name='%s'; locations='%s'", name, resolvedLocation);
                attrs.stream().filterKey(k -> !k.equals("name")).forEachOrdered((k, v) -> f.format("; %s='%s'", k, v));
                Map.Entry<String, String> entry = MapStream.entry(PLUGIN_STANDALONE.concat(index), f.toString());
                return entry;
            }
        })).forEachOrdered(ws::setProperty);
        MapStream<String, Object> runProperties = MapStream.of(run.getProperties()).mapKey(String.class::cast);
        if (!copyAll.get()) {
            runProperties = runProperties.filterKey(k -> k.equals("-plugin") || k.startsWith("-plugin."));
        }
        Properties wsProperties = ws.getProperties();
        runProperties.filterKey(k -> !k.startsWith(PLUGIN_STANDALONE)).forEachOrdered(wsProperties::put);
        ws.fixupVersionDefaults();
        ws.open();
        return ws;
    }

    public boolean isDefaultWorkspace() {
        return BND_DEFAULT_WS.equals(this.getBase());
    }

    @Override
    public boolean isInteractive() {
        return this.getGestalt("interactive") != null;
    }

    public static void resetStatic() {
        overallDriver = "unset";
        overallGestalt = new Parameters();
    }

    public Project createProject(String name) throws Exception {
        if (!Verifier.SYMBOLICNAME.matcher(name).matches()) {
            this.error("A project name is a Bundle Symbolic Name, this must therefore consist of only letters, digits and dots", new Object[0]);
            return null;
        }
        File pdir = this.getFile(name);
        IO.mkdirs(pdir);
        IO.store((Object)("#\n#   " + name.toUpperCase().replace('.', ' ') + "\n#\n"), Workspace.getFile(pdir, "bnd.bnd"));
        this.projects.refresh();
        Project p = this.getProject(name);
        IO.mkdirs(p.getTarget());
        IO.mkdirs(p.getOutput());
        IO.mkdirs(p.getTestOutput());
        for (File dir : p.getSourcePath()) {
            IO.mkdirs(dir);
        }
        IO.mkdirs(p.getTestSrc());
        for (LifeCyclePlugin l : this.getPlugins(LifeCyclePlugin.class)) {
            l.created(p);
        }
        if (!p.isValid()) {
            this.error("project %s is not valid", p);
        }
        return p;
    }

    void removeProject(Project p) throws Exception {
        if (p.isCnf()) {
            return;
        }
        for (LifeCyclePlugin lp : this.getPlugins(LifeCyclePlugin.class)) {
            lp.delete(p);
        }
        this.projects.refresh();
    }

    public static Workspace createWorkspace(File wsdir) throws Exception {
        if (wsdir.exists()) {
            return null;
        }
        IO.mkdirs(wsdir);
        File cnf = IO.getFile(wsdir, CNFDIR);
        IO.mkdirs(cnf);
        IO.store((Object)"", new File(cnf, BUILDFILE));
        IO.store((Object)"-nobundles: true\n", new File(cnf, "bnd.bnd"));
        File ext = new File(cnf, EXT);
        IO.mkdirs(ext);
        Workspace ws = Workspace.getWorkspace(wsdir);
        return ws;
    }

    public <T> T readLocked(Callable<T> callable, BooleanSupplier canceled, long timeoutInMs) throws Exception {
        return this.workspaceLock.locked(this.workspaceLock.readLock(), timeoutInMs, callable, canceled);
    }

    public <T> T readLocked(Callable<T> callable, BooleanSupplier canceled) throws Exception {
        return this.workspaceLock.locked(this.workspaceLock.readLock(), 120000L, callable, canceled);
    }

    public <T> T readLocked(Callable<T> callable, long timeoutInMs) throws Exception {
        return this.workspaceLock.locked(this.workspaceLock.readLock(), timeoutInMs, callable, () -> false);
    }

    public <T> T readLocked(Callable<T> callable) throws Exception {
        return this.workspaceLock.locked(this.workspaceLock.readLock(), 120000L, callable, () -> false);
    }

    public <T> T writeLocked(Callable<T> callable, BooleanSupplier canceled, long timeoutInMs) throws Exception {
        return this.workspaceLock.locked(this.workspaceLock.writeLock(), timeoutInMs, callable, canceled);
    }

    public <T> T writeLocked(Callable<T> callable, BooleanSupplier canceled) throws Exception {
        return this.workspaceLock.locked(this.workspaceLock.writeLock(), 120000L, callable, canceled);
    }

    public <T> T writeLocked(Callable<T> callable, long timeoutInMs) throws Exception {
        return this.workspaceLock.locked(this.workspaceLock.writeLock(), timeoutInMs, callable, () -> false);
    }

    public <T> T writeLocked(Callable<T> callable) throws Exception {
        return this.workspaceLock.locked(this.workspaceLock.writeLock(), 120000L, callable, () -> false);
    }

    public <T, U> T writeLocked(Callable<U> underWrite, FunctionWithException<U, T> underRead, BooleanSupplier canceled, long timeoutInMs) throws Exception {
        return this.workspaceLock.writeReadLocked(timeoutInMs, underWrite, underRead, canceled);
    }

    public <T, U> T writeLocked(Callable<U> underWrite, FunctionWithException<U, T> underRead, BooleanSupplier canceled) throws Exception {
        return this.workspaceLock.writeReadLocked(120000L, underWrite, underRead, canceled);
    }

    public <T, U> T writeLocked(Callable<U> underWrite, FunctionWithException<U, T> underRead, long timeoutInMs) throws Exception {
        return this.workspaceLock.writeReadLocked(timeoutInMs, underWrite, underRead, () -> false);
    }

    public <T, U> T writeLocked(Callable<U> underWrite, FunctionWithException<U, T> underRead) throws Exception {
        return this.workspaceLock.writeReadLocked(120000L, underWrite, underRead, () -> false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String _projectswhere(String[] args) {
        if (projectswhereCycleCheck.get() != null) {
            throw new IllegalStateException("The ${projectswhere} macro is called recursively");
        }
        projectswhereCycleCheck.set(Boolean.TRUE);
        try {
            boolean negate;
            Glob g;
            Macro.verifyCommand(args, _projectswhereHelp, null, 1, 3);
            Collection<Project> allProjects = this.getAllProjects();
            if (args.length == 1) {
                String string = Strings.join(allProjects);
                return string;
            }
            String key = args[1];
            if (args.length > 2) {
                if (args[2].startsWith("!")) {
                    g = new Glob(args[2].substring(1));
                    negate = true;
                } else {
                    g = new Glob(args[2]);
                    negate = false;
                }
            } else {
                g = null;
                negate = false;
            }
            String string = allProjects.stream().filter(p -> {
                String value = p.getProperty(key);
                if (value == null) {
                    return negate;
                }
                if (g == null) {
                    return !negate;
                }
                return negate ^ g.matcher(value).matches();
            }).map(Project::getName).collect(Strings.joining());
            return string;
        }
        finally {
            projectswhereCycleCheck.set(null);
        }
    }

    public void refresh(RepositoryPlugin repo) {
        for (RepositoryListenerPlugin listener : this.getPlugins(RepositoryListenerPlugin.class)) {
            try {
                listener.repositoryRefreshed(repo);
            }
            catch (Exception e) {
                this.exception(e, "Updating listener plugin %s", listener);
            }
        }
    }

    public Result<Map<String, List<BundleId>>> search(String partialFqn) throws Exception {
        return this.readLocked(() -> ((WorkspaceClassIndex)this.data.classIndex.get()).search(partialFqn));
    }

    public Result<Map<String, List<BundleId>>> search(String packageName, String className) throws Exception {
        return this.readLocked(() -> ((WorkspaceClassIndex)this.data.classIndex.get()).search(packageName, className));
    }

    public Repository getResourceRepository(ResourceRepositoryStrategy strategy) throws Exception {
        List<Object> plugins;
        switch (strategy) {
            case WORKSPACE: {
                plugins = Collections.singletonList(new WorkspaceRepositoryDynamic(this));
                break;
            }
            case REPOS: {
                plugins = this.getPlugins(Repository.class);
                plugins.removeIf(WorkspaceRepositoryMarker.class::isInstance);
                break;
            }
            case ALL: {
                plugins = this.getPlugins(Repository.class);
                plugins.removeIf(WorkspaceRepositoryMarker.class::isInstance);
                plugins.add(new WorkspaceRepositoryDynamic(this));
                break;
            }
            default: {
                plugins = Collections.emptyList();
            }
        }
        AggregateRepository repository = new AggregateRepository(plugins);
        Parameters augments = this.getMergedParameters("-augment");
        if (augments.isEmpty()) {
            return repository;
        }
        return new AugmentRepository(augments, repository);
    }

    public String _findproviders(String[] args) throws Exception {
        Macro.verifyCommand(args, _findprovidersHelp, null, 2, 4);
        String namespace = args[1];
        String filter = args.length > 2 ? args[2] : null;
        ResourceRepositoryStrategy strategy = ResourceRepositoryStrategy.ALL;
        if (args.length > 3) {
            if (args[3].equalsIgnoreCase(ResourceRepositoryStrategy.ALL.name())) {
                strategy = ResourceRepositoryStrategy.ALL;
            } else if (args[3].equalsIgnoreCase(ResourceRepositoryStrategy.REPOS.name())) {
                strategy = ResourceRepositoryStrategy.REPOS;
            } else if (args[3].equalsIgnoreCase(ResourceRepositoryStrategy.WORKSPACE.name())) {
                strategy = ResourceRepositoryStrategy.WORKSPACE;
            } else {
                this.error("Invalid resource repository strategy: %s. Must be one of the following: %s", args[3], Arrays.toString((Object[])ResourceRepositoryStrategy.values()));
            }
        }
        return this.findProviders(namespace, filter, strategy).map(Capability::getResource).map(ResourceUtils::getBundleId).filter(Objects::nonNull).sorted().distinct().map(BundleId::toString).collect(Collectors.joining(","));
    }

    public Stream<Capability> findProviders(String namespace, String filter) throws Exception {
        return this.findProviders(namespace, filter, ResourceRepositoryStrategy.ALL);
    }

    Stream<Capability> findProviders(String namespace, String filter, ResourceRepositoryStrategy strategy) throws Exception {
        RequirementBuilder rb = new RequirementBuilder(namespace);
        if (Strings.nonNullOrTrimmedEmpty(filter)) {
            rb.filter(filter);
        }
        Requirement requirement = rb.buildSyntheticRequirement();
        Collection resultCollection = (Collection)this.getResourceRepository(strategy).findProviders(Collections.singleton(requirement)).get(requirement);
        return resultCollection != null ? resultCollection.stream() : Stream.empty();
    }

    public WorkspaceExternalPluginHandler getExternalPlugins() {
        return (WorkspaceExternalPluginHandler)this.data.externalPlugins.get();
    }

    public Result<File> getBundle(Resource resource) {
        return this.getBundle(resource, ResourceRepositoryStrategy.ALL);
    }

    public Result<File> getBundle(Resource resource, ResourceRepositoryStrategy strategy) {
        BundleId bundleId = ResourceUtils.getBundleId(resource);
        if (bundleId == null) {
            return Result.err("Not a bundle %s, identity & bnd.info found but was not sufficient: ", resource);
        }
        if (bundleId.getVersion() != null && !Verifier.isVersion(bundleId.getVersion())) {
            return Result.err("Not a proper version %s for %s", bundleId.getVersion(), resource);
        }
        Version version = Version.valueOf(bundleId.getVersion());
        return this.getBundle(bundleId.getBsn(), version, null);
    }

    public Result<File> getBundle(String bsn, Version version, Map<String, String> attrs) {
        return this.getBundle(bsn, version, attrs, ResourceRepositoryStrategy.ALL);
    }

    public Result<File> getBundle(String bsn, Version version, Map<String, String> attrs, ResourceRepositoryStrategy strategy) {
        try {
            File f;
            WorkspaceRepository workspaceRepository;
            SortedSet<Version> versions;
            List<RepositoryPlugin> plugins = this.getPlugins(RepositoryPlugin.class);
            if (strategy == ResourceRepositoryStrategy.ALL || strategy == ResourceRepositoryStrategy.REPOS) {
                for (RepositoryPlugin rp : plugins) {
                    File file = rp.get(bsn, version, attrs, new RepositoryPlugin.DownloadListener[0]);
                    if (file == null) continue;
                    return Result.ok(file);
                }
            }
            if ((strategy == ResourceRepositoryStrategy.ALL || strategy == ResourceRepositoryStrategy.WORKSPACE) && !(versions = (workspaceRepository = this.getWorkspaceRepository()).versions(bsn)).isEmpty() && (f = workspaceRepository.get(bsn, versions.last(), attrs, new RepositoryPlugin.DownloadListener[0])) != null && f.isFile()) {
                return Result.ok(f);
            }
            return Result.err("Cannot find bundle %s %s", bsn, version);
        }
        catch (Exception e) {
            return Result.err("Failed to get bundle %s %s %s", bsn, version, e);
        }
    }

    public OnWorkspace on(String ownerName) {
        return this.notifier.on(ownerName);
    }

    public boolean doExtend(Processor processor) {
        String libraries = processor.mergeLocalProperties("-library");
        if (Strings.nonNullOrEmpty(libraries)) {
            ((LibraryHandler)this.data.libraryHandler.get()).update(processor, libraries, "-library");
            return true;
        }
        return false;
    }

    public Result<File> getExpandedInCache(Resource resource) {
        try {
            Result<File> result;
            ResourceUtils.IdentityCapability id = ResourceUtils.getIdentityCapability(resource);
            if (id == null) {
                return Result.err("the resource %s has no identity capability", resource);
            }
            String bsn = id.osgi_identity();
            if (bsn == null) {
                return Result.err("the resource %s lacks a symbolic name", resource);
            }
            if (!Verifier.isBsn(bsn)) {
                return Result.err("the resource %s has an invalid symbolic name", resource);
            }
            Version version = id.version();
            if (version == null) {
                version = Version.emptyVersion;
            }
            if ((result = this.getBundle(resource, ResourceRepositoryStrategy.ALL)).isErr()) {
                return result;
            }
            return this.getExpandedInCache("urn:resource:" + bsn + "-" + version.toStringWithoutQualifier(), result.unwrap());
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    public Result<File> getExpandedInCache(String urn, File file) throws IOException {
        String safeFileName = IO.toSafeFileName(urn);
        File cache = this.getCache("expanded/" + safeFileName);
        File receiptFile = IO.getFile(cache, ".receipt");
        if (cache.exists()) {
            try {
                if (receiptFile.isFile() && receiptFile.lastModified() > file.lastModified()) {
                    String receipt = IO.collect(receiptFile);
                    if (file.toString().equals(receipt)) {
                        return Result.ok(cache);
                    }
                }
            }
            catch (Exception receipt) {
                // empty catch block
            }
            IO.delete(cache);
        }
        cache.mkdirs();
        if (!cache.isDirectory()) {
            return Result.err("cannot create cache directory %s for %s from %s", cache, urn, file);
        }
        Jar jar = new Jar(file);
        try {
            jar.expand(cache);
            IO.store((Object)file.toString(), receiptFile);
            Result<File> result = Result.ok(cache);
            jar.close();
            return result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return Result.err("Failed to expand %s into %s: %s", file, cache, e);
            }
        }
    }

    class WorkspaceData
    implements AutoCloseable {
        final Memoize<List<RepositoryPlugin>> repositories = Memoize.supplier(() -> Workspace.access$000(this$0));
        final RemoteWorkspaceServer remoteServer;
        final CloseableMemoize<WorkspaceClassIndex> classIndex;
        final CloseableMemoize<WorkspaceExternalPluginHandler> externalPlugins;
        final CloseableMemoize<LibraryHandler> libraryHandler = CloseableMemoize.closeableSupplier(() -> new LibraryHandler(Workspace.this));
        final Memoize<Parameters> gestalt;

        WorkspaceData() {
            this.classIndex = CloseableMemoize.closeableSupplier(() -> new WorkspaceClassIndex(Workspace.this));
            this.externalPlugins = CloseableMemoize.closeableSupplier(() -> new WorkspaceExternalPluginHandler(Workspace.this));
            this.gestalt = Memoize.supplier(() -> {
                Parameters gestalt = Workspace.this.getMergedParameters("-gestalt");
                gestalt.mergeWith(overallGestalt, false);
                return gestalt;
            });
            RemoteWorkspaceServer s = null;
            if (remoteWorkspaces || Processor.isTrue(Workspace.this.getProperty("-remoteworkspace"))) {
                try {
                    s = new RemoteWorkspaceServer(Workspace.this);
                }
                catch (IOException e) {
                    Workspace.this.exception(e, "Could not create remote workspace %s", Workspace.this.getBase());
                }
            }
            this.remoteServer = s;
        }

        @Override
        public void close() {
            IO.close(this.libraryHandler);
            IO.close(this.remoteServer);
            IO.close(this.classIndex);
            IO.close(this.externalPlugins);
        }
    }

    class CachedFileRepo
    extends FileRepo {
        final Lock lock;
        boolean inited;

        CachedFileRepo() {
            super(Workspace.BND_CACHE_REPONAME, Workspace.this.getCache(Workspace.BND_CACHE_REPONAME), false);
            this.lock = new ReentrantLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean init() throws Exception {
            if (this.lock.tryLock(50L, TimeUnit.SECONDS)) {
                try {
                    if (super.init()) {
                        this.inited = true;
                        IO.mkdirs(this.root);
                        if (!this.root.isDirectory()) {
                            throw new IllegalArgumentException("Cache directory " + this.root + " not a directory");
                        }
                        URL url = this.getClass().getResource("/embedded-repo.jar");
                        if (url != null) {
                            try (aQute.bnd.osgi.Resource resource = aQute.bnd.osgi.Resource.fromURL(url);
                                 InputStream in = resource.openInputStream();){
                                if (in != null) {
                                    this.unzip(in, this.root.toPath());
                                    boolean bl = true;
                                    return bl;
                                }
                            }
                        }
                        Workspace.this.error("Could not find /embedded-repo.jar as a resource on the classpath", new Object[0]);
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.lock.unlock();
                }
            }
            throw new TimeoutException("Cannot acquire Cached File Repo lock");
        }

        private void unzip(InputStream in, Path dir) throws Exception {
            try (JarInputStream jin = new JarInputStream(in);){
                JarEntry jentry;
                String timestamp;
                FileTime modifiedTime = FileTime.fromMillis(System.currentTimeMillis());
                Manifest manifest = jin.getManifest();
                if (manifest != null && (timestamp = manifest.getMainAttributes().getValue("Timestamp")) != null) {
                    long seconds = TimeUnit.MILLISECONDS.toSeconds(Long.parseLong(timestamp));
                    modifiedTime = FileTime.from(seconds, TimeUnit.SECONDS);
                }
                while ((jentry = jin.getNextJarEntry()) != null) {
                    Path dest;
                    String jentryName;
                    if (jentry.isDirectory() || (jentryName = ZipUtil.cleanPath(jentry.getName())).startsWith("META-INF/") || Files.isRegularFile(dest = IO.getBasedPath(dir, jentryName), new LinkOption[0]) && Files.getLastModifiedTime(dest, new LinkOption[0]).compareTo(modifiedTime) >= 0) continue;
                    IO.mkdirs(dest.getParent());
                    IO.copy((InputStream)new NonClosingInputStream(jin), dest);
                    Files.setLastModifiedTime(dest, modifiedTime);
                }
            }
        }
    }

    public static enum ResourceRepositoryStrategy {
        ALL,
        REPOS,
        WORKSPACE;

    }
}

