/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.ast;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.language.simple.ast.BaseSimpleNode;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;

public class BooleanExpression
extends BaseSimpleNode {
    private final boolean value;

    public BooleanExpression(SimpleToken token) {
        super(token);
        this.value = "true".equals(token.getText());
    }

    @Override
    public Expression createExpression(final CamelContext camelContext, String expression) throws SimpleParserException {
        return new Expression(){

            public <T> T evaluate(Exchange exchange, Class<T> type) {
                if (type == Object.class || type == Boolean.class || type == Boolean.TYPE) {
                    return (T)Boolean.valueOf(BooleanExpression.this.value);
                }
                return (T)camelContext.getTypeConverter().tryConvertTo(type, exchange, (Object)BooleanExpression.this.value);
            }

            public String toString() {
                return "" + BooleanExpression.this.value;
            }
        };
    }
}

