/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.support.processor.PredicateValidationException;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicateValidatingProcessor
extends ServiceSupport
implements Processor,
Traceable {
    private static final Logger LOG = LoggerFactory.getLogger(PredicateValidatingProcessor.class);
    private final Predicate predicate;

    public PredicateValidatingProcessor(Predicate predicate) {
        ObjectHelper.notNull((Object)predicate, (String)"predicate", (Object)((Object)this));
        this.predicate = predicate;
    }

    public void process(Exchange exchange) throws Exception {
        boolean matches = this.predicate.matches(exchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validation {} for {} with Predicate[{}]", new Object[]{matches ? "succeed" : "failed", exchange, this.predicate});
        }
        if (!matches) {
            throw new PredicateValidationException(exchange, this.predicate);
        }
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public String toString() {
        return "validate(" + this.predicate + ")";
    }

    public String getTraceLabel() {
        return "validate[" + this.predicate + "]";
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

