/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.preauth.filter;

import java.security.Principal;
import java.util.Set;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.knox.gateway.preauth.filter.AbstractPreAuthFederationFilter;
import org.apache.knox.gateway.security.GroupPrincipal;

public class HeaderPreAuthFederationFilter
extends AbstractPreAuthFederationFilter {
    static final String CUSTOM_HEADER_PARAM = "preauth.custom.header";
    static final String CUSTOM_GROUP_HEADER_PARAM = "preauth.custom.group.header";
    String headerName = "SM_USER";
    String groupHeaderName;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String customGroupHeader;
        super.init(filterConfig);
        String customHeader = filterConfig.getInitParameter(CUSTOM_HEADER_PARAM);
        if (customHeader != null) {
            this.headerName = customHeader;
        }
        if ((customGroupHeader = filterConfig.getInitParameter(CUSTOM_GROUP_HEADER_PARAM)) != null) {
            this.groupHeaderName = customGroupHeader;
        }
    }

    @Override
    protected String getPrimaryPrincipal(HttpServletRequest httpRequest) {
        return httpRequest.getHeader(this.headerName);
    }

    @Override
    protected void addGroupPrincipals(HttpServletRequest request, Set<Principal> principals) {
        String headers;
        if (this.groupHeaderName != null && (headers = request.getHeader(this.groupHeaderName)) != null) {
            String[] groups;
            for (String group : groups = headers.split(",")) {
                principals.add((Principal)new GroupPrincipal(group));
            }
        }
    }
}

