/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class AuthFilterUtils {
    public static final String DEFAULT_AUTH_UNAUTHENTICATED_PATHS_PARAM = "/knoxtoken/api/v1/jwks.json";

    public static boolean doesRequestContainUnauthPath(Set<String> unAuthenticatedPaths, ServletRequest request) {
        return unAuthenticatedPaths.contains(((HttpServletRequest)request).getPathInfo());
    }

    public static void parseStringThenAdd(Set<String> unAuthenticatedPaths, String list) {
        StringTokenizer tokenizer = new StringTokenizer(list, ";,");
        while (tokenizer.hasMoreTokens()) {
            unAuthenticatedPaths.add(tokenizer.nextToken());
        }
    }

    public static void addUnauthPaths(Set<String> unAuthenticatedPaths, String list, String defaultList) {
        AuthFilterUtils.parseStringThenAdd(unAuthenticatedPaths, defaultList);
        if (!StringUtils.isBlank((CharSequence)list)) {
            AuthFilterUtils.parseStringThenAdd(unAuthenticatedPaths, list);
        }
    }
}

