/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.config;

import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.oauth.OAuth10aService;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuthConfiguration;

public class OAuth10Configuration
extends OAuthConfiguration<OAuth10aService, OAuth1AccessToken> {
    public static final String OAUTH_VERIFIER = "oauth_verifier";
    public static final String REQUEST_TOKEN = "requestToken";
    private DefaultApi10a api;

    @Override
    protected void internalInit() {
        CommonHelper.assertNotNull((String)"api", (Object)this.api);
        super.internalInit();
    }

    @Override
    public OAuth10aService buildService(WebContext context, IndirectClient client) {
        this.init();
        String finalCallbackUrl = client.computeFinalCallbackUrl(context);
        return this.api.createService(this.key, this.secret, finalCallbackUrl, this.scope, null, null, this.httpClientConfig, null);
    }

    public String getRequestTokenSessionAttributeName(String clientName) {
        return clientName + "#" + REQUEST_TOKEN;
    }

    public DefaultApi10a getApi() {
        return this.api;
    }

    public void setApi(DefaultApi10a api) {
        this.api = api;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"key", this.key, "secret", "[protected]", "tokenAsHeader", this.tokenAsHeader, "responseType", this.responseType, "scope", this.scope, "api", this.api, "hasBeenCancelledFactory", this.hasBeenCancelledFactory, "profileDefinition", this.profileDefinition, "httpClientConfig", this.httpClientConfig});
    }
}

