/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso.impl;

import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.shibboleth.utilities.java.support.net.BasicURLComparator;
import net.shibboleth.utilities.java.support.net.URIComparator;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.BaseID;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.EncryptedAttribute;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.crypto.SAML2SignatureTrustEngineProvider;
import org.pac4j.saml.exceptions.SAMAssertionSubjectException;
import org.pac4j.saml.exceptions.SAMLAssertionAudienceException;
import org.pac4j.saml.exceptions.SAMLAssertionConditionException;
import org.pac4j.saml.exceptions.SAMLAuthnInstantException;
import org.pac4j.saml.exceptions.SAMLAuthnSessionCriteriaException;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.exceptions.SAMLInResponseToMismatchException;
import org.pac4j.saml.exceptions.SAMLReplayException;
import org.pac4j.saml.exceptions.SAMLSignatureRequiredException;
import org.pac4j.saml.exceptions.SAMLSignatureValidationException;
import org.pac4j.saml.exceptions.SAMLSubjectConfirmationException;
import org.pac4j.saml.profile.impl.AbstractSAML2ResponseValidator;
import org.pac4j.saml.replay.ReplayCacheProvider;
import org.pac4j.saml.store.SAMLMessageStore;
import org.pac4j.saml.util.Configuration;
import org.pac4j.saml.util.SAML2Utils;

public class SAML2AuthnResponseValidator
extends AbstractSAML2ResponseValidator {
    private int maximumAuthenticationLifetime;
    private final boolean wantsAssertionsSigned;
    private final boolean wantsResponsesSigned;
    private final boolean allSignatureValidationDisabled;

    public SAML2AuthnResponseValidator(SAML2SignatureTrustEngineProvider engine, Decrypter decrypter, LogoutHandler logoutHandler, int maximumAuthenticationLifetime, boolean wantsAssertionsSigned, boolean wantsResponsesSigned, ReplayCacheProvider replayCache, boolean allSignatureValidationDisabled) {
        this(engine, decrypter, logoutHandler, maximumAuthenticationLifetime, wantsAssertionsSigned, wantsResponsesSigned, replayCache, allSignatureValidationDisabled, (URIComparator)new BasicURLComparator());
    }

    public SAML2AuthnResponseValidator(SAML2SignatureTrustEngineProvider engine, Decrypter decrypter, LogoutHandler logoutHandler, int maximumAuthenticationLifetime, boolean wantsAssertionsSigned, boolean wantsResponsesSigned, ReplayCacheProvider replayCache, boolean allSignatureValidationDisabled, URIComparator uriComparator) {
        super(engine, decrypter, logoutHandler, replayCache, uriComparator);
        this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
        this.wantsAssertionsSigned = wantsAssertionsSigned;
        this.wantsResponsesSigned = wantsResponsesSigned;
        this.allSignatureValidationDisabled = allSignatureValidationDisabled;
    }

    @Override
    public Credentials validate(SAML2MessageContext context) {
        SAMLObject message = (SAMLObject)context.getMessage();
        if (!(message instanceof Response)) {
            throw new SAMLException("Must be a Response type");
        }
        Response response = (Response)message;
        SignatureTrustEngine engine = this.signatureTrustEngineProvider.build();
        this.verifyMessageReplay(context);
        this.validateSamlProtocolResponse(response, context, engine);
        if (this.decrypter != null) {
            this.decryptEncryptedAssertions(response, this.decrypter);
        }
        this.validateSamlSSOResponse(response, context, engine, this.decrypter);
        return this.buildSAML2Credentials(context);
    }

    protected SAML2Credentials buildSAML2Credentials(SAML2MessageContext context) {
        NameID nameId = context.getSAMLSubjectNameIdentifierContext().getSAML2SubjectNameID();
        Assertion subjectAssertion = context.getSubjectAssertion();
        String sessionIndex = this.getSessionIndex(subjectAssertion);
        String sloKey = this.computeSloKey(sessionIndex, nameId);
        if (sloKey != null) {
            this.logoutHandler.recordSession(context.getWebContext(), sloKey);
        }
        String issuerEntityId = subjectAssertion.getIssuer().getValue();
        List authnStatements = subjectAssertion.getAuthnStatements();
        ArrayList<String> authnContexts = new ArrayList<String>();
        for (AuthnStatement authnStatement : authnStatements) {
            if (authnStatement.getAuthnContext().getAuthnContextClassRef() == null) continue;
            authnContexts.add(authnStatement.getAuthnContext().getAuthnContextClassRef().getAuthnContextClassRef());
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (AttributeStatement attributeStatement : subjectAssertion.getAttributeStatements()) {
            for (Attribute attribute : attributeStatement.getAttributes()) {
                attributes.add(attribute);
            }
            if (attributeStatement.getEncryptedAttributes().isEmpty()) continue;
            if (this.decrypter == null) {
                this.logger.warn("Encrypted attributes returned, but no keystore was provided.");
                continue;
            }
            for (EncryptedAttribute encryptedAttribute : attributeStatement.getEncryptedAttributes()) {
                try {
                    attributes.add(this.decrypter.decrypt(encryptedAttribute));
                }
                catch (DecryptionException e) {
                    this.logger.warn("Decryption of attribute failed, continue with the next one", (Throwable)e);
                }
            }
        }
        return new SAML2Credentials(nameId, issuerEntityId, attributes, subjectAssertion.getConditions(), sessionIndex, authnContexts);
    }

    protected String getSessionIndex(Assertion subjectAssertion) {
        AuthnStatement statement;
        List authnStatements = subjectAssertion.getAuthnStatements();
        if (authnStatements != null && authnStatements.size() > 0 && (statement = (AuthnStatement)authnStatements.get(0)) != null) {
            return statement.getSessionIndex();
        }
        return null;
    }

    protected void validateSamlProtocolResponse(Response response, SAML2MessageContext context, SignatureTrustEngine engine) {
        this.validateSuccess(response.getStatus());
        if (this.wantsResponsesSigned && response.getSignature() == null) {
            this.logger.debug("Unable to find a signature on the SAML response returned. Pac4j is configured to enforce signatures on SAML2 responses from identity providers and the returned response\n{}\ndoes not contain any signature", (Object)Configuration.serializeSamlObject((XMLObject)response));
            throw new SAMLSignatureValidationException("Unable to find a signature on the SAML response returned");
        }
        this.validateSignatureIfItExists(response.getSignature(), context, engine);
        this.validateIssueInstant(response.getIssueInstant());
        AuthnRequest request = null;
        SAMLMessageStore messageStorage = context.getSAMLMessageStore();
        if (messageStorage != null && response.getInResponseTo() != null) {
            Optional xmlObject = messageStorage.get(response.getInResponseTo());
            if (!xmlObject.isPresent()) {
                throw new SAMLInResponseToMismatchException("InResponseToField of the Response doesn't correspond to sent message " + response.getInResponseTo());
            }
            if (xmlObject.get() instanceof AuthnRequest) {
                request = (AuthnRequest)xmlObject.get();
            } else {
                throw new SAMLInResponseToMismatchException("Sent request was of different type than the expected AuthnRequest " + response.getInResponseTo());
            }
        }
        this.verifyEndpoint(context.getSAMLEndpointContext().getEndpoint(), response.getDestination());
        if (request != null) {
            this.verifyRequest(request, context);
        }
        this.validateIssuerIfItExists(response.getIssuer(), context);
    }

    protected void verifyRequest(AuthnRequest request, SAML2MessageContext context) {
        AssertionConsumerService assertionConsumerService = (AssertionConsumerService)context.getSAMLEndpointContext().getEndpoint();
        if (request.getAssertionConsumerServiceIndex() != null) {
            if (!request.getAssertionConsumerServiceIndex().equals(assertionConsumerService.getIndex())) {
                this.logger.warn("Response was received at a different endpoint index than was requested");
            }
        } else {
            String responseLocation;
            String requestedResponseURL = request.getAssertionConsumerServiceURL();
            String requestedBinding = request.getProtocolBinding();
            if (requestedResponseURL != null && !requestedResponseURL.equals(responseLocation = assertionConsumerService.getResponseLocation() != null ? assertionConsumerService.getResponseLocation() : assertionConsumerService.getLocation())) {
                this.logger.warn("Response was received at a different endpoint URL {} than was requested {}", (Object)responseLocation, (Object)requestedResponseURL);
            }
            if (requestedBinding != null && !requestedBinding.equals(context.getSAMLBindingContext().getBindingUri())) {
                this.logger.warn("Response was received using a different binding {} than was requested {}", (Object)context.getSAMLBindingContext().getBindingUri(), (Object)requestedBinding);
            }
        }
    }

    protected void validateSamlSSOResponse(Response response, SAML2MessageContext context, SignatureTrustEngine engine, Decrypter decrypter) {
        ArrayList<SAMLException> errors = new ArrayList<SAMLException>();
        for (Assertion assertion : response.getAssertions()) {
            if (assertion.getAuthnStatements().isEmpty()) continue;
            try {
                this.validateAssertion(assertion, context, engine, decrypter);
            }
            catch (SAMLException e) {
                this.logger.error("Current assertion validation failed, continue with the next one", (Throwable)((Object)e));
                errors.add(e);
                continue;
            }
            context.setSubjectAssertion(assertion);
            break;
        }
        if (!errors.isEmpty()) {
            throw (SAMLException)((Object)errors.get(0));
        }
        if (context.getSubjectAssertion() == null) {
            throw new SAMAssertionSubjectException("No valid subject assertion found in response");
        }
        List<SubjectConfirmation> subjectConfirmations = context.getSubjectConfirmations();
        NameID nameIdentifier = (NameID)context.getSAMLSubjectNameIdentifierContext().getSubjectNameIdentifier();
        if (!(nameIdentifier != null && nameIdentifier.getValue() != null || context.getBaseID() != null || subjectConfirmations != null && !subjectConfirmations.isEmpty())) {
            throw new SAMLException("Subject NameID, BaseID and EncryptedID cannot be all null at the same time if there are no Subject Confirmations.");
        }
    }

    protected void decryptEncryptedAssertions(Response response, Decrypter decrypter) {
        for (EncryptedAssertion encryptedAssertion : response.getEncryptedAssertions()) {
            try {
                Assertion decryptedAssertion = decrypter.decrypt(encryptedAssertion);
                response.getAssertions().add(decryptedAssertion);
            }
            catch (DecryptionException e) {
                this.logger.error("Decryption of assertion failed, continue with the next one", (Throwable)e);
            }
        }
    }

    protected void validateAssertion(Assertion assertion, SAML2MessageContext context, SignatureTrustEngine engine, Decrypter decrypter) {
        this.validateIssueInstant(assertion.getIssueInstant());
        this.validateIssuer(assertion.getIssuer(), context);
        if (assertion.getSubject() == null) {
            throw new SAMAssertionSubjectException("Assertion subject cannot be null");
        }
        this.validateSubject(assertion.getSubject(), context, decrypter);
        this.validateAssertionConditions(assertion.getConditions(), context);
        this.validateAuthenticationStatements(assertion.getAuthnStatements(), context);
        this.validateAssertionSignature(assertion.getSignature(), context, engine);
    }

    protected void validateSubject(Subject subject, SAML2MessageContext context, Decrypter decrypter) {
        boolean samlIDFound = false;
        NameID nameIdFromSubject = subject.getNameID();
        BaseID baseIdFromSubject = subject.getBaseID();
        EncryptedID encryptedIdFromSubject = subject.getEncryptedID();
        NameID decryptedNameIdFromSubject = this.decryptEncryptedId(encryptedIdFromSubject, decrypter);
        if (decryptedNameIdFromSubject != null) {
            nameIdFromSubject = decryptedNameIdFromSubject;
        }
        if (nameIdFromSubject != null || baseIdFromSubject != null) {
            context.getSAMLSubjectNameIdentifierContext().setSubjectNameIdentifier((SAMLObject)nameIdFromSubject);
            context.setBaseID(baseIdFromSubject);
            samlIDFound = true;
        }
        for (SubjectConfirmation confirmation : subject.getSubjectConfirmations()) {
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(confirmation.getMethod()) || !this.isValidBearerSubjectConfirmationData(confirmation.getSubjectConfirmationData(), context)) continue;
            this.validateAssertionReplay((Assertion)subject.getParent(), confirmation.getSubjectConfirmationData());
            NameID nameIDFromConfirmation = confirmation.getNameID();
            BaseID baseIDFromConfirmation = confirmation.getBaseID();
            EncryptedID encryptedIDFromConfirmation = confirmation.getEncryptedID();
            NameID decryptedNameIdFromConfirmation = this.decryptEncryptedId(encryptedIDFromConfirmation, decrypter);
            if (decryptedNameIdFromConfirmation != null) {
                nameIDFromConfirmation = decryptedNameIdFromConfirmation;
            }
            if (!(samlIDFound || nameIDFromConfirmation == null && baseIDFromConfirmation == null)) {
                context.getSAMLSubjectNameIdentifierContext().setSubjectNameIdentifier((SAMLObject)nameIDFromConfirmation);
                context.setBaseID(baseIDFromConfirmation);
                context.getSubjectConfirmations().add(confirmation);
                samlIDFound = true;
            }
            if (!samlIDFound) {
                this.logger.warn("Could not find any Subject NameID/BaseID/EncryptedID, neither directly in the Subject nor in any Subject Confirmation.");
            }
            return;
        }
        throw new SAMLSubjectConfirmationException("Subject confirmation validation failed");
    }

    protected boolean isValidBearerSubjectConfirmationData(SubjectConfirmationData data, SAML2MessageContext context) {
        if (data == null) {
            this.logger.debug("SubjectConfirmationData cannot be null for Bearer confirmation");
            return false;
        }
        if (data.getNotBefore() != null) {
            this.logger.debug("SubjectConfirmationData notBefore must be null for Bearer confirmation");
            return false;
        }
        if (data.getNotOnOrAfter() == null) {
            this.logger.debug("SubjectConfirmationData notOnOrAfter cannot be null for Bearer confirmation");
            return false;
        }
        if (data.getNotOnOrAfter().plusSeconds(this.acceptedSkew).isBeforeNow()) {
            this.logger.debug("SubjectConfirmationData notOnOrAfter is too old");
            return false;
        }
        try {
            URI appEndpointUri;
            if (data.getRecipient() == null) {
                this.logger.debug("SubjectConfirmationData recipient cannot be null for Bearer confirmation");
                return false;
            }
            Endpoint endpoint = context.getSAMLEndpointContext().getEndpoint();
            if (endpoint == null) {
                this.logger.warn("No endpoint was found in the SAML endpoint context");
                return false;
            }
            URI recipientUri = new URI(data.getRecipient());
            if (!SAML2Utils.urisEqualAfterPortNormalization(recipientUri, appEndpointUri = new URI(endpoint.getLocation()))) {
                this.logger.debug("SubjectConfirmationData recipient {} does not match SP assertion consumer URL, found. SP ACS URL from context: {}", (Object)recipientUri, (Object)appEndpointUri);
                return false;
            }
        }
        catch (URISyntaxException use) {
            this.logger.error("Unable to check SubjectConfirmationData recipient, a URI has invalid syntax.", (Throwable)use);
            return false;
        }
        return true;
    }

    protected void validateAssertionReplay(Assertion assertion, SubjectConfirmationData data) {
        if (assertion.getID() == null) {
            throw new SAMLReplayException("The assertion does not have an ID");
        }
        if (this.replayCache == null) {
            this.logger.warn("No replay cache specified, skipping replay verification");
            return;
        }
        if (!this.replayCache.get().check(this.getClass().getName(), assertion.getID(), data.getNotOnOrAfter().getMillis() + (long)(this.acceptedSkew * 1000))) {
            throw new SAMLReplayException("Rejecting replayed assertion ID '" + assertion.getID() + "'");
        }
    }

    protected void validateAssertionConditions(Conditions conditions, SAML2MessageContext context) {
        if (conditions == null) {
            return;
        }
        if (conditions.getNotBefore() != null && conditions.getNotBefore().minusSeconds(this.acceptedSkew).isAfterNow()) {
            throw new SAMLAssertionConditionException("Assertion condition notBefore is not valid");
        }
        if (conditions.getNotOnOrAfter() != null && conditions.getNotOnOrAfter().plusSeconds(this.acceptedSkew).isBeforeNow()) {
            throw new SAMLAssertionConditionException("Assertion condition notOnOrAfter is not valid");
        }
        String entityId = context.getSAMLSelfEntityContext().getEntityId();
        this.validateAudienceRestrictions(conditions.getAudienceRestrictions(), entityId);
    }

    protected void validateAudienceRestrictions(List<AudienceRestriction> audienceRestrictions, String spEntityId) {
        if (audienceRestrictions == null || audienceRestrictions.isEmpty()) {
            throw new SAMLAssertionAudienceException("Audience restrictions cannot be null or empty");
        }
        HashSet<String> audienceUris = new HashSet<String>();
        for (AudienceRestriction audienceRestriction : audienceRestrictions) {
            if (audienceRestriction.getAudiences() == null) continue;
            for (Audience audience : audienceRestriction.getAudiences()) {
                audienceUris.add(audience.getAudienceURI());
            }
        }
        if (!audienceUris.contains(spEntityId)) {
            throw new SAMLAssertionAudienceException("Assertion audience " + audienceUris + " does not match SP configuration " + spEntityId);
        }
    }

    protected void validateAuthenticationStatements(List<AuthnStatement> authnStatements, SAML2MessageContext context) {
        for (AuthnStatement statement : authnStatements) {
            if (!this.isAuthnInstantValid(statement.getAuthnInstant())) {
                throw new SAMLAuthnInstantException("Authentication issue instant is too old or in the future");
            }
            if (statement.getSessionNotOnOrAfter() == null || !statement.getSessionNotOnOrAfter().isBeforeNow()) continue;
            throw new SAMLAuthnSessionCriteriaException("Authentication session between IDP and subject has ended");
        }
    }

    protected void validateAssertionSignature(Signature signature, SAML2MessageContext context, SignatureTrustEngine engine) {
        SAMLPeerEntityContext peerContext = context.getSAMLPeerEntityContext();
        if (signature != null) {
            String entityId = peerContext.getEntityId();
            this.validateSignature(signature, entityId, engine);
        } else {
            if (this.wantsAssertionsSigned(context).booleanValue()) {
                throw new SAMLSignatureRequiredException("Assertion must be explicitly signed");
            }
            if (!peerContext.isAuthenticated() && !this.allSignatureValidationDisabled) {
                throw new SAMLSignatureRequiredException("Unauthenticated response contains an unsigned assertion");
            }
        }
    }

    @VisibleForTesting
    Boolean wantsAssertionsSigned(SAML2MessageContext context) {
        if (context == null) {
            return this.wantsAssertionsSigned;
        }
        SPSSODescriptor spDescriptor = context.getSPSSODescriptor();
        if (spDescriptor == null) {
            return this.wantsAssertionsSigned;
        }
        return spDescriptor.getWantAssertionsSigned();
    }

    private boolean isAuthnInstantValid(DateTime authnInstant) {
        return this.isDateValid(authnInstant, this.maximumAuthenticationLifetime);
    }

    @Override
    public final void setMaximumAuthenticationLifetime(int maximumAuthenticationLifetime) {
        this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
    }
}

