/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.livy;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class LivyServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "LIVYSERVER";
    public static final String SERVICE_TYPE = "LIVY";
    public static final String ROLE_TYPE = "LIVY_SERVER";
    static final String SSL_ENABLED = "ssl_enabled";
    static final String LIVY_SERVER_PORT = "livy_server_port";

    @Override
    public String getService() {
        return SERVICE;
    }

    @Override
    public String getServiceType() {
        return SERVICE_TYPE;
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.API;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        String hostname = role.getHostRef().getHostname();
        String port = this.getRoleConfigValue(roleConfig, LIVY_SERVER_PORT);
        String sslEnabled = this.getRoleConfigValue(roleConfig, SSL_ENABLED);
        String scheme = Boolean.parseBoolean(sslEnabled) ? "https" : "http";
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
        model.addRoleProperty(this.getRoleType(), SSL_ENABLED, sslEnabled);
        model.addRoleProperty(this.getRoleType(), LIVY_SERVER_PORT, port);
        return model;
    }
}

