/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.asn1;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.ldaptive.asn1.AbstractDERType;
import org.ldaptive.asn1.DEREncoder;
import org.ldaptive.asn1.DERTag;
import org.ldaptive.asn1.UniversalDERTag;

public class UuidType
extends AbstractDERType
implements DEREncoder {
    private static final int UUID_LENGTH = 16;
    private final byte[] derItem;

    public UuidType(UUID item) {
        super(UniversalDERTag.OCTSTR);
        this.derItem = UuidType.toBytes(item);
    }

    public UuidType(DERTag tag, UUID item) {
        super(tag);
        if (tag.isConstructed()) {
            throw new IllegalArgumentException("DER tag must not be constructed");
        }
        this.derItem = UuidType.toBytes(item);
    }

    @Override
    public byte[] encode() {
        return this.encode(new byte[][]{this.derItem});
    }

    public static UUID decode(ByteBuffer encoded) {
        ByteBuffer buffer = ByteBuffer.wrap(UuidType.readBuffer(encoded));
        long mostSig = buffer.getLong();
        long leastSig = buffer.getLong();
        return new UUID(mostSig, leastSig);
    }

    public static byte[] toBytes(UUID uuid) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        return buffer.array();
    }
}

