/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.builder.property.interpreter;

import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.topology.Service;
import org.apache.knox.gateway.topology.Topology;
import org.apache.knox.gateway.topology.builder.property.interpreter.AbstractInterpreter;
import org.apache.knox.gateway.topology.builder.property.interpreter.InterpretException;
import org.apache.knox.gateway.topology.builder.property.interpreter.ServiceParameterPropertyInterpreter;

public class ServicePropertyInterpreter
extends AbstractInterpreter {
    private static final String SERVICE_URL = "url";
    private static final String AGGREGATOR_PARAM = "param";
    private static GatewayResources gatewayResources = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    private Topology topology;

    public ServicePropertyInterpreter(Topology topology) {
        if (topology == null) {
            throw new IllegalArgumentException(gatewayResources.topologyIsRequiredError());
        }
        this.topology = topology;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void interpret(String token, String value) throws InterpretException {
        String nextToken;
        int dotPosition = token.indexOf(".");
        if (dotPosition == -1) {
            throw new InterpretException(gatewayResources.unsupportedPropertyTokenError(token));
        }
        String serviceRole = token.substring(0, dotPosition);
        if (serviceRole != null && serviceRole.isEmpty()) {
            serviceRole = null;
        }
        if ((dotPosition = (nextToken = token.substring(dotPosition + 1)).indexOf(".")) == -1) {
            throw new InterpretException(gatewayResources.unsupportedPropertyTokenError(token));
        }
        String serviceName = nextToken.substring(0, dotPosition);
        if (serviceName != null && serviceName.isEmpty()) {
            serviceName = null;
        }
        nextToken = nextToken.substring(dotPosition + 1);
        Service service = this.topology.getService(serviceRole, serviceName, null);
        if (service == null) {
            service = new Service();
            service.setName(serviceName);
            service.setRole(serviceRole);
            this.topology.addService(service);
        }
        if (SERVICE_URL.equalsIgnoreCase(nextToken)) {
            service.addUrl(value);
            return;
        } else {
            dotPosition = nextToken.indexOf(".");
            if (dotPosition == -1) throw new InterpretException(gatewayResources.unsupportedPropertyTokenError(token));
            String aggregator = nextToken.substring(0, dotPosition);
            nextToken = nextToken.substring(dotPosition + 1);
            if (!AGGREGATOR_PARAM.equalsIgnoreCase(aggregator)) throw new InterpretException(gatewayResources.unsupportedPropertyTokenError(token));
            new ServiceParameterPropertyInterpreter(service).interpret(nextToken, value);
        }
    }
}

