/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.knoxsso;

import org.apache.knox.gateway.i18n.messages.Message;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.StackTrace;

@Messages(logger="org.apache.knox.gateway.service.knoxsso")
public interface KnoxSSOMessages {
    @Message(level=MessageLevel.INFO, text="About to redirect to original URL: {0}")
    public void aboutToRedirectToOriginal(String var1);

    @Message(level=MessageLevel.DEBUG, text="Adding the following JWT token as a cookie: {0}")
    public void addingJWTCookie(String var1);

    @Message(level=MessageLevel.ERROR, text="Unable to properly send needed HTTP status code: {0}, {1}")
    public void unableToCloseOutputStream(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Unable to add cookie to response. {0}: {1}")
    public void unableAddCookieToResponse(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Original URL not found in request.")
    public void originalURLNotFound();

    @Message(level=MessageLevel.INFO, text="JWT cookie successfully added.")
    public void addedJWTCookie();

    @Message(level=MessageLevel.ERROR, text="Unable to issue token.")
    public void unableToIssueToken(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.WARN, text="The SSO cookie SecureOnly flag is set to FALSE and is therefore insecure.")
    public void cookieSecureOnly(boolean var1);

    @Message(level=MessageLevel.WARN, text="The SSO cookie max age configuration is invalid: {0} - using default.")
    public void invalidMaxAgeEncountered(String var1);

    @Message(level=MessageLevel.WARN, text="The SSO token time to live - ttl is invalid: {0} - using default.")
    public void invalidTokenTTLEncountered(String var1);

    @Message(level=MessageLevel.INFO, text="The cookie max age is being set to: {0}.")
    public void setMaxAge(String var1);

    @Message(level=MessageLevel.ERROR, text="The original URL: {0} for redirecting back after authentication is not valid according to the configured whitelist: {1}. See documentation for KnoxSSO Whitelisting.")
    public void whiteListMatchFail(String var1, String var2);
}

