/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.jersey;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.ServiceDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.topology.Service;

public abstract class JerseyServiceDeploymentContributorBase
extends ServiceDeploymentContributorBase {
    private static final String PACKAGES_PARAM = "jersey.config.server.provider.packages";

    protected abstract String[] getPackages();

    protected abstract String[] getPatterns();

    public void contributeService(DeploymentContext context, Service service) throws Exception {
        String packages = StringUtils.join((Object[])this.getPackages(), (String)";");
        for (String pattern : this.getPatterns()) {
            ResourceDescriptor resource = context.getGatewayDescriptor().addResource();
            resource.role(service.getRole());
            resource.pattern(pattern);
            this.addWebAppSecFilters(context, service, resource);
            this.addXForwardedFilter(context, service, resource);
            this.addAuthenticationFilter(context, service, resource);
            this.addIdentityAssertionFilter(context, service, resource);
            this.addAuthorizationFilter(context, service, resource);
            ArrayList<FilterParamDescriptor> params = new ArrayList<FilterParamDescriptor>();
            FilterParamDescriptor param = resource.createFilterParam();
            param.name(PACKAGES_PARAM);
            param.value(packages);
            params.add(param);
            for (Map.Entry serviceParam : service.getParams().entrySet()) {
                context.getWebAppDescriptor().createContextParam().paramName((String)serviceParam.getKey()).paramValue((String)serviceParam.getValue());
            }
            context.contributeFilter(service, resource, "pivot", "jersey", params);
        }
    }
}

