/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Metadata about a YARN application attribute.")
public class ApiYarnApplicationAttribute {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="supportsHistograms")
    private Boolean supportsHistograms = null;
    @SerializedName(value="description")
    private String description = null;

    public ApiYarnApplicationAttribute name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The name of the attribute. This name can be used in filters, for example 'user' could be used in the filter 'user = root'.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiYarnApplicationAttribute type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The type of the attribute. Valid types are STRING, NUMBER, BOOLEAN, BYTES, MILLISECONDS, BYTES_PER_SECOND, BYTE_SECONDS.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ApiYarnApplicationAttribute displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(description="The display name for the attribute.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiYarnApplicationAttribute supportsHistograms(Boolean supportsHistograms) {
        this.supportsHistograms = supportsHistograms;
        return this;
    }

    @Schema(description="Whether the Service Monitor can generate a histogram of the distribution of the attribute across applications.")
    public Boolean isSupportsHistograms() {
        return this.supportsHistograms;
    }

    public void setSupportsHistograms(Boolean supportsHistograms) {
        this.supportsHistograms = supportsHistograms;
    }

    public ApiYarnApplicationAttribute description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="The description of the attribute.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiYarnApplicationAttribute apiYarnApplicationAttribute = (ApiYarnApplicationAttribute)o;
        return Objects.equals(this.name, apiYarnApplicationAttribute.name) && Objects.equals(this.type, apiYarnApplicationAttribute.type) && Objects.equals(this.displayName, apiYarnApplicationAttribute.displayName) && Objects.equals(this.supportsHistograms, apiYarnApplicationAttribute.supportsHistograms) && Objects.equals(this.description, apiYarnApplicationAttribute.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.displayName, this.supportsHistograms, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiYarnApplicationAttribute {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    supportsHistograms: ").append(this.toIndentedString(this.supportsHistograms)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

