// The following code was generated by JFlex 1.5.1
using Lucene.Net.Analysis.TokenAttributes;
using System;
using System.IO;

namespace Lucene.Net.Analysis.Standard
{
    /*
     * Licensed to the Apache Software Foundation (ASF) under one or more
     * contributor license agreements.  See the NOTICE file distributed with
     * this work for additional information regarding copyright ownership.
     * The ASF licenses this file to You under the Apache License, Version 2.0
     * (the "License"); you may not use this file except in compliance with
     * the License.  You may obtain a copy of the License at
     *
     *     http://www.apache.org/licenses/LICENSE-2.0
     *
     * Unless required by applicable law or agreed to in writing, software
     * distributed under the License is distributed on an "AS IS" BASIS,
     * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
     * See the License for the specific language governing permissions and
     * limitations under the License.
     */

    /// <summary>
    /// This class implements Word Break rules from the Unicode Text Segmentation 
    /// algorithm, as specified in 
    /// <a href="http://unicode.org/reports/tr29/">Unicode Standard Annex #29</a>. 
    /// <para/>
    /// Tokens produced are of the following types:
    /// <list type="bullet">
    ///     <item>&lt;ALPHANUM&gt;: A sequence of alphabetic and numeric characters</item>
    ///     <item>&lt;NUM&gt;: A number</item>
    ///     <item>&lt;SOUTHEAST_ASIAN&gt;: A sequence of characters from South and Southeast
    ///         Asian languages, including Thai, Lao, Myanmar, and Khmer</item>
    ///     <item>&lt;IDEOGRAPHIC&gt;: A single CJKV ideographic character</item>
    ///     <item>&lt;HIRAGANA&gt;: A single hiragana character</item>
    ///     <item>&lt;KATAKANA&gt;: A sequence of katakana characters</item>
    ///     <item>&lt;HANGUL&gt;: A sequence of Hangul characters</item>
    /// </list>
    /// </summary>
    public sealed class StandardTokenizerImpl : IStandardTokenizerInterface
    {
        /// <summary>
        /// This character denotes the end of file </summary>
        public static readonly int YYEOF = -1;

        /// <summary>
        /// initial size of the lookahead buffer </summary>
        private static readonly int ZZ_BUFFERSIZE = 4096;

        /// <summary>
        /// lexical states </summary>
        public const int YYINITIAL = 0;

        /// <summary>
        /// ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
        /// ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
        ///                  at the beginning of a line
        /// l is of the form l = 2*k, k a non negative integer
        /// </summary>
        private static readonly int[] ZZ_LEXSTATE = { 0, 0 };

        /// <summary>
        /// Translates characters to character classes
        /// </summary>
        private const string ZZ_CMAP_PACKED =
            "\x0022\x0000\x0001\x008B\x0004\x0000\x0001\x008A\x0004\x0000\x0001\x0083\x0001\x0000\x0001\x0084\x0001\x0000\x000A\x0080" +
            "\x0001\x0082\x0001\x0083\x0005\x0000\x001A\x007E\x0004\x0000\x0001\x0085\x0001\x0000\x001A\x007E\x002F\x0000\x0001\x007E" +
            "\x0002\x0000\x0001\x007F\x0007\x0000\x0001\x007E\x0001\x0000\x0001\x0082\x0002\x0000\x0001\x007E\x0005\x0000\x0017\x007E" +
            "\x0001\x0000\x001F\x007E\x0001\x0000\u01ca\x007E\x0004\x0000\x000C\x007E\x0005\x0000\x0001\x0082\x0008\x0000\x0005\x007E" +
            "\x0007\x0000\x0001\x007E\x0001\x0000\x0001\x007E\x0011\x0000\x0070\x007F\x0005\x007E\x0001\x0000\x0002\x007E\x0002\x0000" +
            "\x0004\x007E\x0001\x0083\x0007\x0000\x0001\x007E\x0001\x0082\x0003\x007E\x0001\x0000\x0001\x007E\x0001\x0000\x0014\x007E" +
            "\x0001\x0000\x0053\x007E\x0001\x0000\x008B\x007E\x0001\x0000\x0007\x007F\x009E\x007E\x0009\x0000\x0026\x007E\x0002\x0000" +
            "\x0001\x007E\x0007\x0000\x0027\x007E\x0001\x0000\x0001\x0083\x0007\x0000\x002D\x007F\x0001\x0000\x0001\x007F\x0001\x0000" +
            "\x0002\x007F\x0001\x0000\x0002\x007F\x0001\x0000\x0001\x007F\x0008\x0000\x001B\x008C\x0005\x0000\x0003\x008C\x0001\x007E" +
            "\x0001\x0082\x000B\x0000\x0005\x007F\x0007\x0000\x0002\x0083\x0002\x0000\x000B\x007F\x0001\x0000\x0001\x007F\x0003\x0000" +
            "\x002B\x007E\x0015\x007F\x000A\x0080\x0001\x0000\x0001\x0080\x0001\x0083\x0001\x0000\x0002\x007E\x0001\x007F\x0063\x007E" +
            "\x0001\x0000\x0001\x007E\x0007\x007F\x0001\x007F\x0001\x0000\x0006\x007F\x0002\x007E\x0002\x007F\x0001\x0000\x0004\x007F" +
            "\x0002\x007E\x000A\x0080\x0003\x007E\x0002\x0000\x0001\x007E\x000F\x0000\x0001\x007F\x0001\x007E\x0001\x007F\x001E\x007E" +
            "\x001B\x007F\x0002\x0000\x0059\x007E\x000B\x007F\x0001\x007E\x000E\x0000\x000A\x0080\x0021\x007E\x0009\x007F\x0002\x007E" +
            "\x0002\x0000\x0001\x0083\x0001\x0000\x0001\x007E\x0005\x0000\x0016\x007E\x0004\x007F\x0001\x007E\x0009\x007F\x0001\x007E" +
            "\x0003\x007F\x0001\x007E\x0005\x007F\x0012\x0000\x0019\x007E\x0003\x007F\x0044\x0000\x0001\x007E\x0001\x0000\x000B\x007E" +
            "\x0037\x0000\x001B\x007F\x0001\x0000\x0004\x007F\x0036\x007E\x0003\x007F\x0001\x007E\x0012\x007F\x0001\x007E\x0007\x007F" +
            "\x000A\x007E\x0002\x007F\x0002\x0000\x000A\x0080\x0001\x0000\x0007\x007E\x0001\x0000\x0007\x007E\x0001\x0000\x0003\x007F" +
            "\x0001\x0000\x0008\x007E\x0002\x0000\x0002\x007E\x0002\x0000\x0016\x007E\x0001\x0000\x0007\x007E\x0001\x0000\x0001\x007E" +
            "\x0003\x0000\x0004\x007E\x0002\x0000\x0001\x007F\x0001\x007E\x0007\x007F\x0002\x0000\x0002\x007F\x0002\x0000\x0003\x007F" +
            "\x0001\x007E\x0008\x0000\x0001\x007F\x0004\x0000\x0002\x007E\x0001\x0000\x0003\x007E\x0002\x007F\x0002\x0000\x000A\x0080" +
            "\x0002\x007E\x000F\x0000\x0003\x007F\x0001\x0000\x0006\x007E\x0004\x0000\x0002\x007E\x0002\x0000\x0016\x007E\x0001\x0000" +
            "\x0007\x007E\x0001\x0000\x0002\x007E\x0001\x0000\x0002\x007E\x0001\x0000\x0002\x007E\x0002\x0000\x0001\x007F\x0001\x0000" +
            "\x0005\x007F\x0004\x0000\x0002\x007F\x0002\x0000\x0003\x007F\x0003\x0000\x0001\x007F\x0007\x0000\x0004\x007E\x0001\x0000" +
            "\x0001\x007E\x0007\x0000\x000A\x0080\x0002\x007F\x0003\x007E\x0001\x007F\x000B\x0000\x0003\x007F\x0001\x0000\x0009\x007E" +
            "\x0001\x0000\x0003\x007E\x0001\x0000\x0016\x007E\x0001\x0000\x0007\x007E\x0001\x0000\x0002\x007E\x0001\x0000\x0005\x007E" +
            "\x0002\x0000\x0001\x007F\x0001\x007E\x0008\x007F\x0001\x0000\x0003\x007F\x0001\x0000\x0003\x007F\x0002\x0000\x0001\x007E" +
            "\x000F\x0000\x0002\x007E\x0002\x007F\x0002\x0000\x000A\x0080\x0011\x0000\x0003\x007F\x0001\x0000\x0008\x007E\x0002\x0000" +
            "\x0002\x007E\x0002\x0000\x0016\x007E\x0001\x0000\x0007\x007E\x0001\x0000\x0002\x007E\x0001\x0000\x0005\x007E\x0002\x0000" +
            "\x0001\x007F\x0001\x007E\x0007\x007F\x0002\x0000\x0002\x007F\x0002\x0000\x0003\x007F\x0008\x0000\x0002\x007F\x0004\x0000" +
            "\x0002\x007E\x0001\x0000\x0003\x007E\x0002\x007F\x0002\x0000\x000A\x0080\x0001\x0000\x0001\x007E\x0010\x0000\x0001\x007F" +
            "\x0001\x007E\x0001\x0000\x0006\x007E\x0003\x0000\x0003\x007E\x0001\x0000\x0004\x007E\x0003\x0000\x0002\x007E\x0001\x0000" +
            "\x0001\x007E\x0001\x0000\x0002\x007E\x0003\x0000\x0002\x007E\x0003\x0000\x0003\x007E\x0003\x0000\x000C\x007E\x0004\x0000" +
            "\x0005\x007F\x0003\x0000\x0003\x007F\x0001\x0000\x0004\x007F\x0002\x0000\x0001\x007E\x0006\x0000\x0001\x007F\x000E\x0000" +
            "\x000A\x0080\x0011\x0000\x0003\x007F\x0001\x0000\x0008\x007E\x0001\x0000\x0003\x007E\x0001\x0000\x0017\x007E\x0001\x0000" +
            "\x000A\x007E\x0001\x0000\x0005\x007E\x0003\x0000\x0001\x007E\x0007\x007F\x0001\x0000\x0003\x007F\x0001\x0000\x0004\x007F" +
            "\x0007\x0000\x0002\x007F\x0001\x0000\x0002\x007E\x0006\x0000\x0002\x007E\x0002\x007F\x0002\x0000\x000A\x0080\x0012\x0000" +
            "\x0002\x007F\x0001\x0000\x0008\x007E\x0001\x0000\x0003\x007E\x0001\x0000\x0017\x007E\x0001\x0000\x000A\x007E\x0001\x0000" +
            "\x0005\x007E\x0002\x0000\x0001\x007F\x0001\x007E\x0007\x007F\x0001\x0000\x0003\x007F\x0001\x0000\x0004\x007F\x0007\x0000" +
            "\x0002\x007F\x0007\x0000\x0001\x007E\x0001\x0000\x0002\x007E\x0002\x007F\x0002\x0000\x000A\x0080\x0001\x0000\x0002\x007E" +
            "\x000F\x0000\x0002\x007F\x0001\x0000\x0008\x007E\x0001\x0000\x0003\x007E\x0001\x0000\x0029\x007E\x0002\x0000\x0001\x007E" +
            "\x0007\x007F\x0001\x0000\x0003\x007F\x0001\x0000\x0004\x007F\x0001\x007E\x0008\x0000\x0001\x007F\x0008\x0000\x0002\x007E" +
            "\x0002\x007F\x0002\x0000\x000A\x0080\x000A\x0000\x0006\x007E\x0002\x0000\x0002\x007F\x0001\x0000\x0012\x007E\x0003\x0000" +
            "\x0018\x007E\x0001\x0000\x0009\x007E\x0001\x0000\x0001\x007E\x0002\x0000\x0007\x007E\x0003\x0000\x0001\x007F\x0004\x0000" +
            "\x0006\x007F\x0001\x0000\x0001\x007F\x0001\x0000\x0008\x007F\x0012\x0000\x0002\x007F\x000D\x0000\x0030\x0086\x0001\x0087" +
            "\x0002\x0086\x0007\x0087\x0005\x0000\x0007\x0086\x0008\x0087\x0001\x0000\x000A\x0080\x0027\x0000\x0002\x0086\x0001\x0000" +
            "\x0001\x0086\x0002\x0000\x0002\x0086\x0001\x0000\x0001\x0086\x0002\x0000\x0001\x0086\x0006\x0000\x0004\x0086\x0001\x0000" +
            "\x0007\x0086\x0001\x0000\x0003\x0086\x0001\x0000\x0001\x0086\x0001\x0000\x0001\x0086\x0002\x0000\x0002\x0086\x0001\x0000" +
            "\x0004\x0086\x0001\x0087\x0002\x0086\x0006\x0087\x0001\x0000\x0002\x0087\x0001\x0086\x0002\x0000\x0005\x0086\x0001\x0000" +
            "\x0001\x0086\x0001\x0000\x0006\x0087\x0002\x0000\x000A\x0080\x0002\x0000\x0004\x0086\x0020\x0000\x0001\x007E\x0017\x0000" +
            "\x0002\x007F\x0006\x0000\x000A\x0080\x000B\x0000\x0001\x007F\x0001\x0000\x0001\x007F\x0001\x0000\x0001\x007F\x0004\x0000" +
            "\x0002\x007F\x0008\x007E\x0001\x0000\x0024\x007E\x0004\x0000\x0014\x007F\x0001\x0000\x0002\x007F\x0005\x007E\x000B\x007F" +
            "\x0001\x0000\x0024\x007F\x0009\x0000\x0001\x007F\x0039\x0000\x002B\x0086\x0014\x0087\x0001\x0086\x000A\x0080\x0006\x0000" +
            "\x0006\x0086\x0004\x0087\x0004\x0086\x0003\x0087\x0001\x0086\x0003\x0087\x0002\x0086\x0007\x0087\x0003\x0086\x0004\x0087" +
            "\x000D\x0086\x000C\x0087\x0001\x0086\x0001\x0087\x000A\x0080\x0004\x0087\x0002\x0086\x0026\x007E\x0001\x0000\x0001\x007E" +
            "\x0005\x0000\x0001\x007E\x0002\x0000\x002B\x007E\x0001\x0000\x0004\x007E\u0100\x008D\x0049\x007E\x0001\x0000\x0004\x007E" +
            "\x0002\x0000\x0007\x007E\x0001\x0000\x0001\x007E\x0001\x0000\x0004\x007E\x0002\x0000\x0029\x007E\x0001\x0000\x0004\x007E" +
            "\x0002\x0000\x0021\x007E\x0001\x0000\x0004\x007E\x0002\x0000\x0007\x007E\x0001\x0000\x0001\x007E\x0001\x0000\x0004\x007E" +
            "\x0002\x0000\x000F\x007E\x0001\x0000\x0039\x007E\x0001\x0000\x0004\x007E\x0002\x0000\x0043\x007E\x0002\x0000\x0003\x007F" +
            "\x0020\x0000\x0010\x007E\x0010\x0000\x0055\x007E\x000C\x0000\u026c\x007E\x0002\x0000\x0011\x007E\x0001\x0000\x001A\x007E" +
            "\x0005\x0000\x004B\x007E\x0003\x0000\x0003\x007E\x000F\x0000\x000D\x007E\x0001\x0000\x0004\x007E\x0003\x007F\x000B\x0000" +
            "\x0012\x007E\x0003\x007F\x000B\x0000\x0012\x007E\x0002\x007F\x000C\x0000\x000D\x007E\x0001\x0000\x0003\x007E\x0001\x0000" +
            "\x0002\x007F\x000C\x0000\x0034\x0086\x0020\x0087\x0003\x0000\x0001\x0086\x0004\x0000\x0001\x0086\x0001\x0087\x0002\x0000" +
            "\x000A\x0080\x0021\x0000\x0003\x007F\x0001\x007F\x0001\x0000\x000A\x0080\x0006\x0000\x0058\x007E\x0008\x0000\x0029\x007E" +
            "\x0001\x007F\x0001\x007E\x0005\x0000\x0046\x007E\x000A\x0000\x001D\x007E\x0003\x0000\x000C\x007F\x0004\x0000\x000C\x007F" +
            "\x000A\x0000\x000A\x0080\x001E\x0086\x0002\x0000\x0005\x0086\x000B\x0000\x002C\x0086\x0004\x0000\x0011\x0087\x0007\x0086" +
            "\x0002\x0087\x0006\x0000\x000A\x0080\x0001\x0086\x0003\x0000\x0002\x0086\x0020\x0000\x0017\x007E\x0005\x007F\x0004\x0000" +
            "\x0035\x0086\x000A\x0087\x0001\x0000\x001D\x0087\x0002\x0000\x0001\x007F\x000A\x0080\x0006\x0000\x000A\x0080\x0006\x0000" +
            "\x000E\x0086\x0052\x0000\x0005\x007F\x002F\x007E\x0011\x007F\x0007\x007E\x0004\x0000\x000A\x0080\x0011\x0000\x0009\x007F" +
            "\x000C\x0000\x0003\x007F\x001E\x007E\x000D\x007F\x0002\x007E\x000A\x0080\x002C\x007E\x000E\x007F\x000C\x0000\x0024\x007E" +
            "\x0014\x007F\x0008\x0000\x000A\x0080\x0003\x0000\x0003\x007E\x000A\x0080\x0024\x007E\x0052\x0000\x0003\x007F\x0001\x0000" +
            "\x0015\x007F\x0004\x007E\x0001\x007F\x0004\x007E\x0003\x007F\x0002\x007E\x0009\x0000\x00C0\x007E\x0027\x007F\x0015\x0000" +
            "\x0004\x007F\u0116\x007E\x0002\x0000\x0006\x007E\x0002\x0000\x0026\x007E\x0002\x0000\x0006\x007E\x0002\x0000\x0008\x007E" +
            "\x0001\x0000\x0001\x007E\x0001\x0000\x0001\x007E\x0001\x0000\x0001\x007E\x0001\x0000\x001F\x007E\x0002\x0000\x0035\x007E" +
            "\x0001\x0000\x0007\x007E\x0001\x0000\x0001\x007E\x0003\x0000\x0003\x007E\x0001\x0000\x0007\x007E\x0003\x0000\x0004\x007E" +
            "\x0002\x0000\x0006\x007E\x0004\x0000\x000D\x007E\x0005\x0000\x0003\x007E\x0001\x0000\x0007\x007E\x000F\x0000\x0002\x007F" +
            "\x0002\x007F\x0008\x0000\x0002\x0084\x000A\x0000\x0001\x0084\x0002\x0000\x0001\x0082\x0002\x0000\x0005\x007F\x0010\x0000" +
            "\x0002\x0085\x0003\x0000\x0001\x0083\x000F\x0000\x0001\x0085\x000B\x0000\x0005\x007F\x0001\x0000\x000A\x007F\x0001\x0000" +
            "\x0001\x007E\x000D\x0000\x0001\x007E\x0010\x0000\x000D\x007E\x0033\x0000\x0021\x007F\x0011\x0000\x0001\x007E\x0004\x0000" +
            "\x0001\x007E\x0002\x0000\x000A\x007E\x0001\x0000\x0001\x007E\x0003\x0000\x0005\x007E\x0006\x0000\x0001\x007E\x0001\x0000" +
            "\x0001\x007E\x0001\x0000\x0001\x007E\x0001\x0000\x0004\x007E\x0001\x0000\x000B\x007E\x0002\x0000\x0004\x007E\x0005\x0000" +
            "\x0005\x007E\x0004\x0000\x0001\x007E\x0011\x0000\x0029\x007E\u032d\x0000\x0034\x007E\u0716\x0000\x002F\x007E\x0001\x0000" +
            "\x002F\x007E\x0001\x0000\x0085\x007E\x0006\x0000\x0004\x007E\x0003\x007F\x0002\x007E\x000C\x0000\x0026\x007E\x0001\x0000" +
            "\x0001\x007E\x0005\x0000\x0001\x007E\x0002\x0000\x0038\x007E\x0007\x0000\x0001\x007E\x000F\x0000\x0001\x007F\x0017\x007E" +
            "\x0009\x0000\x0007\x007E\x0001\x0000\x0007\x007E\x0001\x0000\x0007\x007E\x0001\x0000\x0007\x007E\x0001\x0000\x0007\x007E" +
            "\x0001\x0000\x0007\x007E\x0001\x0000\x0007\x007E\x0001\x0000\x0007\x007E\x0001\x0000\x0020\x007F\x002F\x0000\x0001\x007E" +
            "\x0050\x0000\x001A\x0088\x0001\x0000\x0059\x0088\x000C\x0000\x00D6\x0088\x002F\x0000\x0001\x007E\x0001\x0000\x0001\x0088" +
            "\x0019\x0000\x0009\x0088\x0006\x007F\x0001\x0000\x0005\x0081\x0002\x0000\x0003\x0088\x0001\x007E\x0001\x007E\x0004\x0000" +
            "\x0056\x0089\x0002\x0000\x0002\x007F\x0002\x0081\x0003\x0089\x005B\x0081\x0001\x0000\x0004\x0081\x0005\x0000\x0029\x007E" +
            "\x0003\x0000\x005E\x008D\x0011\x0000\x001B\x007E\x0035\x0000\x0010\x0081\x00D0\x0000\x002F\x0081\x0001\x0000\x0058\x0081" +
            "\x00A8\x0000\u19b6\x0088\x004A\x0000\u51cd\x0088\x0033\x0000\u048d\x007E\x0043\x0000\x002E\x007E\x0002\x0000\u010d\x007E" +
            "\x0003\x0000\x0010\x007E\x000A\x0080\x0002\x007E\x0014\x0000\x002F\x007E\x0004\x007F\x0001\x0000\x000A\x007F\x0001\x0000" +
            "\x0019\x007E\x0007\x0000\x0001\x007F\x0050\x007E\x0002\x007F\x0025\x0000\x0009\x007E\x0002\x0000\x0067\x007E\x0002\x0000" +
            "\x0004\x007E\x0001\x0000\x0004\x007E\x000C\x0000\x000B\x007E\x004D\x0000\x000A\x007E\x0001\x007F\x0003\x007E\x0001\x007F" +
            "\x0004\x007E\x0001\x007F\x0017\x007E\x0005\x007F\x0018\x0000\x0034\x007E\x000C\x0000\x0002\x007F\x0032\x007E\x0011\x007F" +
            "\x000B\x0000\x000A\x0080\x0006\x0000\x0012\x007F\x0006\x007E\x0003\x0000\x0001\x007E\x0004\x0000\x000A\x0080\x001C\x007E" +
            "\x0008\x007F\x0002\x0000\x0017\x007E\x000D\x007F\x000C\x0000\x001D\x008D\x0003\x0000\x0004\x007F\x002F\x007E\x000E\x007F" +
            "\x000E\x0000\x0001\x007E\x000A\x0080\x0026\x0000\x0029\x007E\x000E\x007F\x0009\x0000\x0003\x007E\x0001\x007F\x0008\x007E" +
            "\x0002\x007F\x0002\x0000\x000A\x0080\x0006\x0000\x001B\x0086\x0001\x0087\x0004\x0000\x0030\x0086\x0001\x0087\x0001\x0086" +
            "\x0003\x0087\x0002\x0086\x0002\x0087\x0005\x0086\x0002\x0087\x0001\x0086\x0001\x0087\x0001\x0086\x0018\x0000\x0005\x0086" +
            "\x000B\x007E\x0005\x007F\x0002\x0000\x0003\x007E\x0002\x007F\x000A\x0000\x0006\x007E\x0002\x0000\x0006\x007E\x0002\x0000" +
            "\x0006\x007E\x0009\x0000\x0007\x007E\x0001\x0000\x0007\x007E\x0091\x0000\x0023\x007E\x0008\x007F\x0001\x0000\x0002\x007F" +
            "\x0002\x0000\x000A\x0080\x0006\x0000\u2ba4\x008D\x000C\x0000\x0017\x008D\x0004\x0000\x0031\x008D\x0004\x0000\x0001\x0024" +
            "\x0001\x0020\x0001\x0037\x0001\x0034\x0001\x001B\x0001\x0018\x0002\x0000\x0001\x0014\x0001\x0011\x0002\x0000\x0001\x000F" +
            "\x0001\x000D\x000C\x0000\x0001\x0003\x0001\x0006\x0010\x0000\x0001\x006E\x0007\x0000\x0001\x0049\x0001\x0008\x0005\x0000" +
            "\x0001\x0001\x0001\x007A\x0003\x0000\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073" +
            "\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073" +
            "\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073" +
            "\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073" +
            "\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0074\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0078\x0001\x0076" +
            "\x000F\x0000\x0001\x0070\u02c1\x0000\x0001\x004C\x00BF\x0000\x0001\x006F\x0001\x004D\x0001\x000E\x0003\x0077\x0002\x0032" +
            "\x0001\x0077\x0001\x0032\x0002\x0077\x0001\x001E\x0011\x0077\x0002\x0046\x0007\x004F\x0001\x004E\x0007\x004F\x0007\x0042" +
            "\x0001\x001F\x0001\x0042\x0001\x0060\x0002\x0036\x0001\x0035\x0001\x0060\x0001\x0036\x0001\x0035\x0008\x0060\x0002\x0047" +
            "\x0005\x0043\x0002\x003D\x0005\x0043\x0001\x0012\x0008\x002B\x0005\x0013\x0003\x0021\x000A\x0052\x0010\x0021\x0003\x0033" +
            "\x001A\x0023\x0001\x0022\x0002\x0031\x0002\x0056\x0001\x0057\x0002\x0056\x0002\x0057\x0002\x0056\x0001\x0057\x0003\x0031" +
            "\x0001\x0030\x0002\x0031\x000A\x0048\x0001\x005E\x0001\x0028\x0001\x0025\x0001\x0048\x0006\x0028\x0001\x0025\x000B\x0028" +
            "\x0019\x0031\x0007\x0028\x000A\x0053\x0001\x0028\x0005\x000B\x0003\x005F\x0003\x0041\x0001\x0040\x0004\x0041\x0002\x0040" +
            "\x0008\x0041\x0001\x0040\x0007\x001D\x0001\x001C\x0002\x001D\x0007\x0041\x000E\x005F\x0001\x0069\x0004\x0054\x0001\x0004" +
            "\x0004\x0051\x0001\x0004\x0005\x0068\x0001\x0067\x0001\x0068\x0003\x0067\x0007\x0068\x0001\x0067\x0013\x0068\x0005\x004B" +
            "\x0003\x0068\x0006\x004B\x0002\x004B\x0006\x004A\x0005\x004A\x0003\x0064\x0002\x0041\x0007\x0063\x001E\x0041\x0004\x0063" +
            "\x0005\x0041\x0005\x005F\x0006\x005D\x0002\x005F\x0001\x005D\x0004\x001D\x000B\x0066\x000A\x0051\x000C\x0066\x000A\x007D" +
            "\x000D\x007C\x0001\x0065\x0002\x007C\x0001\x007B\x0003\x006A\x0001\x000B\x0002\x006A\x0005\x0071\x0004\x006A\x0004\x0072" +
            "\x0001\x0071\x0003\x0072\x0001\x0071\x0005\x0072\x0002\x0038\x0001\x003B\x0002\x0038\x0001\x003B\x0001\x0038\x0002\x003B" +
            "\x0001\x0038\x0001\x003B\x000A\x0038\x0001\x003B\x0004\x0005\x0001\x006C\x0001\x006B\x0001\x006D\x0001\x000A\x0003\x0075" +
            "\x0001\x006D\x0002\x0075\x0001\x0061\x0002\x0062\x0002\x0075\x0001\x000A\x0001\x0075\x0001\x000A\x0001\x0075\x0001\x000A" +
            "\x0001\x0075\x0003\x000A\x0001\x0075\x0002\x000A\x0001\x0075\x0001\x000A\x0002\x0075\x0001\x000A\x0001\x0075\x0001\x000A" +
            "\x0001\x0075\x0001\x000A\x0001\x0075\x0001\x000A\x0001\x0075\x0001\x000A\x0001\x003E\x0002\x003A\x0001\x003E\x0001\x003A" +
            "\x0002\x003E\x0004\x003A\x0001\x003E\x0007\x003A\x0001\x003E\x0004\x003A\x0001\x003E\x0004\x003A\x0001\x0075\x0001\x000A" +
            "\x0001\x0075\x000A\x0019\x0001\x002F\x0011\x0019\x0001\x002F\x0003\x001A\x0001\x002F\x0003\x0019\x0001\x002F\x0001\x0019" +
            "\x0002\x0002\x0002\x0019\x0001\x002F\x000D\x005C\x0004\x0027\x0004\x002C\x0001\x0050\x0001\x002E\x0008\x0050\x0007\x002C" +
            "\x0006\x0075\x0004\x0015\x0001\x0017\x001F\x0015\x0001\x0017\x0004\x0015\x0015\x0045\x0001\x0079\x0009\x0045\x0011\x0016" +
            "\x0005\x0045\x0001\x0007\x000A\x002D\x0005\x0045\x0006\x0044\x0004\x003E\x0001\x003F\x0001\x0016\x0005\x005B\x000A\x0059" +
            "\x000F\x005B\x0001\x003C\x0003\x0039\x000C\x0058\x0001\x0009\x0009\x0026\x0001\x002A\x0005\x0026\x0004\x005A\x000B\x0029" +
            "\x0002\x000C\x0009\x0026\x0001\x002A\x0019\x0026\x0001\x002A\x0004\x0009\x0004\x0026\x0002\x002A\x0002\x0055\x0001\x0010" +
            "\x0005\x0055\x002A\x0010\u1900\x0000\u016e\x0088\x0002\x0000\x006A\x0088\x0026\x0000\x0007\x007E\x000C\x0000\x0005\x007E" +
            "\x0005\x0000\x0001\x008C\x0001\x007F\x000A\x008C\x0001\x0000\x000D\x008C\x0001\x0000\x0005\x008C\x0001\x0000\x0001\x008C" +
            "\x0001\x0000\x0002\x008C\x0001\x0000\x0002\x008C\x0001\x0000\x000A\x008C\x0062\x007E\x0021\x0000\u016b\x007E\x0012\x0000" +
            "\x0040\x007E\x0002\x0000\x0036\x007E\x0028\x0000\x000C\x007E\x0004\x0000\x0010\x007F\x0001\x0083\x0002\x0000\x0001\x0082" +
            "\x0001\x0083\x000B\x0000\x0007\x007F\x000C\x0000\x0002\x0085\x0018\x0000\x0003\x0085\x0001\x0083\x0001\x0000\x0001\x0084" +
            "\x0001\x0000\x0001\x0083\x0001\x0082\x001A\x0000\x0005\x007E\x0001\x0000\x0087\x007E\x0002\x0000\x0001\x007F\x0007\x0000" +
            "\x0001\x0084\x0004\x0000\x0001\x0083\x0001\x0000\x0001\x0084\x0001\x0000\x000A\x0080\x0001\x0082\x0001\x0083\x0005\x0000" +
            "\x001A\x007E\x0004\x0000\x0001\x0085\x0001\x0000\x001A\x007E\x000B\x0000\x0038\x0081\x0002\x007F\x001F\x008D\x0003\x0000" +
            "\x0006\x008D\x0002\x0000\x0006\x008D\x0002\x0000\x0006\x008D\x0002\x0000\x0003\x008D\x001C\x0000\x0003\x007F\x0004\x0000";

        /// <summary>
        /// Translates characters to character classes
        /// </summary>
        private static readonly char[] ZZ_CMAP = ZzUnpackCMap(ZZ_CMAP_PACKED);

        /// <summary>
        /// Translates DFA states to action switch labels.
        /// </summary>
        private static readonly int[] ZZ_ACTION = ZzUnpackAction();

        private const string ZZ_ACTION_PACKED_0 =
            "\x0001\x0000\x0016\x0001\x0001\x0002\x0001\x0003\x0001\x0004\x0001\x0001\x0001\x0005\x0001\x0006" +
            "\x0001\x0007\x0001\x0002\x0001\x0008\x0011\x0000\x0001\x0002\x0001\x0000\x0001\x0002\x000A\x0000" +
            "\x0001\x0003\x0011\x0000\x0001\x0002\x0015\x0000\x0001\x0002\x004D\x0000\x0001\x0001\x0010\x0000";

        private static int[] ZzUnpackAction()
        {
            int[] result = new int[197];
            int offset = 0;
            offset = ZzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
            return result;
        }

        private static int ZzUnpackAction(string packed, int offset, int[] result)
        {
            int i = 0; // index in packed string
            int j = offset; // index in unpacked array
            int l = packed.Length;
            while (i < l)
            {
                int count = packed[i++];
                int value = packed[i++];
                do
                {
                    result[j++] = value;
                } while (--count > 0);
            }
            return j;
        }


        /// <summary>
        /// Translates a state to a row index in the transition table
        /// </summary>
        private static readonly int[] ZZ_ROWMAP = ZzUnpackRowMap();

        private const string ZZ_ROWMAP_PACKED_0 =
            "\x0000\x0000\x0000\x008E\x0000\u011c\x0000\u01aa\x0000\u0238\x0000\u02c6\x0000\u0354\x0000\u03e2" +
            "\x0000\u0470\x0000\u04fe\x0000\u058c\x0000\u061a\x0000\u06a8\x0000\u0736\x0000\u07c4\x0000\u0852" +
            "\x0000\u08e0\x0000\u096e\x0000\u09fc\x0000\u0a8a\x0000\u0b18\x0000\u0ba6\x0000\u0c34\x0000\u0cc2" +
            "\x0000\u0d50\x0000\u0dde\x0000\u0e6c\x0000\u0efa\x0000\u0f88\x0000\u1016\x0000\u10a4\x0000\u1132" +
            "\x0000\u11c0\x0000\u011c\x0000\u01aa\x0000\u124e\x0000\u12dc\x0000\u0354\x0000\u03e2\x0000\u0470" +
            "\x0000\u04fe\x0000\u136a\x0000\u13f8\x0000\u1486\x0000\u1514\x0000\u07c4\x0000\u15a2\x0000\u1630" +
            "\x0000\u16be\x0000\u174c\x0000\u17da\x0000\u1868\x0000\u18f6\x0000\u02c6\x0000\u1984\x0000\u1a12" +
            "\x0000\u06a8\x0000\u1aa0\x0000\u1b2e\x0000\u1bbc\x0000\u1c4a\x0000\u1cd8\x0000\u1d66\x0000\u1df4" +
            "\x0000\u1e82\x0000\u1f10\x0000\u1f9e\x0000\u202c\x0000\u20ba\x0000\u2148\x0000\u21d6\x0000\u2264" +
            "\x0000\u22f2\x0000\u2380\x0000\u240e\x0000\u249c\x0000\u252a\x0000\u25b8\x0000\u2646\x0000\u0e6c" +
            "\x0000\u26d4\x0000\u2762\x0000\u27f0\x0000\u287e\x0000\u290c\x0000\u299a\x0000\u2a28\x0000\u2ab6" +
            "\x0000\u2b44\x0000\u2bd2\x0000\u2c60\x0000\u2cee\x0000\u2d7c\x0000\u2e0a\x0000\u2e98\x0000\u2f26" +
            "\x0000\u2fb4\x0000\u3042\x0000\u30d0\x0000\u315e\x0000\u31ec\x0000\u327a\x0000\u3308\x0000\u3396" +
            "\x0000\u3424\x0000\u34b2\x0000\u3540\x0000\u35ce\x0000\u365c\x0000\u36ea\x0000\u3778\x0000\u3806" +
            "\x0000\u3894\x0000\u3922\x0000\u39b0\x0000\u3a3e\x0000\u3acc\x0000\u3b5a\x0000\u3be8\x0000\u3c76" +
            "\x0000\u3d04\x0000\u3d92\x0000\u3e20\x0000\u3eae\x0000\u3f3c\x0000\u3fca\x0000\u4058\x0000\u40e6" +
            "\x0000\u4174\x0000\u4202\x0000\u4290\x0000\u431e\x0000\u43ac\x0000\u443a\x0000\u44c8\x0000\u4556" +
            "\x0000\u45e4\x0000\u4672\x0000\u4700\x0000\u478e\x0000\u481c\x0000\u48aa\x0000\u4938\x0000\u49c6" +
            "\x0000\u4a54\x0000\u4ae2\x0000\u4b70\x0000\u4bfe\x0000\u4c8c\x0000\u4d1a\x0000\u4da8\x0000\u4e36" +
            "\x0000\u4ec4\x0000\u4f52\x0000\u4fe0\x0000\u506e\x0000\u50fc\x0000\u518a\x0000\u5218\x0000\u52a6" +
            "\x0000\u5334\x0000\u53c2\x0000\u5450\x0000\u54de\x0000\u556c\x0000\u55fa\x0000\u5688\x0000\u5716" +
            "\x0000\u57a4\x0000\u5832\x0000\u58c0\x0000\u594e\x0000\u59dc\x0000\u5a6a\x0000\u5af8\x0000\u5b86" +
            "\x0000\u5c14\x0000\u5ca2\x0000\u5d30\x0000\u5dbe\x0000\u5e4c\x0000\u5eda\x0000\u5f68\x0000\u5ff6" +
            "\x0000\u6084\x0000\u6112\x0000\u61a0\x0000\u622e\x0000\u62bc\x0000\u634a\x0000\u63d8\x0000\u6466" +
            "\x0000\u64f4\x0000\u6582\x0000\u6610\x0000\u669e\x0000\u672c";

        private static int[] ZzUnpackRowMap()
        {
            int[] result = new int[197];
            int offset = 0;
            offset = ZzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
            return result;
        }

        private static int ZzUnpackRowMap(string packed, int offset, int[] result)
        {
            int i = 0; // index in packed string
            int j = offset; // index in unpacked array
            int l = packed.Length;
            while (i < l)
            {
                int high = packed[i++] << 16;
                result[j++] = high | packed[i++];
            }
            return j;
        }

        /// <summary>
        /// The transition table of the DFA
        /// </summary>
        private static readonly int[] ZZ_TRANS = ZzUnpackTrans();


        private const string ZZ_TRANS_PACKED_0 =
            "\x0001\x0002\x0001\x0003\x0001\x0002\x0001\x0004\x0002\x0002\x0001\x0005\x0001\x0002\x0001\x0006" +
            "\x0004\x0002\x0001\x0007\x0001\x0002\x0001\x0008\x0001\x0002\x0001\x0009\x0002\x0002\x0001\x000A" +
            "\x0003\x0002\x0001\x000B\x0002\x0002\x0001\x000C\x0004\x0002\x0001\x000D\x0003\x0002\x0001\x000E" +
            "\x000F\x0002\x0001\x000F\x0002\x0002\x0001\x0010\x0036\x0002\x0001\x0011\x0001\x0002\x0001\x0012" +
            "\x0002\x0002\x0001\x0013\x0001\x0014\x0001\x0002\x0001\x0015\x0001\x0002\x0001\x0016\x0001\x0002" +
            "\x0001\x0017\x0003\x0002\x0001\x0018\x0001\x0002\x0001\x0019\x0001\x001A\x0003\x0002\x0001\x001B" +
            "\x0002\x001C\x0001\x001D\x0001\x001E\x0002\x0002\x0001\x001F\x0001\x0020\x0090\x0000\x0001\x0018" +
            "\x0002\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x000E\x0000\x0001\x0018\x000D\x0000\x0001\x0018" +
            "\x0010\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0021\x0000\x0001\x0018\x0004\x0000\x0001\x0018" +
            "\x0008\x0000\x0002\x0018\x0005\x0000\x0002\x0018\x0008\x0000\x0001\x0018\x0016\x0000\x0002\x0018" +
            "\x0005\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0003\x0000\x0002\x0018\x0008\x0000\x0004\x0018" +
            "\x0001\x0000\x0003\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0002\x0000\x0001\x0018" +
            "\x0004\x0000\x0004\x0018\x0001\x0000\x0002\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x0002\x0000\x0004\x0018\x0002\x0000\x0003\x0018\x0001\x0000\x0002\x0018" +
            "\x0001\x0000\x0003\x0018\x0001\x0000\x0004\x0018\x0001\x0000\x0002\x0018\x0005\x0000\x0004\x0018" +
            "\x0002\x0000\x0008\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0002\x0018" +
            "\x0004\x0000\x0001\x0018\x0003\x0000\x0003\x0018\x0017\x0000\x0001\x0018\x0004\x0000\x0001\x0018" +
            "\x0009\x0000\x0001\x0018\x0012\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0017\x0000\x0001\x0018" +
            "\x0033\x0000\x0001\x0018\x0019\x0000\x0001\x0018\x0003\x0000\x0004\x0018\x0001\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0019\x0002\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0002\x0018" +
            "\x0002\x0000\x0003\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0004\x0018" +
            "\x0001\x0000\x0003\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0003\x0018\x0001\x0000\x0002\x0018" +
            "\x0001\x0000\x0004\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0008\x0018\x0001\x0000\x0002\x0018" +
            "\x0001\x0000\x0008\x0018\x0001\x0019\x0001\x0000\x0007\x0018\x0001\x0000\x0008\x0018\x0001\x0000" +
            "\x0006\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0003\x0000\x0003\x0018\x001E\x0000\x0001\x0018\x000F\x0000\x0001\x0018\x0013\x0000" +
            "\x0001\x0018\x0013\x0000\x0001\x0018\x0006\x0000\x0003\x0018\x001F\x0000\x0001\x0018\x0007\x0000" +
            "\x0001\x0018\x0018\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0001\x0000\x0001\x0018\x0001\x0000" +
            "\x0004\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0001\x0000" +
            "\x0003\x0018\x0001\x0000\x0002\x0018\x0001\x0000\x0004\x0018\x0001\x0000\x0003\x0018\x0001\x0000" +
            "\x000F\x0018\x0001\x0000\x0002\x0018\x0001\x0000\x0011\x0018\x0001\x0000\x0002\x0018\x0001\x0000" +
            "\x0021\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0003\x0018\x001E\x0000\x0001\x0018\x0003\x0000" +
            "\x0002\x0018\x000A\x0000\x0002\x0018\x000B\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0002\x0000" +
            "\x0002\x0018\x0006\x0000\x0001\x0018\x0004\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0005\x0000" +
            "\x0003\x0018\x0010\x0000\x0001\x0018\x000E\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0018\x0000" +
            "\x0001\x0018\x0001\x0000\x0002\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0002\x0018\x0002\x0000" +
            "\x0001\x0018\x0003\x0000\x0002\x0018\x0001\x0000\x0003\x0018\x0001\x0000\x0002\x0018\x0001\x0000" +
            "\x0004\x0018\x0001\x0000\x0003\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000" +
            "\x0009\x0018\x0001\x0000\x0002\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0001\x0000" +
            "\x000C\x0018\x0001\x0000\x0002\x0018\x0001\x0000\x0008\x0018\x0001\x0000\x0002\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0013\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0003\x0018\x0012\x0000" +
            "\x0001\x0018\x0016\x0000\x0002\x0018\x0013\x0000\x0001\x0019\x0001\x0018\x0020\x0000\x0001\x0019" +
            "\x0041\x0000\x0001\x0019\x0017\x0000\x0004\x0018\x0002\x0000\x0002\x0018\x000C\x0000\x0003\x0018" +
            "\x000D\x0000\x0003\x0018\x0003\x0000\x0001\x0018\x0007\x0000\x0002\x0018\x0001\x0000\x0004\x0019" +
            "\x0001\x0000\x0002\x0018\x000B\x0000\x0001\x0018\x0013\x0000\x0001\x0018\x0024\x0000\x0001\x0018" +
            "\x0003\x0000\x0002\x0018\x000A\x0000\x0002\x0018\x0001\x0000\x0003\x0018\x0007\x0000\x0001\x0018" +
            "\x0006\x0000\x0002\x0018\x0001\x0000\x0002\x0018\x0006\x0000\x0001\x0018\x0004\x0000\x0002\x0018" +
            "\x0002\x0000\x0002\x0018\x0005\x0000\x0003\x0018\x0002\x0000\x0001\x0018\x0003\x0000\x0002\x0019" +
            "\x0008\x0000\x0001\x0018\x000E\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0018\x0000\x0001\x0018" +
            "\x0004\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0006\x0000\x0001\x0018" +
            "\x0005\x0000\x0001\x0018\x0002\x0000\x0002\x0018\x0001\x0000\x000F\x0018\x0002\x0000\x0001\x0018" +
            "\x000B\x0000\x0007\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018" +
            "\x0002\x0000\x0001\x0018\x0001\x0000\x0003\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0006\x0000\x0002\x0018\x0006\x0000\x0001\x0018" +
            "\x0007\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0022\x0000\x0001\x0018\x000F\x0000\x0002\x0018" +
            "\x0012\x0000\x0001\x0018\x0002\x0000\x0002\x0018\x000B\x0000\x0001\x0018\x0003\x0000\x0002\x0018" +
            "\x0005\x0000\x0003\x0018\x0010\x0000\x0001\x0018\x000E\x0000\x0001\x0018\x0007\x0000\x0001\x0018" +
            "\x001D\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0001\x0018" +
            "\x0007\x0000\x0001\x0018\x0019\x0000\x0010\x0018\x0005\x0000\x0003\x0018\x0004\x0000\x0001\x0018" +
            "\x0006\x0000\x0001\x0018\x0003\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0004\x0000\x0001\x0018" +
            "\x0005\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x005F\x0000\x0001\x001E\x0021\x0000\x0001\x001A\x0022\x0000\x0001\x001D" +
            "\x0006\x0000\x0001\x001D\x0002\x0000\x0001\x001D\x0003\x0000\x0002\x001D\x0008\x0000\x0004\x001D" +
            "\x0001\x0000\x0003\x001D\x0001\x0000\x0001\x001D\x0002\x0000\x0001\x001D\x0002\x0000\x0001\x001D" +
            "\x0004\x0000\x0004\x001D\x0001\x0000\x0002\x001D\x0006\x0000\x0001\x001D\x0002\x0000\x0004\x001D" +
            "\x0002\x0000\x0003\x001D\x0001\x0000\x0002\x001D\x0001\x0000\x0003\x001D\x0001\x0000\x0004\x001D" +
            "\x0001\x0000\x0002\x001D\x0005\x0000\x0004\x001D\x0002\x0000\x0008\x001D\x0004\x0000\x0001\x001D" +
            "\x0001\x0000\x0002\x001D\x0004\x0000\x0001\x001D\x0003\x0000\x0003\x001D\x0012\x0000\x0001\x001D" +
            "\x0001\x0000\x0002\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0004\x001D\x0001\x0000\x0001\x001D" +
            "\x0001\x0000\x0001\x001D\x0001\x0000\x0002\x001D\x0001\x0000\x0003\x001D\x0001\x0000\x0002\x001D" +
            "\x0001\x0000\x0004\x001D\x0001\x0000\x0003\x001D\x0001\x0000\x000F\x001D\x0001\x0000\x0002\x001D" +
            "\x0001\x0000\x0011\x001D\x0001\x0000\x0002\x001D\x0001\x0000\x0021\x001D\x0001\x0000\x0001\x001D" +
            "\x0001\x0000\x0002\x001D\x0002\x0000\x0001\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0001\x001D" +
            "\x0001\x0000\x0003\x001D\x0012\x0000\x0001\x001D\x0001\x0000\x0002\x001D\x0001\x0000\x0001\x001D" +
            "\x0001\x0000\x0004\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0002\x001D" +
            "\x0002\x0000\x0001\x001D\x0002\x0000\x0002\x001D\x0001\x0000\x0004\x001D\x0001\x0000\x0003\x001D" +
            "\x0001\x0000\x000F\x001D\x0001\x0000\x0002\x001D\x0001\x0000\x0011\x001D\x0001\x0000\x0002\x001D" +
            "\x0001\x0000\x0021\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0002\x001D\x0002\x0000\x0001\x001D" +
            "\x0001\x0000\x0001\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0003\x001D\x001E\x0000\x0001\x001D" +
            "\x000F\x0000\x0001\x001D\x0013\x0000\x0001\x001D\x001A\x0000\x0001\x001D\x0021\x0000\x0001\x001D" +
            "\x0007\x0000\x0001\x001D\x0018\x0000\x0001\x001D\x0001\x0000\x0002\x001D\x0003\x0000\x0004\x001D" +
            "\x0001\x0000\x0001\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0002\x001D\x0001\x0000\x0003\x001D" +
            "\x0001\x0000\x0002\x001D\x0001\x0000\x0004\x001D\x0001\x0000\x0003\x001D\x0001\x0000\x0008\x001D" +
            "\x0001\x0000\x0006\x001D\x0001\x0000\x0002\x001D\x0001\x0000\x0011\x001D\x0001\x0000\x0002\x001D" +
            "\x0001\x0000\x0021\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0002\x001D\x0002\x0000\x0001\x001D" +
            "\x0001\x0000\x0001\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0003\x001D\x0075\x0000\x0001\x0021" +
            "\x0015\x0000\x0001\x001E\x0002\x0021\x0011\x0000\x0001\x0022\x0001\x0000\x0001\x0023\x0002\x0000" +
            "\x0001\x0024\x0001\x0000\x0001\x0025\x0004\x0000\x0001\x0026\x0001\x0000\x0001\x0027\x0001\x0000" +
            "\x0001\x0028\x0002\x0000\x0001\x0029\x0003\x0000\x0001\x002A\x0002\x0000\x0001\x002B\x0004\x0000" +
            "\x0001\x002C\x0003\x0000\x0001\x002D\x000F\x0000\x0001\x002E\x0002\x0000\x0001\x002F\x0011\x0000" +
            "\x0001\x0030\x0002\x0000\x0001\x0031\x0031\x0000\x0002\x0018\x0001\x0032\x0001\x0000\x0001\x0033" +
            "\x0001\x0000\x0001\x0033\x0001\x0034\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0033\x0001\x0000" +
            "\x0001\x001F\x0001\x0018\x0001\x0000\x0001\x0022\x0001\x0000\x0001\x0023\x0002\x0000\x0001\x0035" +
            "\x0001\x0000\x0001\x0036\x0004\x0000\x0001\x0026\x0001\x0000\x0001\x0027\x0001\x0000\x0001\x0028" +
            "\x0002\x0000\x0001\x0029\x0003\x0000\x0001\x0037\x0002\x0000\x0001\x0038\x0004\x0000\x0001\x0039" +
            "\x0003\x0000\x0001\x003A\x000F\x0000\x0001\x002E\x0002\x0000\x0001\x003B\x0011\x0000\x0001\x003C" +
            "\x0002\x0000\x0001\x003D\x0031\x0000\x0001\x0018\x0002\x0019\x0002\x0000\x0002\x003E\x0001\x003F" +
            "\x0001\x0000\x0001\x0019\x0002\x0000\x0001\x003E\x0001\x0000\x0001\x001F\x0001\x0018\x0006\x0000" +
            "\x0001\x0040\x0011\x0000\x0001\x0041\x0002\x0000\x0001\x0042\x0008\x0000\x0001\x0043\x0012\x0000" +
            "\x0001\x0044\x0011\x0000\x0001\x0045\x0002\x0000\x0001\x0046\x0021\x0000\x0001\x0047\x0010\x0000" +
            "\x0001\x001A\x0001\x0000\x0001\x001A\x0003\x0000\x0001\x0034\x0001\x0000\x0001\x001A\x0007\x0000" +
            "\x0001\x0022\x0001\x0000\x0001\x0023\x0002\x0000\x0001\x0048\x0001\x0000\x0001\x0036\x0004\x0000" +
            "\x0001\x0026\x0001\x0000\x0001\x0027\x0001\x0000\x0001\x0028\x0002\x0000\x0001\x0029\x0003\x0000" +
            "\x0001\x0049\x0002\x0000\x0001\x004A\x0004\x0000\x0001\x0039\x0003\x0000\x0001\x004B\x000F\x0000" +
            "\x0001\x002E\x0002\x0000\x0001\x004C\x0011\x0000\x0001\x004D\x0002\x0000\x0001\x004E\x0021\x0000" +
            "\x0001\x004F\x000F\x0000\x0001\x0018\x0001\x0050\x0001\x0019\x0001\x0051\x0003\x0000\x0001\x0050" +
            "\x0001\x0000\x0001\x0050\x0004\x0000\x0001\x001F\x0001\x0018\x0086\x0000\x0002\x001C\x000C\x0000" +
            "\x0001\x0052\x0011\x0000\x0001\x0053\x0002\x0000\x0001\x0054\x0008\x0000\x0001\x0055\x0012\x0000" +
            "\x0001\x0056\x0011\x0000\x0001\x0057\x0002\x0000\x0001\x0058\x0032\x0000\x0001\x001D\x0007\x0000" +
            "\x0001\x001D\x000C\x0000\x0001\x0059\x0011\x0000\x0001\x005A\x0002\x0000\x0001\x005B\x0008\x0000" +
            "\x0001\x005C\x0012\x0000\x0001\x005D\x0011\x0000\x0001\x005E\x0002\x0000\x0001\x005F\x0032\x0000" +
            "\x0001\x001E\x0007\x0000\x0001\x001E\x0007\x0000\x0001\x0022\x0001\x0000\x0001\x0023\x0002\x0000" +
            "\x0001\x0060\x0001\x0000\x0001\x0025\x0004\x0000\x0001\x0026\x0001\x0000\x0001\x0027\x0001\x0000" +
            "\x0001\x0028\x0002\x0000\x0001\x0029\x0003\x0000\x0001\x0061\x0002\x0000\x0001\x0062\x0004\x0000" +
            "\x0001\x002C\x0003\x0000\x0001\x0063\x000F\x0000\x0001\x002E\x0002\x0000\x0001\x0064\x0011\x0000" +
            "\x0001\x0065\x0002\x0000\x0001\x0066\x0031\x0000\x0001\x0018\x0001\x001F\x0001\x0032\x0001\x0000" +
            "\x0001\x0033\x0001\x0000\x0001\x0033\x0001\x0034\x0001\x0000\x0001\x001F\x0002\x0000\x0001\x0067" +
            "\x0001\x0068\x0001\x001F\x0001\x0018\x0001\x0000\x0001\x0022\x0001\x0000\x0001\x0023\x0002\x0000" +
            "\x0001\x0069\x0001\x0000\x0001\x0025\x0004\x0000\x0001\x0026\x0001\x0000\x0001\x0027\x0001\x0000" +
            "\x0001\x0028\x0002\x0000\x0001\x0029\x0003\x0000\x0001\x006A\x0002\x0000\x0001\x006B\x0004\x0000" +
            "\x0001\x002C\x0003\x0000\x0001\x006C\x000F\x0000\x0001\x002E\x0002\x0000\x0001\x006D\x0011\x0000" +
            "\x0001\x006E\x0002\x0000\x0001\x006F\x0031\x0000\x0001\x0018\x0001\x0020\x0001\x0032\x0001\x0000" +
            "\x0001\x0033\x0001\x0000\x0001\x0033\x0001\x0034\x0001\x0000\x0001\x0020\x0002\x0000\x0001\x0033" +
            "\x0001\x0000\x0001\x001F\x0001\x0020\x0006\x0000\x0001\x0070\x0011\x0000\x0001\x0071\x0002\x0000" +
            "\x0001\x0072\x0008\x0000\x0001\x0073\x0012\x0000\x0001\x0074\x0011\x0000\x0001\x0075\x0002\x0000" +
            "\x0001\x0076\x002D\x0000\x0001\x0077\x0004\x0000\x0001\x0021\x0007\x0000\x0001\x0021\x000D\x0000" +
            "\x0001\x0018\x0004\x0000\x0001\x0018\x0009\x0000\x0001\x0018\x0012\x0000\x0001\x0018\x0003\x0000" +
            "\x0001\x0018\x000B\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0008\x0000\x0001\x0018\x0012\x0000" +
            "\x0004\x0018\x001D\x0000\x0001\x0018\x0019\x0000\x0001\x0018\x0003\x0000\x0004\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0032\x0002\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000" +
            "\x0002\x0018\x0002\x0000\x0003\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0002\x0000" +
            "\x0004\x0018\x0001\x0000\x0003\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0003\x0018\x0001\x0000" +
            "\x0002\x0018\x0001\x0000\x0004\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0008\x0018\x0001\x0000" +
            "\x0002\x0018\x0001\x0000\x0008\x0018\x0001\x0032\x0001\x0000\x0007\x0018\x0001\x0000\x0008\x0018" +
            "\x0001\x0000\x0006\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x0003\x0000\x0003\x0018\x0012\x0000\x0001\x0018\x0016\x0000\x0002\x0018" +
            "\x0013\x0000\x0001\x0032\x0001\x0018\x0020\x0000\x0001\x0032\x000B\x0000\x0001\x0018\x0035\x0000" +
            "\x0001\x0032\x0009\x0000\x0001\x0018\x000D\x0000\x0004\x0018\x0002\x0000\x0002\x0018\x000C\x0000" +
            "\x0004\x0018\x0001\x0000\x0002\x0018\x0009\x0000\x0003\x0018\x0003\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0004\x0000\x0003\x0018\x0001\x0000\x0004\x0032\x0001\x0000\x0002\x0018\x0005\x0000" +
            "\x0004\x0018\x0002\x0000\x0002\x0018\x000A\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0024\x0000" +
            "\x0001\x0018\x0003\x0000\x0002\x0018\x000A\x0000\x0002\x0018\x0001\x0000\x0003\x0018\x0007\x0000" +
            "\x0001\x0018\x0006\x0000\x0002\x0018\x0001\x0000\x0002\x0018\x0006\x0000\x0001\x0018\x0004\x0000" +
            "\x0002\x0018\x0002\x0000\x0002\x0018\x0005\x0000\x0003\x0018\x0002\x0000\x0001\x0018\x0003\x0000" +
            "\x0002\x0032\x0008\x0000\x0001\x0018\x000E\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0018\x0000" +
            "\x0001\x0018\x0004\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0006\x0000" +
            "\x0001\x0018\x0005\x0000\x0001\x0018\x0002\x0000\x0002\x0018\x0001\x0000\x000F\x0018\x0002\x0000" +
            "\x0001\x0018\x000B\x0000\x0007\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000" +
            "\x0002\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0003\x0018\x0002\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000" +
            "\x0002\x0018\x0006\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x001B\x0000" +
            "\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0007\x0000" +
            "\x0001\x0018\x0019\x0000\x0010\x0018\x0005\x0000\x0003\x0018\x0004\x0000\x0001\x0018\x0006\x0000" +
            "\x0001\x0018\x0003\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0004\x0000\x0005\x0018\x0001\x0000" +
            "\x0001\x0018\x0002\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x005C\x0000\x0002\x0018\x0015\x0000\x0004\x0018\x002D\x0000\x0001\x0018\x000D\x0000" +
            "\x0002\x0018\x0008\x0000\x0002\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0009\x0000" +
            "\x0001\x0018\x0009\x0000\x0002\x0018\x0006\x0000\x0001\x0018\x0002\x0000\x0004\x0018\x0003\x0000" +
            "\x0001\x0018\x0002\x0000\x0002\x0018\x0001\x0000\x0003\x0018\x0001\x0000\x0002\x0018\x0001\x0000" +
            "\x0001\x0018\x0008\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0001\x0000" +
            "\x0004\x0018\x0013\x0000\x0001\x0018\x0011\x0000\x0001\x0022\x0001\x0000\x0001\x0023\x0002\x0000" +
            "\x0001\x0078\x0001\x0000\x0001\x0025\x0004\x0000\x0001\x0026\x0001\x0000\x0001\x0027\x0001\x0000" +
            "\x0001\x0028\x0002\x0000\x0001\x0029\x0003\x0000\x0001\x0079\x0002\x0000\x0001\x007A\x0004\x0000" +
            "\x0001\x002C\x0003\x0000\x0001\x007B\x000F\x0000\x0001\x002E\x0002\x0000\x0001\x007C\x0011\x0000" +
            "\x0001\x007D\x0002\x0000\x0001\x007E\x0031\x0000\x0001\x0018\x0002\x0032\x0002\x0000\x0002\x007F" +
            "\x0001\x0034\x0001\x0000\x0001\x0032\x0002\x0000\x0001\x007F\x0001\x0000\x0001\x001F\x0001\x0018" +
            "\x0001\x0000\x0001\x0022\x0001\x0000\x0001\x0023\x0002\x0000\x0001\x0080\x0001\x0000\x0001\x0081" +
            "\x0004\x0000\x0001\x0026\x0001\x0000\x0001\x0027\x0001\x0000\x0001\x0028\x0002\x0000\x0001\x0029" +
            "\x0003\x0000\x0001\x0082\x0002\x0000\x0001\x0083\x0004\x0000\x0001\x0084\x0003\x0000\x0001\x0085" +
            "\x000F\x0000\x0001\x002E\x0002\x0000\x0001\x0086\x0011\x0000\x0001\x0087\x0002\x0000\x0001\x0088" +
            "\x0031\x0000\x0001\x0018\x0001\x0033\x0007\x0000\x0001\x0033\x0004\x0000\x0002\x0018\x0001\x0000" +
            "\x0001\x0022\x0001\x0000\x0001\x0023\x0002\x0000\x0001\x0089\x0001\x0000\x0001\x0025\x0004\x0000" +
            "\x0001\x0026\x0001\x0000\x0001\x0027\x0001\x0000\x0001\x0028\x0002\x0000\x0001\x0029\x0003\x0000" +
            "\x0001\x008A\x0002\x0000\x0001\x008B\x0004\x0000\x0001\x002C\x0003\x0000\x0001\x008C\x000F\x0000" +
            "\x0001\x002E\x0002\x0000\x0001\x008D\x0011\x0000\x0001\x008E\x0002\x0000\x0001\x008F\x0021\x0000" +
            "\x0001\x004F\x000F\x0000\x0001\x0018\x0001\x0034\x0001\x0032\x0001\x0051\x0003\x0000\x0001\x0034" +
            "\x0001\x0000\x0001\x0034\x0004\x0000\x0001\x001F\x0001\x0018\x0007\x0000\x0001\x0018\x0004\x0000" +
            "\x0001\x0018\x0009\x0000\x0001\x0018\x0012\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x000B\x0000" +
            "\x0001\x0019\x0002\x0000\x0001\x0019\x0008\x0000\x0001\x0018\x0012\x0000\x0004\x0019\x001D\x0000" +
            "\x0001\x0018\x0016\x0000\x0001\x0018\x0016\x0000\x0002\x0018\x0013\x0000\x0001\x0019\x0001\x0018" +
            "\x0020\x0000\x0001\x0019\x000B\x0000\x0001\x0019\x0035\x0000\x0001\x0019\x0009\x0000\x0001\x0019" +
            "\x000D\x0000\x0004\x0018\x0002\x0000\x0002\x0018\x000C\x0000\x0003\x0018\x0001\x0019\x0001\x0000" +
            "\x0002\x0019\x0009\x0000\x0003\x0018\x0003\x0000\x0001\x0018\x0001\x0000\x0001\x0019\x0004\x0000" +
            "\x0001\x0019\x0002\x0018\x0001\x0000\x0004\x0019\x0001\x0000\x0002\x0018\x0005\x0000\x0004\x0019" +
            "\x0002\x0000\x0001\x0018\x0001\x0019\x000A\x0000\x0001\x0019\x0007\x0000\x0001\x0018\x0018\x0000" +
            "\x0001\x0018\x0004\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0006\x0000" +
            "\x0001\x0018\x0005\x0000\x0001\x0018\x0002\x0000\x0002\x0018\x0001\x0000\x000F\x0018\x0002\x0000" +
            "\x0001\x0018\x000B\x0000\x0007\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000" +
            "\x0002\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0003\x0018\x0002\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0004\x0000\x0001\x0019\x0001\x0000" +
            "\x0002\x0018\x0006\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x001B\x0000" +
            "\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0007\x0000" +
            "\x0001\x0018\x0019\x0000\x0010\x0018\x0005\x0000\x0003\x0018\x0004\x0000\x0001\x0018\x0006\x0000" +
            "\x0001\x0018\x0003\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0004\x0000\x0001\x0018\x0004\x0019" +
            "\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x005C\x0000\x0002\x0019\x0015\x0000\x0004\x0019\x002D\x0000\x0001\x0019" +
            "\x000D\x0000\x0002\x0019\x0008\x0000\x0002\x0019\x0001\x0000\x0001\x0019\x0001\x0000\x0001\x0019" +
            "\x0009\x0000\x0001\x0019\x0009\x0000\x0002\x0019\x0006\x0000\x0001\x0019\x0002\x0000\x0004\x0019" +
            "\x0003\x0000\x0001\x0019\x0002\x0000\x0002\x0019\x0001\x0000\x0003\x0019\x0001\x0000\x0002\x0019" +
            "\x0001\x0000\x0001\x0019\x0008\x0000\x0001\x0019\x0001\x0000\x0002\x0019\x0002\x0000\x0002\x0019" +
            "\x0001\x0000\x0004\x0019\x0013\x0000\x0001\x0019\x0016\x0000\x0001\x0090\x0001\x0000\x0001\x0091" +
            "\x000F\x0000\x0001\x0092\x0002\x0000\x0001\x0093\x0004\x0000\x0001\x0094\x0003\x0000\x0001\x0095" +
            "\x0012\x0000\x0001\x0096\x0011\x0000\x0001\x0097\x0002\x0000\x0001\x0098\x0032\x0000\x0001\x003E" +
            "\x0001\x0019\x0006\x0000\x0001\x003E\x0007\x0000\x0001\x0022\x0001\x0000\x0001\x0023\x0002\x0000" +
            "\x0001\x0099\x0001\x0000\x0001\x0036\x0004\x0000\x0001\x0026\x0001\x0000\x0001\x0027\x0001\x0000" +
            "\x0001\x0028\x0002\x0000\x0001\x0029\x0003\x0000\x0001\x009A\x0002\x0000\x0001\x009B\x0004\x0000" +
            "\x0001\x0039\x0003\x0000\x0001\x009C\x000F\x0000\x0001\x002E\x0002\x0000\x0001\x009D\x0011\x0000" +
            "\x0001\x009E\x0002\x0000\x0001\x009F\x0021\x0000\x0001\x004F\x000F\x0000\x0001\x0018\x0001\x003F" +
            "\x0001\x0019\x0001\x0051\x0003\x0000\x0001\x003F\x0001\x0000\x0001\x003F\x0004\x0000\x0001\x001F" +
            "\x0001\x0018\x0039\x0000\x0001\x001A\x0002\x0000\x0001\x001A\x001B\x0000\x0004\x001A\x008E\x0000" +
            "\x0001\x001A\x003F\x0000\x0001\x001A\x0024\x0000\x0001\x001A\x0001\x0000\x0002\x001A\x0011\x0000" +
            "\x0001\x001A\x0004\x0000\x0001\x001A\x000F\x0000\x0004\x001A\x0003\x0000\x0001\x001A\x000A\x0000" +
            "\x0001\x001A\x0083\x0000\x0001\x001A\x0092\x0000\x0004\x001A\x006A\x0000\x0002\x001A\x0015\x0000" +
            "\x0004\x001A\x002D\x0000\x0001\x001A\x000D\x0000\x0002\x001A\x0008\x0000\x0002\x001A\x0001\x0000" +
            "\x0001\x001A\x0001\x0000\x0001\x001A\x0009\x0000\x0001\x001A\x0009\x0000\x0002\x001A\x0006\x0000" +
            "\x0001\x001A\x0002\x0000\x0004\x001A\x0003\x0000\x0001\x001A\x0002\x0000\x0002\x001A\x0001\x0000" +
            "\x0003\x001A\x0001\x0000\x0002\x001A\x0001\x0000\x0001\x001A\x0008\x0000\x0001\x001A\x0001\x0000" +
            "\x0002\x001A\x0002\x0000\x0002\x001A\x0001\x0000\x0004\x001A\x0013\x0000\x0001\x001A\x007F\x0000" +
            "\x0001\x001A\x0025\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0009\x0000\x0001\x0018\x0012\x0000" +
            "\x0001\x0018\x0003\x0000\x0001\x0018\x000B\x0000\x0001\x0050\x0002\x0000\x0001\x0050\x0008\x0000" +
            "\x0001\x0018\x0012\x0000\x0004\x0050\x001D\x0000\x0001\x0018\x0016\x0000\x0001\x0018\x0016\x0000" +
            "\x0002\x0018\x0013\x0000\x0001\x0019\x0001\x0018\x0020\x0000\x0001\x0019\x000B\x0000\x0001\x0050" +
            "\x0035\x0000\x0001\x0019\x0009\x0000\x0001\x0050\x000D\x0000\x0004\x0018\x0002\x0000\x0002\x0018" +
            "\x000C\x0000\x0003\x0018\x0001\x0050\x0001\x0000\x0002\x0050\x0009\x0000\x0003\x0018\x0003\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0050\x0004\x0000\x0001\x0050\x0002\x0018\x0001\x0000\x0004\x0019" +
            "\x0001\x0000\x0002\x0018\x0005\x0000\x0004\x0050\x0002\x0000\x0001\x0018\x0001\x0050\x000A\x0000" +
            "\x0001\x0050\x0007\x0000\x0001\x0018\x0018\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0006\x0000" +
            "\x0001\x0018\x0003\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0005\x0000\x0001\x0018\x0002\x0000" +
            "\x0002\x0018\x0001\x0000\x000F\x0018\x0002\x0000\x0001\x0018\x000B\x0000\x0007\x0018\x0002\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0001\x0018\x0001\x0000" +
            "\x0003\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0004\x0000\x0001\x0050\x0001\x0000\x0002\x0018\x0006\x0000\x0001\x0018\x0007\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x001B\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000" +
            "\x0001\x0018\x0003\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0019\x0000\x0010\x0018\x0005\x0000" +
            "\x0003\x0018\x0004\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0002\x0018\x0002\x0000" +
            "\x0002\x0018\x0004\x0000\x0001\x0018\x0004\x0050\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018" +
            "\x0004\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x005C\x0000\x0002\x0050" +
            "\x0015\x0000\x0004\x0050\x002D\x0000\x0001\x0050\x000D\x0000\x0002\x0050\x0008\x0000\x0002\x0050" +
            "\x0001\x0000\x0001\x0050\x0001\x0000\x0001\x0050\x0009\x0000\x0001\x0050\x0009\x0000\x0002\x0050" +
            "\x0006\x0000\x0001\x0050\x0002\x0000\x0004\x0050\x0003\x0000\x0001\x0050\x0002\x0000\x0002\x0050" +
            "\x0001\x0000\x0003\x0050\x0001\x0000\x0002\x0050\x0001\x0000\x0001\x0050\x0008\x0000\x0001\x0050" +
            "\x0001\x0000\x0002\x0050\x0002\x0000\x0002\x0050\x0001\x0000\x0004\x0050\x0013\x0000\x0001\x0050" +
            "\x007F\x0000\x0001\x0051\x0024\x0000\x0001\x00A0\x0011\x0000\x0001\x00A1\x0002\x0000\x0001\x00A2" +
            "\x0008\x0000\x0001\x00A3\x0012\x0000\x0001\x00A4\x0011\x0000\x0001\x00A5\x0002\x0000\x0001\x00A6" +
            "\x0021\x0000\x0001\x004F\x0010\x0000\x0001\x0051\x0001\x0000\x0001\x0051\x0003\x0000\x0001\x0034" +
            "\x0001\x0000\x0001\x0051\x003F\x0000\x0001\x001D\x0002\x0000\x0001\x001D\x001B\x0000\x0004\x001D" +
            "\x008E\x0000\x0001\x001D\x003F\x0000\x0001\x001D\x0024\x0000\x0001\x001D\x0001\x0000\x0002\x001D" +
            "\x0011\x0000\x0001\x001D\x0004\x0000\x0001\x001D\x000F\x0000\x0004\x001D\x0003\x0000\x0001\x001D" +
            "\x000A\x0000\x0001\x001D\x0083\x0000\x0001\x001D\x0092\x0000\x0004\x001D\x006A\x0000\x0002\x001D" +
            "\x0015\x0000\x0004\x001D\x002D\x0000\x0001\x001D\x000D\x0000\x0002\x001D\x0008\x0000\x0002\x001D" +
            "\x0001\x0000\x0001\x001D\x0001\x0000\x0001\x001D\x0009\x0000\x0001\x001D\x0009\x0000\x0002\x001D" +
            "\x0006\x0000\x0001\x001D\x0002\x0000\x0004\x001D\x0003\x0000\x0001\x001D\x0002\x0000\x0002\x001D" +
            "\x0001\x0000\x0003\x001D\x0001\x0000\x0002\x001D\x0001\x0000\x0001\x001D\x0008\x0000\x0001\x001D" +
            "\x0001\x0000\x0002\x001D\x0002\x0000\x0002\x001D\x0001\x0000\x0004\x001D\x0013\x0000\x0001\x001D" +
            "\x0049\x0000\x0001\x001E\x0002\x0000\x0001\x001E\x001B\x0000\x0004\x001E\x008E\x0000\x0001\x001E" +
            "\x003F\x0000\x0001\x001E\x0024\x0000\x0001\x001E\x0001\x0000\x0002\x001E\x0011\x0000\x0001\x001E" +
            "\x0004\x0000\x0001\x001E\x000F\x0000\x0004\x001E\x0003\x0000\x0001\x001E\x000A\x0000\x0001\x001E" +
            "\x0083\x0000\x0001\x001E\x0092\x0000\x0004\x001E\x006A\x0000\x0002\x001E\x0015\x0000\x0004\x001E" +
            "\x002D\x0000\x0001\x001E\x000D\x0000\x0002\x001E\x0008\x0000\x0002\x001E\x0001\x0000\x0001\x001E" +
            "\x0001\x0000\x0001\x001E\x0009\x0000\x0001\x001E\x0009\x0000\x0002\x001E\x0006\x0000\x0001\x001E" +
            "\x0002\x0000\x0004\x001E\x0003\x0000\x0001\x001E\x0002\x0000\x0002\x001E\x0001\x0000\x0003\x001E" +
            "\x0001\x0000\x0002\x001E\x0001\x0000\x0001\x001E\x0008\x0000\x0001\x001E\x0001\x0000\x0002\x001E" +
            "\x0002\x0000\x0002\x001E\x0001\x0000\x0004\x001E\x0013\x0000\x0001\x001E\x0017\x0000\x0001\x0018" +
            "\x0004\x0000\x0001\x0018\x0009\x0000\x0001\x0018\x0012\x0000\x0001\x0018\x0003\x0000\x0001\x0018" +
            "\x000B\x0000\x0001\x001F\x0002\x0000\x0001\x001F\x0008\x0000\x0001\x0018\x0012\x0000\x0004\x001F" +
            "\x001D\x0000\x0001\x0018\x0016\x0000\x0001\x0018\x0016\x0000\x0002\x0018\x0013\x0000\x0001\x0032" +
            "\x0001\x0018\x0020\x0000\x0001\x0032\x000B\x0000\x0001\x001F\x0035\x0000\x0001\x0032\x0009\x0000" +
            "\x0001\x001F\x000D\x0000\x0004\x0018\x0002\x0000\x0002\x0018\x000C\x0000\x0003\x0018\x0001\x001F" +
            "\x0001\x0000\x0002\x001F\x0009\x0000\x0003\x0018\x0003\x0000\x0001\x0018\x0001\x0000\x0001\x001F" +
            "\x0004\x0000\x0001\x001F\x0002\x0018\x0001\x0000\x0004\x0032\x0001\x0000\x0002\x0018\x0005\x0000" +
            "\x0004\x001F\x0002\x0000\x0001\x0018\x0001\x001F\x000A\x0000\x0001\x001F\x0007\x0000\x0001\x0018" +
            "\x0018\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018" +
            "\x0006\x0000\x0001\x0018\x0005\x0000\x0001\x0018\x0002\x0000\x0002\x0018\x0001\x0000\x000F\x0018" +
            "\x0002\x0000\x0001\x0018\x000B\x0000\x0007\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0001\x0000\x0002\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0003\x0018\x0002\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0004\x0000\x0001\x001F" +
            "\x0001\x0000\x0002\x0018\x0006\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x001B\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0001\x0018" +
            "\x0007\x0000\x0001\x0018\x0019\x0000\x0010\x0018\x0005\x0000\x0003\x0018\x0004\x0000\x0001\x0018" +
            "\x0006\x0000\x0001\x0018\x0003\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0004\x0000\x0001\x0018" +
            "\x0004\x001F\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x005C\x0000\x0002\x001F\x0015\x0000\x0004\x001F\x002D\x0000" +
            "\x0001\x001F\x000D\x0000\x0002\x001F\x0008\x0000\x0002\x001F\x0001\x0000\x0001\x001F\x0001\x0000" +
            "\x0001\x001F\x0009\x0000\x0001\x001F\x0009\x0000\x0002\x001F\x0006\x0000\x0001\x001F\x0002\x0000" +
            "\x0004\x001F\x0003\x0000\x0001\x001F\x0002\x0000\x0002\x001F\x0001\x0000\x0003\x001F\x0001\x0000" +
            "\x0002\x001F\x0001\x0000\x0001\x001F\x0008\x0000\x0001\x001F\x0001\x0000\x0002\x001F\x0002\x0000" +
            "\x0002\x001F\x0001\x0000\x0004\x001F\x0013\x0000\x0001\x001F\x0011\x0000\x0001\x0022\x0001\x0000" +
            "\x0001\x0023\x0002\x0000\x0001\x00A7\x0001\x0000\x0001\x0025\x0004\x0000\x0001\x0026\x0001\x0000" +
            "\x0001\x0027\x0001\x0000\x0001\x0028\x0002\x0000\x0001\x0029\x0003\x0000\x0001\x00A8\x0002\x0000" +
            "\x0001\x00A9\x0004\x0000\x0001\x002C\x0003\x0000\x0001\x00AA\x000F\x0000\x0001\x002E\x0002\x0000" +
            "\x0001\x00AB\x0011\x0000\x0001\x00AC\x0002\x0000\x0001\x00AD\x0031\x0000\x0001\x0018\x0001\x0067" +
            "\x0001\x0032\x0004\x0000\x0001\x0034\x0001\x0000\x0001\x0067\x0004\x0000\x0001\x001F\x0001\x0018" +
            "\x0006\x0000\x0001\x00AE\x0011\x0000\x0001\x00AF\x0002\x0000\x0001\x00B0\x0008\x0000\x0001\x00B1" +
            "\x0012\x0000\x0001\x00B2\x0011\x0000\x0001\x00B3\x0002\x0000\x0001\x00B4\x0032\x0000\x0001\x0068" +
            "\x0007\x0000\x0001\x0068\x0004\x0000\x0001\x0067\x0008\x0000\x0001\x0018\x0004\x0000\x0001\x0018" +
            "\x0009\x0000\x0001\x0018\x0012\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x000B\x0000\x0001\x0020" +
            "\x0002\x0000\x0001\x0020\x0008\x0000\x0001\x0018\x0012\x0000\x0004\x0020\x001D\x0000\x0001\x0018" +
            "\x0016\x0000\x0001\x0018\x0016\x0000\x0002\x0018\x0013\x0000\x0001\x0032\x0001\x0018\x0020\x0000" +
            "\x0001\x0032\x000B\x0000\x0001\x0020\x0035\x0000\x0001\x0032\x0009\x0000\x0001\x0020\x000D\x0000" +
            "\x0004\x0018\x0002\x0000\x0002\x0018\x000C\x0000\x0003\x0018\x0001\x0020\x0001\x0000\x0002\x0020" +
            "\x0009\x0000\x0003\x0018\x0003\x0000\x0001\x0018\x0001\x0000\x0001\x0020\x0004\x0000\x0001\x0020" +
            "\x0002\x0018\x0001\x0000\x0004\x0032\x0001\x0000\x0002\x0018\x0005\x0000\x0004\x0020\x0002\x0000" +
            "\x0001\x0018\x0001\x0020\x000A\x0000\x0001\x0020\x0007\x0000\x0001\x0018\x0018\x0000\x0001\x0018" +
            "\x0004\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0006\x0000\x0001\x0018" +
            "\x0005\x0000\x0001\x0018\x0002\x0000\x0002\x0018\x0001\x0000\x000F\x0018\x0002\x0000\x0001\x0018" +
            "\x000B\x0000\x0007\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018" +
            "\x0002\x0000\x0001\x0018\x0001\x0000\x0003\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0004\x0000\x0001\x0020\x0001\x0000\x0002\x0018" +
            "\x0006\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x001B\x0000\x0001\x0018" +
            "\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0007\x0000\x0001\x0018" +
            "\x0019\x0000\x0010\x0018\x0005\x0000\x0003\x0018\x0004\x0000\x0001\x0018\x0006\x0000\x0001\x0018" +
            "\x0003\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0004\x0000\x0001\x0018\x0004\x0020\x0001\x0000" +
            "\x0001\x0018\x0002\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x005C\x0000\x0002\x0020\x0015\x0000\x0004\x0020\x002D\x0000\x0001\x0020\x000D\x0000" +
            "\x0002\x0020\x0008\x0000\x0002\x0020\x0001\x0000\x0001\x0020\x0001\x0000\x0001\x0020\x0009\x0000" +
            "\x0001\x0020\x0009\x0000\x0002\x0020\x0006\x0000\x0001\x0020\x0002\x0000\x0004\x0020\x0003\x0000" +
            "\x0001\x0020\x0002\x0000\x0002\x0020\x0001\x0000\x0003\x0020\x0001\x0000\x0002\x0020\x0001\x0000" +
            "\x0001\x0020\x0008\x0000\x0001\x0020\x0001\x0000\x0002\x0020\x0002\x0000\x0002\x0020\x0001\x0000" +
            "\x0004\x0020\x0013\x0000\x0001\x0020\x0049\x0000\x0001\x0021\x0002\x0000\x0001\x0021\x001B\x0000" +
            "\x0004\x0021\x008E\x0000\x0001\x0021\x003F\x0000\x0001\x0021\x0024\x0000\x0001\x0021\x0001\x0000" +
            "\x0002\x0021\x0011\x0000\x0001\x0021\x0004\x0000\x0001\x0021\x000F\x0000\x0004\x0021\x0003\x0000" +
            "\x0001\x0021\x000A\x0000\x0001\x0021\x0083\x0000\x0001\x0021\x0092\x0000\x0004\x0021\x006A\x0000" +
            "\x0002\x0021\x0015\x0000\x0004\x0021\x002D\x0000\x0001\x0021\x000D\x0000\x0002\x0021\x0008\x0000" +
            "\x0002\x0021\x0001\x0000\x0001\x0021\x0001\x0000\x0001\x0021\x0009\x0000\x0001\x0021\x0009\x0000" +
            "\x0002\x0021\x0006\x0000\x0001\x0021\x0002\x0000\x0004\x0021\x0003\x0000\x0001\x0021\x0002\x0000" +
            "\x0002\x0021\x0001\x0000\x0003\x0021\x0001\x0000\x0002\x0021\x0001\x0000\x0001\x0021\x0008\x0000" +
            "\x0001\x0021\x0001\x0000\x0002\x0021\x0002\x0000\x0002\x0021\x0001\x0000\x0004\x0021\x0013\x0000" +
            "\x0001\x0021\x0075\x0000\x0001\x00B5\x0016\x0000\x0002\x00B5\x0017\x0000\x0001\x0018\x0004\x0000" +
            "\x0001\x0018\x0009\x0000\x0001\x0018\x0012\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x000B\x0000" +
            "\x0001\x0032\x0002\x0000\x0001\x0032\x0008\x0000\x0001\x0018\x0012\x0000\x0004\x0032\x001D\x0000" +
            "\x0001\x0018\x0016\x0000\x0001\x0018\x0016\x0000\x0002\x0018\x0013\x0000\x0001\x0032\x0001\x0018" +
            "\x0020\x0000\x0001\x0032\x000B\x0000\x0001\x0032\x0035\x0000\x0001\x0032\x0009\x0000\x0001\x0032" +
            "\x000D\x0000\x0004\x0018\x0002\x0000\x0002\x0018\x000C\x0000\x0003\x0018\x0001\x0032\x0001\x0000" +
            "\x0002\x0032\x0009\x0000\x0003\x0018\x0003\x0000\x0001\x0018\x0001\x0000\x0001\x0032\x0004\x0000" +
            "\x0001\x0032\x0002\x0018\x0001\x0000\x0004\x0032\x0001\x0000\x0002\x0018\x0005\x0000\x0004\x0032" +
            "\x0002\x0000\x0001\x0018\x0001\x0032\x000A\x0000\x0001\x0032\x0007\x0000\x0001\x0018\x0018\x0000" +
            "\x0001\x0018\x0004\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0006\x0000" +
            "\x0001\x0018\x0005\x0000\x0001\x0018\x0002\x0000\x0002\x0018\x0001\x0000\x000F\x0018\x0002\x0000" +
            "\x0001\x0018\x000B\x0000\x0007\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000" +
            "\x0002\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0003\x0018\x0002\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0004\x0000\x0001\x0032\x0001\x0000" +
            "\x0002\x0018\x0006\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x001B\x0000" +
            "\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0007\x0000" +
            "\x0001\x0018\x0019\x0000\x0010\x0018\x0005\x0000\x0003\x0018\x0004\x0000\x0001\x0018\x0006\x0000" +
            "\x0001\x0018\x0003\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0004\x0000\x0001\x0018\x0004\x0032" +
            "\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x005C\x0000\x0002\x0032\x0015\x0000\x0004\x0032\x002D\x0000\x0001\x0032" +
            "\x000D\x0000\x0002\x0032\x0008\x0000\x0002\x0032\x0001\x0000\x0001\x0032\x0001\x0000\x0001\x0032" +
            "\x0009\x0000\x0001\x0032\x0009\x0000\x0002\x0032\x0006\x0000\x0001\x0032\x0002\x0000\x0004\x0032" +
            "\x0003\x0000\x0001\x0032\x0002\x0000\x0002\x0032\x0001\x0000\x0003\x0032\x0001\x0000\x0002\x0032" +
            "\x0001\x0000\x0001\x0032\x0008\x0000\x0001\x0032\x0001\x0000\x0002\x0032\x0002\x0000\x0002\x0032" +
            "\x0001\x0000\x0004\x0032\x0013\x0000\x0001\x0032\x0016\x0000\x0001\x00B6\x0001\x0000\x0001\x00B7" +
            "\x000F\x0000\x0001\x00B8\x0002\x0000\x0001\x00B9\x0004\x0000\x0001\x00BA\x0003\x0000\x0001\x00BB" +
            "\x0012\x0000\x0001\x00BC\x0011\x0000\x0001\x00BD\x0002\x0000\x0001\x00BE\x0032\x0000\x0001\x007F" +
            "\x0001\x0032\x0006\x0000\x0001\x007F\x000D\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0009\x0000" +
            "\x0001\x0018\x0012\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x000B\x0000\x0001\x0033\x0002\x0000" +
            "\x0001\x0033\x0008\x0000\x0001\x0018\x0012\x0000\x0004\x0033\x001D\x0000\x0001\x0018\x0019\x0000" +
            "\x0001\x0018\x0003\x0000\x0004\x0018\x0001\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000" +
            "\x0002\x0018\x0002\x0000\x0002\x0018\x0002\x0000\x0003\x0018\x0001\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0002\x0000\x0004\x0018\x0001\x0000\x0003\x0018\x0001\x0000\x0001\x0018\x0001\x0000" +
            "\x0003\x0018\x0001\x0000\x0002\x0018\x0001\x0000\x0004\x0018\x0001\x0000\x0002\x0018\x0002\x0000" +
            "\x0008\x0018\x0001\x0000\x0002\x0018\x0001\x0000\x0008\x0018\x0002\x0000\x0007\x0018\x0001\x0000" +
            "\x0008\x0018\x0001\x0000\x0006\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0003\x0000\x0003\x0018\x0012\x0000\x0001\x0018\x0016\x0000" +
            "\x0002\x0018\x0014\x0000\x0001\x0018\x002C\x0000\x0001\x0033\x003F\x0000\x0001\x0033\x000D\x0000" +
            "\x0004\x0018\x0002\x0000\x0002\x0018\x000C\x0000\x0003\x0018\x0001\x0033\x0001\x0000\x0002\x0033" +
            "\x0009\x0000\x0003\x0018\x0003\x0000\x0001\x0018\x0001\x0000\x0001\x0033\x0004\x0000\x0001\x0033" +
            "\x0002\x0018\x0006\x0000\x0002\x0018\x0005\x0000\x0004\x0033\x0002\x0000\x0001\x0018\x0001\x0033" +
            "\x000A\x0000\x0001\x0033\x0007\x0000\x0001\x0018\x0024\x0000\x0001\x0018\x0003\x0000\x0002\x0018" +
            "\x000A\x0000\x0002\x0018\x0001\x0000\x0003\x0018\x0007\x0000\x0001\x0018\x0006\x0000\x0002\x0018" +
            "\x0001\x0000\x0002\x0018\x0006\x0000\x0001\x0018\x0004\x0000\x0002\x0018\x0002\x0000\x0002\x0018" +
            "\x0005\x0000\x0003\x0018\x0002\x0000\x0001\x0018\x000D\x0000\x0001\x0018\x000E\x0000\x0001\x0018" +
            "\x0007\x0000\x0001\x0018\x0018\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0006\x0000\x0001\x0018" +
            "\x0003\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0005\x0000\x0001\x0018\x0002\x0000\x0002\x0018" +
            "\x0001\x0000\x000F\x0018\x0002\x0000\x0001\x0018\x000B\x0000\x0007\x0018\x0002\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0003\x0018" +
            "\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0004\x0000\x0001\x0033\x0001\x0000\x0002\x0018\x0006\x0000\x0001\x0018\x0007\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x001B\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018" +
            "\x0003\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0019\x0000\x0010\x0018\x0005\x0000\x0003\x0018" +
            "\x0004\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0002\x0018\x0002\x0000\x0002\x0018" +
            "\x0004\x0000\x0001\x0018\x0004\x0033\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0004\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x005C\x0000\x0002\x0033\x0015\x0000" +
            "\x0004\x0033\x002D\x0000\x0001\x0033\x000D\x0000\x0002\x0033\x0008\x0000\x0002\x0033\x0001\x0000" +
            "\x0001\x0033\x0001\x0000\x0001\x0033\x0009\x0000\x0001\x0033\x0009\x0000\x0002\x0033\x0006\x0000" +
            "\x0001\x0033\x0002\x0000\x0004\x0033\x0003\x0000\x0001\x0033\x0002\x0000\x0002\x0033\x0001\x0000" +
            "\x0003\x0033\x0001\x0000\x0002\x0033\x0001\x0000\x0001\x0033\x0008\x0000\x0001\x0033\x0001\x0000" +
            "\x0002\x0033\x0002\x0000\x0002\x0033\x0001\x0000\x0004\x0033\x0013\x0000\x0001\x0033\x0017\x0000" +
            "\x0001\x0018\x0004\x0000\x0001\x0018\x0009\x0000\x0001\x0018\x0012\x0000\x0001\x0018\x0003\x0000" +
            "\x0001\x0018\x000B\x0000\x0001\x0034\x0002\x0000\x0001\x0034\x0008\x0000\x0001\x0018\x0012\x0000" +
            "\x0004\x0034\x001D\x0000\x0001\x0018\x0016\x0000\x0001\x0018\x0016\x0000\x0002\x0018\x0013\x0000" +
            "\x0001\x0032\x0001\x0018\x0020\x0000\x0001\x0032\x000B\x0000\x0001\x0034\x0035\x0000\x0001\x0032" +
            "\x0009\x0000\x0001\x0034\x000D\x0000\x0004\x0018\x0002\x0000\x0002\x0018\x000C\x0000\x0003\x0018" +
            "\x0001\x0034\x0001\x0000\x0002\x0034\x0009\x0000\x0003\x0018\x0003\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0034\x0004\x0000\x0001\x0034\x0002\x0018\x0001\x0000\x0004\x0032\x0001\x0000\x0002\x0018" +
            "\x0005\x0000\x0004\x0034\x0002\x0000\x0001\x0018\x0001\x0034\x000A\x0000\x0001\x0034\x0007\x0000" +
            "\x0001\x0018\x0018\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000" +
            "\x0001\x0018\x0006\x0000\x0001\x0018\x0005\x0000\x0001\x0018\x0002\x0000\x0002\x0018\x0001\x0000" +
            "\x000F\x0018\x0002\x0000\x0001\x0018\x000B\x0000\x0007\x0018\x0002\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0003\x0018\x0002\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0004\x0000" +
            "\x0001\x0034\x0001\x0000\x0002\x0018\x0006\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x001B\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0003\x0000" +
            "\x0001\x0018\x0007\x0000\x0001\x0018\x0019\x0000\x0010\x0018\x0005\x0000\x0003\x0018\x0004\x0000" +
            "\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0004\x0000" +
            "\x0001\x0018\x0004\x0034\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0004\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x005C\x0000\x0002\x0034\x0015\x0000\x0004\x0034" +
            "\x002D\x0000\x0001\x0034\x000D\x0000\x0002\x0034\x0008\x0000\x0002\x0034\x0001\x0000\x0001\x0034" +
            "\x0001\x0000\x0001\x0034\x0009\x0000\x0001\x0034\x0009\x0000\x0002\x0034\x0006\x0000\x0001\x0034" +
            "\x0002\x0000\x0004\x0034\x0003\x0000\x0001\x0034\x0002\x0000\x0002\x0034\x0001\x0000\x0003\x0034" +
            "\x0001\x0000\x0002\x0034\x0001\x0000\x0001\x0034\x0008\x0000\x0001\x0034\x0001\x0000\x0002\x0034" +
            "\x0002\x0000\x0002\x0034\x0001\x0000\x0004\x0034\x0013\x0000\x0001\x0034\x0049\x0000\x0001\x003E" +
            "\x0002\x0000\x0001\x003E\x001B\x0000\x0004\x003E\x0042\x0000\x0001\x0019\x0044\x0000\x0001\x0019" +
            "\x0066\x0000\x0001\x0019\x0021\x0000\x0001\x0019\x000B\x0000\x0001\x003E\x0035\x0000\x0001\x0019" +
            "\x0009\x0000\x0001\x003E\x0024\x0000\x0001\x003E\x0001\x0000\x0002\x003E\x0011\x0000\x0001\x003E" +
            "\x0004\x0000\x0001\x003E\x0003\x0000\x0004\x0019\x0008\x0000\x0004\x003E\x0003\x0000\x0001\x003E" +
            "\x000A\x0000\x0001\x003E\x0074\x0000\x0002\x0019\x009B\x0000\x0001\x003E\x0092\x0000\x0004\x003E" +
            "\x006A\x0000\x0002\x003E\x0015\x0000\x0004\x003E\x002D\x0000\x0001\x003E\x000D\x0000\x0002\x003E" +
            "\x0008\x0000\x0002\x003E\x0001\x0000\x0001\x003E\x0001\x0000\x0001\x003E\x0009\x0000\x0001\x003E" +
            "\x0009\x0000\x0002\x003E\x0006\x0000\x0001\x003E\x0002\x0000\x0004\x003E\x0003\x0000\x0001\x003E" +
            "\x0002\x0000\x0002\x003E\x0001\x0000\x0003\x003E\x0001\x0000\x0002\x003E\x0001\x0000\x0001\x003E" +
            "\x0008\x0000\x0001\x003E\x0001\x0000\x0002\x003E\x0002\x0000\x0002\x003E\x0001\x0000\x0004\x003E" +
            "\x0013\x0000\x0001\x003E\x0017\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0009\x0000\x0001\x0018" +
            "\x0012\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x000B\x0000\x0001\x003F\x0002\x0000\x0001\x003F" +
            "\x0008\x0000\x0001\x0018\x0012\x0000\x0004\x003F\x001D\x0000\x0001\x0018\x0016\x0000\x0001\x0018" +
            "\x0016\x0000\x0002\x0018\x0013\x0000\x0001\x0019\x0001\x0018\x0020\x0000\x0001\x0019\x000B\x0000" +
            "\x0001\x003F\x0035\x0000\x0001\x0019\x0009\x0000\x0001\x003F\x000D\x0000\x0004\x0018\x0002\x0000" +
            "\x0002\x0018\x000C\x0000\x0003\x0018\x0001\x003F\x0001\x0000\x0002\x003F\x0009\x0000\x0003\x0018" +
            "\x0003\x0000\x0001\x0018\x0001\x0000\x0001\x003F\x0004\x0000\x0001\x003F\x0002\x0018\x0001\x0000" +
            "\x0004\x0019\x0001\x0000\x0002\x0018\x0005\x0000\x0004\x003F\x0002\x0000\x0001\x0018\x0001\x003F" +
            "\x000A\x0000\x0001\x003F\x0007\x0000\x0001\x0018\x0018\x0000\x0001\x0018\x0004\x0000\x0001\x0018" +
            "\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0005\x0000\x0001\x0018" +
            "\x0002\x0000\x0002\x0018\x0001\x0000\x000F\x0018\x0002\x0000\x0001\x0018\x000B\x0000\x0007\x0018" +
            "\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0001\x0018" +
            "\x0001\x0000\x0003\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x0004\x0000\x0001\x003F\x0001\x0000\x0002\x0018\x0006\x0000\x0001\x0018" +
            "\x0007\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x001B\x0000\x0001\x0018\x0006\x0000\x0001\x0018" +
            "\x0003\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0019\x0000\x0010\x0018" +
            "\x0005\x0000\x0003\x0018\x0004\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0002\x0018" +
            "\x0002\x0000\x0002\x0018\x0004\x0000\x0001\x0018\x0004\x003F\x0001\x0000\x0001\x0018\x0002\x0000" +
            "\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x005C\x0000" +
            "\x0002\x003F\x0015\x0000\x0004\x003F\x002D\x0000\x0001\x003F\x000D\x0000\x0002\x003F\x0008\x0000" +
            "\x0002\x003F\x0001\x0000\x0001\x003F\x0001\x0000\x0001\x003F\x0009\x0000\x0001\x003F\x0009\x0000" +
            "\x0002\x003F\x0006\x0000\x0001\x003F\x0002\x0000\x0004\x003F\x0003\x0000\x0001\x003F\x0002\x0000" +
            "\x0002\x003F\x0001\x0000\x0003\x003F\x0001\x0000\x0002\x003F\x0001\x0000\x0001\x003F\x0008\x0000" +
            "\x0001\x003F\x0001\x0000\x0002\x003F\x0002\x0000\x0002\x003F\x0001\x0000\x0004\x003F\x0013\x0000" +
            "\x0001\x003F\x0049\x0000\x0001\x0051\x0002\x0000\x0001\x0051\x001B\x0000\x0004\x0051\x008E\x0000" +
            "\x0001\x0051\x003F\x0000\x0001\x0051\x0024\x0000\x0001\x0051\x0001\x0000\x0002\x0051\x0011\x0000" +
            "\x0001\x0051\x0004\x0000\x0001\x0051\x000F\x0000\x0004\x0051\x0003\x0000\x0001\x0051\x000A\x0000" +
            "\x0001\x0051\x0083\x0000\x0001\x0051\x0092\x0000\x0004\x0051\x006A\x0000\x0002\x0051\x0015\x0000" +
            "\x0004\x0051\x002D\x0000\x0001\x0051\x000D\x0000\x0002\x0051\x0008\x0000\x0002\x0051\x0001\x0000" +
            "\x0001\x0051\x0001\x0000\x0001\x0051\x0009\x0000\x0001\x0051\x0009\x0000\x0002\x0051\x0006\x0000" +
            "\x0001\x0051\x0002\x0000\x0004\x0051\x0003\x0000\x0001\x0051\x0002\x0000\x0002\x0051\x0001\x0000" +
            "\x0003\x0051\x0001\x0000\x0002\x0051\x0001\x0000\x0001\x0051\x0008\x0000\x0001\x0051\x0001\x0000" +
            "\x0002\x0051\x0002\x0000\x0002\x0051\x0001\x0000\x0004\x0051\x0013\x0000\x0001\x0051\x0017\x0000" +
            "\x0001\x0018\x0004\x0000\x0001\x0018\x0009\x0000\x0001\x0018\x0012\x0000\x0001\x0018\x0003\x0000" +
            "\x0001\x0018\x000B\x0000\x0001\x0067\x0002\x0000\x0001\x0067\x0008\x0000\x0001\x0018\x0012\x0000" +
            "\x0004\x0067\x001D\x0000\x0001\x0018\x0016\x0000\x0001\x0018\x0016\x0000\x0002\x0018\x0013\x0000" +
            "\x0001\x0032\x0001\x0018\x0020\x0000\x0001\x0032\x000B\x0000\x0001\x0067\x0035\x0000\x0001\x0032" +
            "\x0009\x0000\x0001\x0067\x000D\x0000\x0004\x0018\x0002\x0000\x0002\x0018\x000C\x0000\x0003\x0018" +
            "\x0001\x0067\x0001\x0000\x0002\x0067\x0009\x0000\x0003\x0018\x0003\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0067\x0004\x0000\x0001\x0067\x0002\x0018\x0001\x0000\x0004\x0032\x0001\x0000\x0002\x0018" +
            "\x0005\x0000\x0004\x0067\x0002\x0000\x0001\x0018\x0001\x0067\x000A\x0000\x0001\x0067\x0007\x0000" +
            "\x0001\x0018\x0018\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000" +
            "\x0001\x0018\x0006\x0000\x0001\x0018\x0005\x0000\x0001\x0018\x0002\x0000\x0002\x0018\x0001\x0000" +
            "\x000F\x0018\x0002\x0000\x0001\x0018\x000B\x0000\x0007\x0018\x0002\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0003\x0018\x0002\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0004\x0000" +
            "\x0001\x0067\x0001\x0000\x0002\x0018\x0006\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x001B\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0003\x0000" +
            "\x0001\x0018\x0007\x0000\x0001\x0018\x0019\x0000\x0010\x0018\x0005\x0000\x0003\x0018\x0004\x0000" +
            "\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0004\x0000" +
            "\x0001\x0018\x0004\x0067\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0004\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x005C\x0000\x0002\x0067\x0015\x0000\x0004\x0067" +
            "\x002D\x0000\x0001\x0067\x000D\x0000\x0002\x0067\x0008\x0000\x0002\x0067\x0001\x0000\x0001\x0067" +
            "\x0001\x0000\x0001\x0067\x0009\x0000\x0001\x0067\x0009\x0000\x0002\x0067\x0006\x0000\x0001\x0067" +
            "\x0002\x0000\x0004\x0067\x0003\x0000\x0001\x0067\x0002\x0000\x0002\x0067\x0001\x0000\x0003\x0067" +
            "\x0001\x0000\x0002\x0067\x0001\x0000\x0001\x0067\x0008\x0000\x0001\x0067\x0001\x0000\x0002\x0067" +
            "\x0002\x0000\x0002\x0067\x0001\x0000\x0004\x0067\x0013\x0000\x0001\x0067\x0049\x0000\x0001\x0068" +
            "\x0002\x0000\x0001\x0068\x001B\x0000\x0004\x0068\x008E\x0000\x0001\x0068\x003F\x0000\x0001\x0068" +
            "\x0024\x0000\x0001\x0068\x0001\x0000\x0002\x0068\x0011\x0000\x0001\x0068\x0004\x0000\x0001\x0068" +
            "\x000F\x0000\x0004\x0068\x0003\x0000\x0001\x0068\x000A\x0000\x0001\x0068\x0083\x0000\x0001\x0068" +
            "\x0092\x0000\x0004\x0068\x006A\x0000\x0002\x0068\x0015\x0000\x0004\x0068\x002D\x0000\x0001\x0068" +
            "\x000D\x0000\x0002\x0068\x0008\x0000\x0002\x0068\x0001\x0000\x0001\x0068\x0001\x0000\x0001\x0068" +
            "\x0009\x0000\x0001\x0068\x0009\x0000\x0002\x0068\x0006\x0000\x0001\x0068\x0002\x0000\x0004\x0068" +
            "\x0003\x0000\x0001\x0068\x0002\x0000\x0002\x0068\x0001\x0000\x0003\x0068\x0001\x0000\x0002\x0068" +
            "\x0001\x0000\x0001\x0068\x0008\x0000\x0001\x0068\x0001\x0000\x0002\x0068\x0002\x0000\x0002\x0068" +
            "\x0001\x0000\x0004\x0068\x0013\x0000\x0001\x0068\x0016\x0000\x0001\x00BF\x0011\x0000\x0001\x00C0" +
            "\x0002\x0000\x0001\x00C1\x0008\x0000\x0001\x00C2\x0012\x0000\x0001\x00C3\x0011\x0000\x0001\x00C4" +
            "\x0002\x0000\x0001\x00C5\x002D\x0000\x0001\x0077\x0004\x0000\x0001\x00B5\x0007\x0000\x0001\x00B5" +
            "\x003F\x0000\x0001\x007F\x0002\x0000\x0001\x007F\x001B\x0000\x0004\x007F\x0042\x0000\x0001\x0032" +
            "\x0044\x0000\x0001\x0032\x0066\x0000\x0001\x0032\x0021\x0000\x0001\x0032\x000B\x0000\x0001\x007F" +
            "\x0035\x0000\x0001\x0032\x0009\x0000\x0001\x007F\x0024\x0000\x0001\x007F\x0001\x0000\x0002\x007F" +
            "\x0011\x0000\x0001\x007F\x0004\x0000\x0001\x007F\x0003\x0000\x0004\x0032\x0008\x0000\x0004\x007F" +
            "\x0003\x0000\x0001\x007F\x000A\x0000\x0001\x007F\x0074\x0000\x0002\x0032\x009B\x0000\x0001\x007F" +
            "\x0092\x0000\x0004\x007F\x006A\x0000\x0002\x007F\x0015\x0000\x0004\x007F\x002D\x0000\x0001\x007F" +
            "\x000D\x0000\x0002\x007F\x0008\x0000\x0002\x007F\x0001\x0000\x0001\x007F\x0001\x0000\x0001\x007F" +
            "\x0009\x0000\x0001\x007F\x0009\x0000\x0002\x007F\x0006\x0000\x0001\x007F\x0002\x0000\x0004\x007F" +
            "\x0003\x0000\x0001\x007F\x0002\x0000\x0002\x007F\x0001\x0000\x0003\x007F\x0001\x0000\x0002\x007F" +
            "\x0001\x0000\x0001\x007F\x0008\x0000\x0001\x007F\x0001\x0000\x0002\x007F\x0002\x0000\x0002\x007F" +
            "\x0001\x0000\x0004\x007F\x0013\x0000\x0001\x007F\x0049\x0000\x0001\x00B5\x0002\x0000\x0001\x00B5" +
            "\x001B\x0000\x0004\x00B5\x008E\x0000\x0001\x00B5\x003F\x0000\x0001\x00B5\x0024\x0000\x0001\x00B5" +
            "\x0001\x0000\x0002\x00B5\x0011\x0000\x0001\x00B5\x0004\x0000\x0001\x00B5\x000F\x0000\x0004\x00B5" +
            "\x0003\x0000\x0001\x00B5\x000A\x0000\x0001\x00B5\x0083\x0000\x0001\x00B5\x0092\x0000\x0004\x00B5" +
            "\x006A\x0000\x0002\x00B5\x0015\x0000\x0004\x00B5\x002D\x0000\x0001\x00B5\x000D\x0000\x0002\x00B5" +
            "\x0008\x0000\x0002\x00B5\x0001\x0000\x0001\x00B5\x0001\x0000\x0001\x00B5\x0009\x0000\x0001\x00B5" +
            "\x0009\x0000\x0002\x00B5\x0006\x0000\x0001\x00B5\x0002\x0000\x0004\x00B5\x0003\x0000\x0001\x00B5" +
            "\x0002\x0000\x0002\x00B5\x0001\x0000\x0003\x00B5\x0001\x0000\x0002\x00B5\x0001\x0000\x0001\x00B5" +
            "\x0008\x0000\x0001\x00B5\x0001\x0000\x0002\x00B5\x0002\x0000\x0002\x00B5\x0001\x0000\x0004\x00B5" +
            "\x0013\x0000\x0001\x00B5\x0010\x0000";



        private static int[] ZzUnpackTrans()
        {
            int[] result = new int[26554];
            int offset = 0;
            offset = ZzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
            return result;
        }

        private static int ZzUnpackTrans(string packed, int offset, int[] result)
        {
            int i = 0; // index in packed string
            int j = offset; // index in unpacked array
            int l = packed.Length;
            while (i < l)
            {
                int count = packed[i++];
                int value = packed[i++];
                value--;
                do
                {
                    result[j++] = value;
                } while (--count > 0);
            }
            return j;
        }


        /* error codes */
        private const int ZZ_UNKNOWN_ERROR = 0;
        private const int ZZ_NO_MATCH = 1;
        private const int ZZ_PUSHBACK_2BIG = 2;

        /* error messages for the codes above */
        private static readonly string[] ZZ_ERROR_MSG = {
            "Unkown internal scanner error",
            "Error: could not match input",
            "Error: pushback value was too large"
        };

        /// <summary>
        /// ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
        /// </summary>
        private static readonly int[] ZZ_ATTRIBUTE = ZzUnpackAttribute();

        private const string ZZ_ATTRIBUTE_PACKED_0 =
            "\x0001\x0000\x0001\x0009\x001E\x0001\x0011\x0000\x0001\x0001\x0001\x0000\x0001\x0001\x000A\x0000" +
            "\x0001\x0001\x0011\x0000\x0001\x0001\x0015\x0000\x0001\x0001\x004D\x0000\x0001\x0001\x0010\x0000";

        private static int[] ZzUnpackAttribute()
        {
            int[] result = new int[197];
            int offset = 0;
            offset = ZzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
            return result;
        }

        private static int ZzUnpackAttribute(string packed, int offset, int[] result)
        {
            int i = 0; // index in packed string
            int j = offset; // index in unpacked array
            int l = packed.Length;
            while (i < l)
            {
                int count = packed[i++];
                int value = packed[i++];
                do
                {
                    result[j++] = value;
                } while (--count > 0);
            }
            return j;
        }

        /// <summary>
        /// the input device </summary>
        private TextReader zzReader;

        /// <summary>
        /// the current state of the DFA </summary>
        private int zzState;

        /// <summary>
        /// the current lexical state </summary>
        private int zzLexicalState = YYINITIAL;

        /// <summary>
        /// this buffer contains the current text to be matched and is
        ///    the source of the YyText() string 
        /// </summary>
        private char[] zzBuffer = new char[ZZ_BUFFERSIZE];

        /// <summary>
        /// the textposition at the last accepting state </summary>
        private int zzMarkedPos;

        /// <summary>
        /// the current text position in the buffer </summary>
        private int zzCurrentPos;

        /// <summary>
        /// startRead marks the beginning of the YyText() string in the buffer </summary>
        private int zzStartRead;

        /// <summary>
        /// endRead marks the last character in the buffer, that has been read
        ///    from input 
        /// </summary>
        private int zzEndRead;

        /// <summary>
        /// number of newlines encountered up to the start of the matched text </summary>
        private int yyline;

        /// <summary>
        /// the number of characters up to the start of the matched text </summary>
        private int yyChar;

#pragma warning disable 169, 414
        /// <summary>
        /// the number of characters from the last newline up to the start of the 
        /// matched text
        /// </summary>
        private int yycolumn;

        /// <summary>
        /// zzAtBOL == true &lt;=&gt; the scanner is currently at the beginning of a line
        /// </summary>
        private bool zzAtBOL = true;

        /// <summary>
        /// zzAtEOF == true &lt;=&gt; the scanner is at the EOF </summary>
        private bool zzAtEOF;

        /// <summary>
        /// denotes if the user-EOF-code has already been executed </summary>
        private bool zzEOFDone;

#pragma warning restore 169, 414

        /* user code: */
        /// <summary>
        /// Alphanumeric sequences </summary>
        public static readonly int WORD_TYPE = StandardTokenizer.ALPHANUM;

        /// <summary>
        /// Numbers </summary>
        public static readonly int NUMERIC_TYPE = StandardTokenizer.NUM;

        /// <summary>
        /// Chars in class \p{Line_Break = Complex_Context} are from South East Asian
        /// scripts (Thai, Lao, Myanmar, Khmer, etc.).  Sequences of these are kept 
        /// together as as a single token rather than broken up, because the logic
        /// required to break them at word boundaries is too complex for UAX#29.
        /// <para>
        /// See Unicode Line Breaking Algorithm: http://www.unicode.org/reports/tr14/#SA
        /// </para>
        /// </summary>
        public static readonly int SOUTH_EAST_ASIAN_TYPE = StandardTokenizer.SOUTHEAST_ASIAN;

        public static readonly int IDEOGRAPHIC_TYPE = StandardTokenizer.IDEOGRAPHIC;

        public static readonly int HIRAGANA_TYPE = StandardTokenizer.HIRAGANA;

        public static readonly int KATAKANA_TYPE = StandardTokenizer.KATAKANA;

        public static readonly int HANGUL_TYPE = StandardTokenizer.HANGUL;

        public int YyChar
        {
            get { return yyChar; }
        }

        /// <summary>
        /// Fills CharTermAttribute with the current token text.
        /// </summary>
        public void GetText(ICharTermAttribute t)
        {
            t.CopyBuffer(zzBuffer, zzStartRead, zzMarkedPos - zzStartRead);
        }


        /// <summary>
        /// Creates a new scanner
        /// </summary>
        /// <param name="in">  the TextReader to read input from. </param>
        public StandardTokenizerImpl(TextReader @in)
        {
            this.zzReader = @in;
        }


        /// <summary>
        /// Unpacks the compressed character translation table.
        /// </summary>
        /// <param name="packed">   the packed character translation table </param>
        /// <returns>         the unpacked character translation table </returns>
        private static char[] ZzUnpackCMap(string packed)
        {
            char[] map = new char[0x10000];
            int i = 0; // index in packed string
            int j = 0; // index in unpacked array
            while (i < 2860)
            {
                int count = packed[i++];
                char value = packed[i++];
                do
                {
                    map[j++] = value;
                } while (--count > 0);
            }
            return map;
        }


        /// <summary>
        /// Refills the input buffer.
        /// </summary>
        /// <returns>      <code>false</code>, iff there was new input.
        /// </returns>
        /// <exception cref="IOException">  if any I/O-Error occurs </exception>
        private bool ZzRefill()
        {

            /* first: make room (if you can) */
            if (zzStartRead > 0)
            {
                Array.Copy(zzBuffer, zzStartRead, zzBuffer, 0, zzEndRead - zzStartRead);

                /* translate stored positions */
                zzEndRead -= zzStartRead;
                zzCurrentPos -= zzStartRead;
                zzMarkedPos -= zzStartRead;
                zzStartRead = 0;
            }

            /* is the buffer big enough? */
            if (zzCurrentPos >= zzBuffer.Length)
            {
                /* if not: blow it up */
                char[] newBuffer = new char[zzCurrentPos * 2];
                Array.Copy(zzBuffer, 0, newBuffer, 0, zzBuffer.Length);
                zzBuffer = newBuffer;
            }

            /* finally: fill the buffer with new input */
            int numRead = zzReader.Read(zzBuffer, zzEndRead, zzBuffer.Length - zzEndRead);

            if (numRead > 0)
            {
                zzEndRead += numRead;
                return false;
            }
            // unlikely but not impossible: read 0 characters, but not at end of stream    
            if (numRead == 0)
            {
                int c = zzReader.Read();
                if (c <= 0)
                {
                    return true;
                }
                else
                {
                    zzBuffer[zzEndRead++] = (char)c;
                    return false;
                }
            }

            // numRead < 0
            return true;
        }


        /// <summary>
        /// Disposes the input stream.
        /// </summary>
        public void YyClose()
        {
            zzAtEOF = true; // indicate end of file
            zzEndRead = zzStartRead; // invalidate buffer

            if (zzReader != null)
            {
                zzReader.Dispose();
            }
        }


        /// <summary>
        /// Resets the scanner to read from a new input stream.
        /// Does not close the old reader.
        /// 
        /// All internal variables are reset, the old input stream 
        /// <b>cannot</b> be reused (internal buffer is discarded and lost).
        /// Lexical state is set to <see cref="YYINITIAL"/>.
        /// 
        /// Internal scan buffer is resized down to its initial length, if it has grown.
        /// </summary>
        /// <param name="reader">   the new input stream  </param>
        public void YyReset(TextReader reader)
        {
            zzReader = reader;
            zzAtBOL = true;
            zzAtEOF = false;
            zzEOFDone = false;
            zzEndRead = zzStartRead = 0;
            zzCurrentPos = zzMarkedPos = 0;
            yyline = yyChar = yycolumn = 0;
            zzLexicalState = YYINITIAL;
            if (zzBuffer.Length > ZZ_BUFFERSIZE)
            {
                zzBuffer = new char[ZZ_BUFFERSIZE];
            }
        }


        /// <summary>
        /// Returns the current lexical state.
        /// </summary>
        public int YyState
        {
            get { return zzLexicalState; }
        }


        /// <summary>
        /// Enters a new lexical state
        /// </summary>
        /// <param name="newState"> the new lexical state </param>
        public void YyBegin(int newState)
        {
            zzLexicalState = newState;
        }


        /// <summary>
        /// Returns the text matched by the current regular expression.
        /// </summary>
        public string YyText
        {
            get { return new string(zzBuffer, zzStartRead, zzMarkedPos - zzStartRead); }
        }


        /// <summary>
        /// Returns the character at position <paramref name="pos"/> from the 
        /// matched text. 
        /// 
        /// It is equivalent to YyText[pos], but faster
        /// </summary>
        /// <param name="pos"> the position of the character to fetch. 
        ///            A value from 0 to YyLength-1.
        /// </param>
        /// <returns> the character at position pos </returns>
        public char YyCharAt(int pos)
        {
            return zzBuffer[zzStartRead + pos];
        }


        /// <summary>
        /// Returns the length of the matched text region.
        /// </summary>
        public int YyLength
        {
            get { return zzMarkedPos - zzStartRead; }
        }


        /// <summary>
        /// Reports an error that occured while scanning.
        /// <para/>
        /// In a wellformed scanner (no or only correct usage of 
        /// YyPushBack(int) and a match-all fallback rule) this method 
        /// will only be called with things that "Can't Possibly Happen".
        /// If this method is called, something is seriously wrong
        /// (e.g. a JFlex bug producing a faulty scanner etc.).
        /// <para/>
        /// Usual syntax/scanner level error handling should be done
        /// in error fallback rules.
        /// </summary>
        /// <param name="errorCode">  the code of the errormessage to display </param>
        private void ZzScanError(int errorCode)
        {
            string message;
            try
            {
                message = ZZ_ERROR_MSG[errorCode];
            }
            catch (System.IndexOutOfRangeException)
            {
                message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
            }

            throw new Exception(message);
        }


        /// <summary>
        /// Pushes the specified amount of characters back into the input stream.
        /// 
        /// They will be read again by then next call of the scanning method
        /// </summary>
        /// <param name="number">  the number of characters to be read again.
        ///                This number must not be greater than YyLength! </param>
        public void YyPushBack(int number)
        {
            if (number > YyLength)
            {
                ZzScanError(ZZ_PUSHBACK_2BIG);
            }

            zzMarkedPos -= number;
        }


        /// <summary>
        /// Resumes scanning until the next regular expression is matched,
        /// the end of input is encountered or an I/O-Error occurs.
        /// </summary>
        /// <returns>      the next token </returns>
        /// <exception cref="IOException">  if any I/O-Error occurs </exception>
        public int GetNextToken()
        {
            int zzInput;
            int zzAction;

            // cached fields:
            int zzCurrentPosL;
            int zzMarkedPosL;
            int zzEndReadL = zzEndRead;
            char[] zzBufferL = zzBuffer;
            char[] zzCMapL = ZZ_CMAP;

            int[] zzTransL = ZZ_TRANS;
            int[] zzRowMapL = ZZ_ROWMAP;
            int[] zzAttrL = ZZ_ATTRIBUTE;

            while (true)
            {
                zzMarkedPosL = zzMarkedPos;

                yyChar += zzMarkedPosL - zzStartRead;

                zzAction = -1;

                zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

                zzState = ZZ_LEXSTATE[zzLexicalState];

                // set up zzAction for empty match case:
                int zzAttributes = zzAttrL[zzState];
                if ((zzAttributes & 1) == 1)
                {
                    zzAction = zzState;
                }


                {
                    while (true)
                    {

                        if (zzCurrentPosL < zzEndReadL)
                        {
                            zzInput = zzBufferL[zzCurrentPosL++];
                        }
                        else if (zzAtEOF)
                        {
                            zzInput = StandardTokenizerInterface.YYEOF;
                            goto zzForActionBreak;
                        }
                        else
                        {
                            // store back cached positions
                            zzCurrentPos = zzCurrentPosL;
                            zzMarkedPos = zzMarkedPosL;
                            bool eof = ZzRefill();
                            // get translated positions and possibly new buffer
                            zzCurrentPosL = zzCurrentPos;
                            zzMarkedPosL = zzMarkedPos;
                            zzBufferL = zzBuffer;
                            zzEndReadL = zzEndRead;
                            if (eof)
                            {
                                zzInput = StandardTokenizerInterface.YYEOF;
                                goto zzForActionBreak;
                            }
                            else
                            {
                                zzInput = zzBufferL[zzCurrentPosL++];
                            }
                        }
                        int zzNext = zzTransL[zzRowMapL[zzState] + zzCMapL[zzInput]];
                        if (zzNext == -1)
                        {
                            goto zzForActionBreak;
                        }
                        zzState = zzNext;

                        zzAttributes = zzAttrL[zzState];
                        if ((zzAttributes & 1) == 1)
                        {
                            zzAction = zzState;
                            zzMarkedPosL = zzCurrentPosL;
                            if ((zzAttributes & 8) == 8)
                            {
                                goto zzForActionBreak;
                            }
                        }

                    }
                }
                zzForActionBreak:

                // store back cached position
                zzMarkedPos = zzMarkedPosL;

                switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction])
                {
                    case 1:
                        { // Break so we don't hit fall-through warning:
                            break; // Not numeric, word, ideographic, hiragana, or SE Asian -- ignore it.
                        }
                        // goto case 9; // unreachable
                    case 9:
                        break;
                    case 2:
                        {
                            return WORD_TYPE;
                        }
                    case 10:
                        break;
                    case 3:
                        {
                            return NUMERIC_TYPE;
                        }
                    case 11:
                        break;
                    case 4:
                        {
                            return KATAKANA_TYPE;
                        }
                    case 12:
                        break;
                    case 5:
                        {
                            return SOUTH_EAST_ASIAN_TYPE;
                        }
                    case 13:
                        break;
                    case 6:
                        {
                            return IDEOGRAPHIC_TYPE;
                        }
                    case 14:
                        break;
                    case 7:
                        {
                            return HIRAGANA_TYPE;
                        }
                    case 15:
                        break;
                    case 8:
                        {
                            return HANGUL_TYPE;
                        }
                    case 16:
                        break;
                    default:
                        if (zzInput == StandardTokenizerInterface.YYEOF && zzStartRead == zzCurrentPos)
                        {
                            zzAtEOF = true;
                            {
                                return StandardTokenizerInterface.YYEOF;
                            }
                        }
                        else
                        {
                            ZzScanError(ZZ_NO_MATCH);
                        }
                        break;
                }
            }
        }
    }
}
