---
uid: Lucene.Net.QueryParsers.Flexible.Core.Processors
summary: *content
---

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->


Interfaces and implementations used by query node processors

## Query Node Processors

The namespace <tt>Lucene.Net.QueryParsers.Flexible.Core.Processors</tt> contains interfaces that should be implemented by every query node processor. 

The interface that every query node processor should implement is <xref:Lucene.Net.QueryParsers.Flexible.Core.Processors.IQueryNodeProcessor>. 

A query node processor should be used to process a <xref:Lucene.Net.QueryParsers.Flexible.Core.Nodes.IQueryNode> tree. <xref:Lucene.Net.QueryParsers.Flexible.Core.Nodes.IQueryNode> trees can be programmatically created or generated by a text parser. See <xref:Lucene.Net.QueryParsers.Flexible.Core.Parser> for more details about text parsers. 

A query node processor should be used to process a <xref:Lucene.Net.QueryParsers.Flexible.Core.Nodes.IQueryNode> tree. <xref:Lucene.Net.QueryParsers.Flexible.Core.Nodes.IQueryNode> trees can be programmatically created or generated by a text parser. See <xref:Lucene.Net.QueryParsers.Flexible.Core.Parser> for more details about text parsers. 

A pipeline of processors can be assembled using <xref:Lucene.Net.QueryParsers.Flexible.Core.Processors.QueryNodeProcessorPipeline>. 

Implementors may want to extend <xref:Lucene.Net.QueryParsers.Flexible.Core.Processors.QueryNodeProcessor>, which simplifies the implementation, because it walks automatically the <xref:Lucene.Net.QueryParsers.Flexible.Core.Nodes.IQueryNode>. See <xref:Lucene.Net.QueryParsers.Flexible.Core.Processors.QueryNodeProcessor> for more details. 