/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.cmis;

import java.lang.reflect.Method;
import java.util.StringTokenizer;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AbstractAtomPubService;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.crawler.system.Logging;

public class CmisRepositoryConnectorUtils {
    private static final String LOAD_LINK_METHOD_NAME = "loadLink";
    private static final String FROM_TOKEN = "from";
    private static final String SEP = " ";
    private static final String SELECT_STAR_CLAUSE = "select *";
    private static final String OBJECT_ID_TERM = "cmis:objectId,";
    private static final String SELECT_CLAUSE_TERM_SEP = ",";

    public static final String getDocumentURL(Document document, Session session) {
        String link = null;
        try {
            Method loadLink = AbstractAtomPubService.class.getDeclaredMethod(LOAD_LINK_METHOD_NAME, String.class, String.class, String.class, String.class);
            loadLink.setAccessible(true);
            link = (String)loadLink.invoke((Object)session.getBinding().getObjectService(), session.getRepositoryInfo().getId(), document.getId(), "@@content@@", null);
        }
        catch (Exception e) {
            Logging.connectors.error((Object)("CMIS: Error during getting the content stream url: " + e.getMessage()), (Throwable)e);
        }
        return link;
    }

    public static String getCmisQueryWithObjectId(String cmisQuery) {
        String cmisQueryResult = "";
        String selectClause = CmisRepositoryConnectorUtils.getSelectClause(cmisQuery);
        if (selectClause.equalsIgnoreCase(SELECT_STAR_CLAUSE)) {
            cmisQueryResult = cmisQuery;
        } else {
            StringTokenizer selectClauseTokenized = new StringTokenizer(selectClause.trim());
            boolean firstTermSelectClause = true;
            String secondTerm = "";
            while (selectClauseTokenized.hasMoreElements()) {
                String term = selectClauseTokenized.nextToken();
                if (firstTermSelectClause) {
                    firstTermSelectClause = false;
                    continue;
                }
                if (firstTermSelectClause) continue;
                secondTerm = term;
                break;
            }
            cmisQueryResult = StringUtils.replaceOnce((String)cmisQuery, (String)secondTerm, (String)(OBJECT_ID_TERM + secondTerm));
        }
        return cmisQueryResult;
    }

    public static boolean existsInSelectClause(String cmisQuery, String propertyId) {
        String term;
        String selectClause = CmisRepositoryConnectorUtils.getSelectClause(cmisQuery);
        if (selectClause.startsWith(SELECT_STAR_CLAUSE)) {
            return true;
        }
        StringTokenizer cmisQueryTokenized = new StringTokenizer(cmisQuery.trim());
        while (cmisQueryTokenized.hasMoreElements() && !(term = cmisQueryTokenized.nextToken()).equalsIgnoreCase(FROM_TOKEN)) {
            if (term.equalsIgnoreCase(propertyId)) {
                return true;
            }
            if (!StringUtils.contains((String)term, (String)SELECT_CLAUSE_TERM_SEP)) continue;
            StringTokenizer termsTokenized = new StringTokenizer(term, SELECT_CLAUSE_TERM_SEP);
            while (termsTokenized.hasMoreElements()) {
                String termTokenized = termsTokenized.nextToken().trim();
                if (!termTokenized.equalsIgnoreCase(propertyId)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getSelectClause(String cmisQuery) {
        String term;
        StringTokenizer cmisQueryTokenized = new StringTokenizer(cmisQuery.trim());
        String selectClause = "";
        boolean firstTerm = true;
        while (cmisQueryTokenized.hasMoreElements() && !(term = cmisQueryTokenized.nextToken()).equalsIgnoreCase(FROM_TOKEN)) {
            if (firstTerm) {
                selectClause = selectClause + term;
                firstTerm = false;
                continue;
            }
            selectClause = selectClause + SEP + term;
        }
        return selectClause;
    }
}

