/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.throttler;

import org.apache.manifoldcf.core.interfaces.BreakException;
import org.apache.manifoldcf.core.interfaces.IBreakCheck;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IServiceDataAcceptor;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class FetchBin {
    protected boolean isAlive = true;
    protected final String binName;
    protected final String serviceTypeName;
    protected final String serviceName;
    protected final String targetCalcLockName;
    protected long minTimeBetweenFetches = Long.MAX_VALUE;
    protected long localMinimum = Long.MAX_VALUE;
    protected long lastFetchTime = 0L;
    protected boolean reserveNextFetch = false;
    protected static final String serviceTypePrefix = "_FETCHBIN_";
    protected static final String targetCalcLockPrefix = "_FETCHBINTARGET_";

    public FetchBin(IThreadContext threadContext, String throttlingGroupName, String binName) throws ManifoldCFException {
        this.binName = binName;
        this.serviceTypeName = FetchBin.buildServiceTypeName(throttlingGroupName, binName);
        this.targetCalcLockName = FetchBin.buildTargetCalcLockName(throttlingGroupName, binName);
        ILockManager lockManager = LockManagerFactory.make(threadContext);
        this.serviceName = lockManager.registerServiceBeginServiceActivity(this.serviceTypeName, null, null);
    }

    protected static String buildServiceTypeName(String throttlingGroupName, String binName) {
        return serviceTypePrefix + throttlingGroupName + "_" + binName;
    }

    protected static String buildTargetCalcLockName(String throttlingGroupName, String binName) {
        return targetCalcLockPrefix + throttlingGroupName + "_" + binName;
    }

    public String getBinName() {
        return this.binName;
    }

    public synchronized void updateMinTimeBetweenFetches(long minTimeBetweenFetches) {
        this.minTimeBetweenFetches = minTimeBetweenFetches;
    }

    public synchronized boolean reserveFetchRequest(IBreakCheck breakCheck) throws InterruptedException, BreakException {
        while (this.isAlive) {
            if (!this.reserveNextFetch) {
                this.reserveNextFetch = true;
                return true;
            }
            if (breakCheck == null) {
                this.wait();
                continue;
            }
            long amt = breakCheck.abortCheck();
            this.wait(amt);
        }
        return false;
    }

    public synchronized void clearReservation() {
        if (!this.reserveNextFetch) {
            throw new IllegalStateException("Can't clear a fetch reservation we don't have");
        }
        this.reserveNextFetch = false;
        this.notifyAll();
    }

    public synchronized boolean waitNextFetch(IBreakCheck breakCheck) throws InterruptedException, BreakException {
        if (!this.reserveNextFetch) {
            throw new IllegalStateException("No fetch request reserved!");
        }
        while (this.isAlive) {
            if (this.localMinimum == Long.MAX_VALUE) {
                if (breakCheck == null) {
                    this.wait();
                    continue;
                }
                long amt = breakCheck.abortCheck();
                this.wait(amt);
                continue;
            }
            long currentTime = System.currentTimeMillis();
            long waitAmt = this.lastFetchTime + this.localMinimum - currentTime;
            if (waitAmt <= 0L) {
                if (currentTime > this.lastFetchTime) {
                    this.lastFetchTime = currentTime;
                }
                this.reserveNextFetch = false;
                this.notifyAll();
                return true;
            }
            if (breakCheck == null) {
                this.wait(waitAmt);
                continue;
            }
            long amt = breakCheck.abortCheck();
            if (waitAmt < amt) {
                amt = waitAmt;
            }
            this.wait(amt);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void poll(IThreadContext threadContext) throws ManifoldCFException {
        ILockManager lockManager = LockManagerFactory.make(threadContext);
        lockManager.enterWriteLock(this.targetCalcLockName);
        try {
            double fairTarget;
            double maximumTarget;
            SumClass sumClass = new SumClass(this.serviceName);
            lockManager.scanServiceData(this.serviceTypeName, sumClass);
            int numServices = sumClass.getNumServices();
            if (numServices == 0) {
                return;
            }
            double globalTarget = sumClass.getGlobalTarget();
            long earliestTargetTime = sumClass.getEarliestTime();
            long currentTime = System.currentTimeMillis();
            if (this.lastFetchTime == 0L) {
                earliestTargetTime = currentTime;
            } else if (earliestTargetTime > this.lastFetchTime) {
                earliestTargetTime = this.lastFetchTime;
            }
            if ((double)this.minTimeBetweenFetches == 0.0) {
                double globalMaxFetchesPerMillisecond;
                maximumTarget = globalMaxFetchesPerMillisecond = Double.MAX_VALUE;
                fairTarget = globalMaxFetchesPerMillisecond;
            } else {
                double globalMaxFetchesPerMillisecond = 1.0 / (double)this.minTimeBetweenFetches;
                maximumTarget = globalMaxFetchesPerMillisecond - globalTarget;
                if (maximumTarget < 0.0) {
                    maximumTarget = 0.0;
                }
                fairTarget = globalMaxFetchesPerMillisecond / (double)numServices;
            }
            double inverseTarget = maximumTarget;
            if (inverseTarget > fairTarget) {
                inverseTarget = fairTarget;
            }
            long target = inverseTarget == 0.0 ? Long.MAX_VALUE : (long)(1.0 / inverseTarget + 0.5);
            long nextFetchTime = earliestTargetTime + target;
            lockManager.updateServiceData(this.serviceTypeName, this.serviceName, FetchBin.pack(inverseTarget, nextFetchTime));
            if (target == this.localMinimum && earliestTargetTime == this.lastFetchTime) {
                return;
            }
            this.localMinimum = target;
            this.lastFetchTime = earliestTargetTime;
            this.notifyAll();
        }
        finally {
            lockManager.leaveWriteLock(this.targetCalcLockName);
        }
    }

    public synchronized void shutDown(IThreadContext threadContext) throws ManifoldCFException {
        this.isAlive = false;
        this.notifyAll();
        ILockManager lockManager = LockManagerFactory.make(threadContext);
        lockManager.endServiceActivity(this.serviceTypeName, this.serviceName);
    }

    protected static double unpackTarget(byte[] data) {
        if (data == null || data.length != 8) {
            return 0.0;
        }
        return Double.longBitsToDouble(((long)data[0] & 0xFFL) + ((long)data[1] << 8 & 0xFF00L) + ((long)data[2] << 16 & 0xFF0000L) + ((long)data[3] << 24 & 0xFF000000L) + ((long)data[4] << 32 & 0xFF00000000L) + ((long)data[5] << 40 & 0xFF0000000000L) + ((long)data[6] << 48 & 0xFF000000000000L) + ((long)data[7] << 56 & 0xFF00000000000000L));
    }

    protected static long unpackEarliestTime(byte[] data) {
        if (data == null || data.length != 16) {
            return Long.MAX_VALUE;
        }
        return ((long)data[8] & 0xFFL) + ((long)data[9] << 8 & 0xFF00L) + ((long)data[10] << 16 & 0xFF0000L) + ((long)data[11] << 24 & 0xFF000000L) + ((long)data[12] << 32 & 0xFF00000000L) + ((long)data[13] << 40 & 0xFF0000000000L) + ((long)data[14] << 48 & 0xFF000000000000L) + ((long)data[15] << 56 & 0xFF00000000000000L);
    }

    protected static byte[] pack(double targetDouble, long earliestTime) {
        long target = Double.doubleToLongBits(targetDouble);
        byte[] rval = new byte[]{(byte)(target & 0xFFL), (byte)(target >> 8 & 0xFFL), (byte)(target >> 16 & 0xFFL), (byte)(target >> 24 & 0xFFL), (byte)(target >> 32 & 0xFFL), (byte)(target >> 40 & 0xFFL), (byte)(target >> 48 & 0xFFL), (byte)(target >> 56 & 0xFFL), (byte)(earliestTime & 0xFFL), (byte)(earliestTime >> 8 & 0xFFL), (byte)(earliestTime >> 16 & 0xFFL), (byte)(earliestTime >> 24 & 0xFFL), (byte)(earliestTime >> 32 & 0xFFL), (byte)(earliestTime >> 40 & 0xFFL), (byte)(earliestTime >> 48 & 0xFFL), (byte)(earliestTime >> 56 & 0xFFL)};
        return rval;
    }

    protected static class SumClass
    implements IServiceDataAcceptor {
        protected final String serviceName;
        protected int numServices = 0;
        protected double globalTargetTally = 0.0;
        protected long earliestTime = Long.MAX_VALUE;

        public SumClass(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public boolean acceptServiceData(String serviceName, byte[] serviceData) throws ManifoldCFException {
            ++this.numServices;
            if (!serviceName.equals(this.serviceName)) {
                this.globalTargetTally += FetchBin.unpackTarget(serviceData);
                long checkTime = FetchBin.unpackEarliestTime(serviceData);
                if (checkTime < this.earliestTime) {
                    this.earliestTime = checkTime;
                }
            }
            return false;
        }

        public int getNumServices() {
            return this.numServices;
        }

        public double getGlobalTarget() {
            return this.globalTargetTally;
        }

        public long getEarliestTime() {
            return this.earliestTime;
        }
    }
}

