/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler;

import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.BaseCrawlerInitializationCommand;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class ExportConfiguration
extends BaseCrawlerInitializationCommand {
    public static final String _rcsid = "@(#)$Id: ExportConfiguration.java 988245 2010-08-23 18:39:35Z kwright $";
    private final String exportFilename;
    private final String passCode;

    public ExportConfiguration(String exportFilename, String passCode) {
        this.exportFilename = exportFilename;
        this.passCode = passCode;
    }

    @Override
    protected void doExecute(IThreadContext tc) throws ManifoldCFException {
        ManifoldCF.exportConfiguration(tc, this.exportFilename, this.passCode);
        Logging.root.info((Object)"Configuration exported");
    }

    public static void main(String[] args) {
        if (args.length != 1 && args.length != 2) {
            System.err.println("Usage: ExportConfiguration <filename> [<passcode>]");
            System.exit(1);
        }
        String exportFilename = args[0];
        String passCode = args.length == 2 ? args[1] : null;
        try {
            ExportConfiguration exportConfiguration = new ExportConfiguration(exportFilename, passCode);
            exportConfiguration.execute();
            System.err.println("Configuration exported");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

