/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoCodec;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class AesCtrCryptoCodec
extends CryptoCodec {
    protected static final CipherSuite SUITE = CipherSuite.AES_CTR_NOPADDING;
    private static final int AES_BLOCK_SIZE = SUITE.getAlgorithmBlockSize();
    private static final int CTR_OFFSET = 8;

    @Override
    public CipherSuite getCipherSuite() {
        return SUITE;
    }

    @Override
    public void calculateIV(byte[] initIV, long counter, byte[] IV) {
        Preconditions.checkArgument((initIV.length == AES_BLOCK_SIZE ? 1 : 0) != 0);
        Preconditions.checkArgument((IV.length == AES_BLOCK_SIZE ? 1 : 0) != 0);
        System.arraycopy(initIV, 0, IV, 0, 8);
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l = l << 8 | (long)(initIV[8 + i] & 0xFF);
        }
        IV[8] = (byte)((l += counter) >>> 56);
        IV[9] = (byte)(l >>> 48);
        IV[10] = (byte)(l >>> 40);
        IV[11] = (byte)(l >>> 32);
        IV[12] = (byte)(l >>> 24);
        IV[13] = (byte)(l >>> 16);
        IV[14] = (byte)(l >>> 8);
        IV[15] = (byte)l;
    }
}

