/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HDFSSession {
    private final FileSystem fileSystem;
    private final String nameNode;
    private final Configuration config;
    private final String user;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HDFSSession(String nameNode, String user) throws URISyntaxException, IOException, InterruptedException {
        this.nameNode = nameNode;
        this.user = user;
        ClassLoader ocl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.config = new Configuration();
            this.config.set("fs.defaultFS", nameNode);
            this.fileSystem = FileSystem.get((URI)new URI(nameNode), (Configuration)this.config, (String)user);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ocl);
        }
    }

    public static void runMe() {
    }

    public Map<String, String> getRepositoryInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("Name Node", this.nameNode);
        info.put("Config", this.config.toString());
        info.put("User", this.user);
        info.put("Canonical Service Name", this.fileSystem.getCanonicalServiceName());
        return info;
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        try {
            return this.fileSystem.listStatus(path);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public URI getUri() {
        return this.fileSystem.getUri();
    }

    public FileStatus getObject(Path path) throws IOException {
        try {
            return this.fileSystem.getFileStatus(path);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public FSDataInputStream getFSDataInputStream(Path path) throws IOException {
        try {
            return this.fileSystem.open(path);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public void close() throws IOException {
        this.fileSystem.close();
    }
}

