/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FindHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IHTMLHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.LoginParameters;
import org.apache.manifoldcf.crawler.system.Logging;

public class FindHTMLHrefHandler
extends FindHandler
implements IHTMLHandler {
    protected final Pattern preferredLinkPattern;

    public FindHTMLHrefHandler(String parentURI, Pattern preferredLinkPattern) {
        super(parentURI);
        this.preferredLinkPattern = preferredLinkPattern;
    }

    public void applyOverrides(LoginParameters lp) throws ManifoldCFException {
        if (this.targetURI != null && lp != null && lp.getOverrideTargetURL() != null) {
            super.noteDiscoveredLink(lp.getOverrideTargetURL());
        }
    }

    @Override
    public void noteTextCharacter(char textCharacter) throws ManifoldCFException {
    }

    @Override
    public void noteMetaTag(Map metaAttributes) throws ManifoldCFException {
    }

    @Override
    public void noteFormStart(Map formAttributes) throws ManifoldCFException {
    }

    @Override
    public void noteFormInput(Map inputAttributes) throws ManifoldCFException {
    }

    @Override
    public void noteFormEnd() throws ManifoldCFException {
    }

    @Override
    public void noteDiscoveredLink(String rawURL) throws ManifoldCFException {
        if (this.targetURI == null) {
            Logging.connectors.debug((Object)("WEB: Tried to match raw url '" + rawURL + "'"));
            super.noteDiscoveredLink(rawURL);
            if (this.targetURI != null) {
                boolean canUse;
                Logging.connectors.debug((Object)("WEB: Tried to match cooked url '" + this.targetURI + "'"));
                if (this.preferredLinkPattern != null) {
                    Matcher m = this.preferredLinkPattern.matcher(this.targetURI);
                    canUse = m.find();
                    Logging.connectors.debug((Object)("WEB: Preferred link lookup " + (canUse ? "matched" : "didn't match") + " '" + this.targetURI + "'"));
                } else {
                    Logging.connectors.debug((Object)("WEB: Preferred link lookup for '" + this.targetURI + "' had no pattern to match"));
                    canUse = true;
                }
                if (!canUse) {
                    this.targetURI = null;
                }
            }
        }
    }

    @Override
    public void noteAHREF(String rawURL) throws ManifoldCFException {
        this.noteDiscoveredLink(rawURL);
    }

    @Override
    public void noteLINKHREF(String rawURL) throws ManifoldCFException {
        this.noteDiscoveredLink(rawURL);
    }

    @Override
    public void noteIMGSRC(String rawURL) throws ManifoldCFException {
    }

    @Override
    public void noteFRAMESRC(String rawURL) throws ManifoldCFException {
        this.noteDiscoveredLink(rawURL);
    }

    @Override
    public void finishUp() throws ManifoldCFException {
    }
}

