/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.sorter;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.sorter.Sorter;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;

public abstract class BlockJoinSorter
extends Sorter {
    protected final Filter parentsFilter;

    public BlockJoinSorter(Filter parentsFilter) {
        this.parentsFilter = parentsFilter;
    }

    protected abstract Sorter.DocComparator getParentComparator(AtomicReader var1);

    protected Sorter.DocComparator getChildComparator(AtomicReader reader) {
        return INDEX_ORDER_COMPARATOR;
    }

    @Override
    public final Sorter.DocMap sort(AtomicReader reader) throws IOException {
        DocIdSet parents = this.parentsFilter.getDocIdSet(reader.getContext(), null);
        if (parents == null) {
            throw new IllegalStateException("AtomicReader " + reader + " contains no parents!");
        }
        if (!(parents instanceof FixedBitSet)) {
            throw new IllegalStateException("parentFilter must return FixedBitSet; got " + parents);
        }
        final FixedBitSet parentBits = (FixedBitSet)parents;
        final Sorter.DocComparator parentComparator = this.getParentComparator(reader);
        final Sorter.DocComparator childComparator = this.getChildComparator(reader);
        Sorter.DocComparator comparator = new Sorter.DocComparator(){

            @Override
            public int compare(int docID1, int docID2) {
                int parent2;
                int parent1 = parentBits.nextSetBit(docID1);
                if (parent1 == (parent2 = parentBits.nextSetBit(docID2))) {
                    if (docID1 == parent1 || docID2 == parent2) {
                        return docID1 - docID2;
                    }
                    return childComparator.compare(docID1, docID2);
                }
                int cmp = parentComparator.compare(parent1, parent2);
                if (cmp == 0) {
                    cmp = parent1 - parent2;
                }
                return cmp;
            }
        };
        return BlockJoinSorter.sort(reader.maxDoc(), comparator);
    }
}

