/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.search.type.TransportSearchTypeAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.hppc.IntArrayList;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.fetch.FetchSearchRequest;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchQueryThenFetchAction
extends TransportSearchTypeAction {
    @Inject
    public TransportSearchQueryThenFetchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings, threadPool, clusterService, searchService, searchPhaseController);
    }

    @Override
    protected void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        new AsyncAction(searchRequest, listener).start();
    }

    private class AsyncAction
    extends TransportSearchTypeAction.BaseAsyncAction<QuerySearchResult> {
        final AtomicArray<FetchSearchResult> fetchResults;
        final AtomicArray<IntArrayList> docIdsToLoad;

        private AsyncAction(SearchRequest request, ActionListener<SearchResponse> listener) {
            super(request, listener);
            this.fetchResults = new AtomicArray(this.firstResults.length());
            this.docIdsToLoad = new AtomicArray(this.firstResults.length());
        }

        @Override
        protected String firstPhaseName() {
            return "query";
        }

        @Override
        protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchRequest request, SearchServiceListener<QuerySearchResult> listener) {
            TransportSearchQueryThenFetchAction.this.searchService.sendExecuteQuery(node, request, listener);
        }

        @Override
        protected void moveToSecondPhase() {
            this.sortedShardList = TransportSearchQueryThenFetchAction.this.searchPhaseController.sortDocs(this.firstResults);
            TransportSearchQueryThenFetchAction.this.searchPhaseController.fillDocIdsToLoad(this.docIdsToLoad, this.sortedShardList);
            if (this.docIdsToLoad.asList().isEmpty()) {
                this.finishHim();
                return;
            }
            final AtomicInteger counter = new AtomicInteger(this.docIdsToLoad.asList().size());
            int localOperations = 0;
            for (AtomicArray.Entry<IntArrayList> entry : this.docIdsToLoad.asList()) {
                QuerySearchResult queryResult = (QuerySearchResult)this.firstResults.get(entry.index);
                DiscoveryNode node = this.nodes.get(queryResult.shardTarget().nodeId());
                if (node.id().equals(this.nodes.localNodeId())) {
                    ++localOperations;
                    continue;
                }
                FetchSearchRequest fetchSearchRequest = new FetchSearchRequest(this.request, queryResult.id(), (IntArrayList)entry.value);
                this.executeFetch(entry.index, queryResult.shardTarget(), counter, fetchSearchRequest, node);
            }
            if (localOperations > 0) {
                if (this.request.operationThreading() == SearchOperationThreading.SINGLE_THREAD) {
                    TransportSearchQueryThenFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                        @Override
                        public void run() {
                            for (AtomicArray.Entry<IntArrayList> entry : AsyncAction.this.docIdsToLoad.asList()) {
                                QuerySearchResult queryResult = (QuerySearchResult)AsyncAction.this.firstResults.get(entry.index);
                                DiscoveryNode node = AsyncAction.this.nodes.get(queryResult.shardTarget().nodeId());
                                if (!node.id().equals(AsyncAction.this.nodes.localNodeId())) continue;
                                FetchSearchRequest fetchSearchRequest = new FetchSearchRequest(AsyncAction.this.request, queryResult.id(), (IntArrayList)entry.value);
                                AsyncAction.this.executeFetch(entry.index, queryResult.shardTarget(), counter, fetchSearchRequest, node);
                            }
                        }
                    });
                } else {
                    boolean localAsync = this.request.operationThreading() == SearchOperationThreading.THREAD_PER_SHARD;
                    for (final AtomicArray.Entry<IntArrayList> entry : this.docIdsToLoad.asList()) {
                        final QuerySearchResult queryResult = (QuerySearchResult)this.firstResults.get(entry.index);
                        final DiscoveryNode node = this.nodes.get(queryResult.shardTarget().nodeId());
                        if (!node.id().equals(this.nodes.localNodeId())) continue;
                        final FetchSearchRequest fetchSearchRequest = new FetchSearchRequest(this.request, queryResult.id(), (IntArrayList)entry.value);
                        try {
                            if (localAsync) {
                                TransportSearchQueryThenFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        AsyncAction.this.executeFetch(entry.index, queryResult.shardTarget(), counter, fetchSearchRequest, node);
                                    }
                                });
                                continue;
                            }
                            this.executeFetch(entry.index, queryResult.shardTarget(), counter, fetchSearchRequest, node);
                        }
                        catch (Throwable t) {
                            this.onFetchFailure(t, fetchSearchRequest, entry.index, queryResult.shardTarget(), counter);
                        }
                    }
                }
            }
        }

        void executeFetch(final int shardIndex, final SearchShardTarget shardTarget, final AtomicInteger counter, final FetchSearchRequest fetchSearchRequest, DiscoveryNode node) {
            TransportSearchQueryThenFetchAction.this.searchService.sendExecuteFetch(node, fetchSearchRequest, new SearchServiceListener<FetchSearchResult>(){

                @Override
                public void onResult(FetchSearchResult result) {
                    result.shardTarget(shardTarget);
                    AsyncAction.this.fetchResults.set(shardIndex, result);
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    AsyncAction.this.onFetchFailure(t, fetchSearchRequest, shardIndex, shardTarget, counter);
                }
            });
        }

        void onFetchFailure(Throwable t, FetchSearchRequest fetchSearchRequest, int shardIndex, SearchShardTarget shardTarget, AtomicInteger counter) {
            if (TransportSearchQueryThenFetchAction.this.logger.isDebugEnabled()) {
                TransportSearchQueryThenFetchAction.this.logger.debug("[{}] Failed to execute fetch phase", t, fetchSearchRequest.id());
            }
            this.addShardFailure(shardIndex, shardTarget, t);
            this.successulOps.decrementAndGet();
            if (counter.decrementAndGet() == 0) {
                this.finishHim();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finishHim() {
            try {
                this.innerFinishHim();
            }
            catch (Throwable e) {
                ReduceSearchPhaseException failure = new ReduceSearchPhaseException("fetch", "", e, this.buildShardFailures());
                if (TransportSearchQueryThenFetchAction.this.logger.isDebugEnabled()) {
                    TransportSearchQueryThenFetchAction.this.logger.debug("failed to reduce search", failure, new Object[0]);
                }
                this.listener.onFailure(failure);
            }
            finally {
                this.releaseIrrelevantSearchContexts(this.firstResults, this.docIdsToLoad);
            }
        }

        void innerFinishHim() throws Exception {
            InternalSearchResponse internalResponse = TransportSearchQueryThenFetchAction.this.searchPhaseController.merge(this.sortedShardList, this.firstResults, this.fetchResults);
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = TransportSearchHelper.buildScrollId(this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)this.firstResults, null);
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.expectedSuccessfulOps, this.successulOps.get(), this.buildTookInMillis(), this.buildShardFailures()));
        }
    }
}

