/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;

public class RepositoryMetaData {
    private final String name;
    private final String type;
    private final Settings settings;

    public RepositoryMetaData(String name, String type, Settings settings) {
        this.name = name;
        this.type = type;
        this.settings = settings;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public Settings settings() {
        return this.settings;
    }

    public static RepositoryMetaData readFrom(StreamInput in) throws IOException {
        String name = in.readString();
        String type = in.readString();
        Settings settings = ImmutableSettings.readSettingsFromStream(in);
        return new RepositoryMetaData(name, type, settings);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type);
        ImmutableSettings.writeSettingsToStream(this.settings, out);
    }
}

