/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.packed.AppendingPackedLongBuffer;
import org.apache.lucene.util.packed.MonotonicAppendingLongBuffer;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;

public class MultiOrdinals
implements Ordinals {
    private static final int OFFSETS_PAGE_SIZE = 1024;
    private static final int OFFSET_INIT_PAGE_COUNT = 16;
    private final boolean multiValued;
    private final long numOrds;
    private final MonotonicAppendingLongBuffer endOffsets;
    private final AppendingPackedLongBuffer ords;

    public static boolean significantlySmallerThanSinglePackedOrdinals(int maxDoc, int numDocsWithValue, long numOrds, float acceptableOverheadRatio) {
        int bitsPerOrd = PackedInts.bitsRequired((long)numOrds);
        bitsPerOrd = PackedInts.fastestFormatAndBits((int)numDocsWithValue, (int)bitsPerOrd, (float)acceptableOverheadRatio).bitsPerValue;
        float avgValuesPerDoc = (float)numDocsWithValue / (float)maxDoc;
        int maxDelta = (int)Math.ceil(1024.0f * (1.0f - avgValuesPerDoc) * avgValuesPerDoc);
        int bitsPerOffset = PackedInts.bitsRequired((long)maxDelta) + 1;
        bitsPerOffset = PackedInts.fastestFormatAndBits((int)maxDoc, (int)bitsPerOffset, (float)acceptableOverheadRatio).bitsPerValue;
        long expectedMultiSizeInBytes = (long)numDocsWithValue * (long)bitsPerOrd + (long)maxDoc * (long)bitsPerOffset;
        long expectedSingleSizeInBytes = (long)maxDoc * (long)bitsPerOrd;
        return (float)expectedMultiSizeInBytes < 0.8f * (float)expectedSingleSizeInBytes;
    }

    public MultiOrdinals(OrdinalsBuilder builder, float acceptableOverheadRatio) {
        this.multiValued = builder.getNumMultiValuesDocs() > 0;
        this.numOrds = builder.getNumOrds();
        this.endOffsets = new MonotonicAppendingLongBuffer(16, 1024, acceptableOverheadRatio);
        this.ords = new AppendingPackedLongBuffer(16, 1024, acceptableOverheadRatio);
        long lastEndOffset = 0L;
        for (int i = 0; i < builder.maxDoc(); ++i) {
            LongsRef docOrds = builder.docOrds(i);
            long endOffset = lastEndOffset + (long)docOrds.length;
            this.endOffsets.add(endOffset);
            for (int j = 0; j < docOrds.length; ++j) {
                this.ords.add(docOrds.longs[docOrds.offset + j] - 1L);
            }
            lastEndOffset = endOffset;
        }
        assert (this.endOffsets.size() == (long)builder.maxDoc());
        assert (this.ords.size() == (long)builder.getTotalNumOrds()) : this.ords.size() + " != " + builder.getTotalNumOrds();
    }

    @Override
    public long getMemorySizeInBytes() {
        return this.endOffsets.ramBytesUsed() + this.ords.ramBytesUsed();
    }

    @Override
    public boolean isMultiValued() {
        return this.multiValued;
    }

    @Override
    public int getNumDocs() {
        return (int)this.endOffsets.size();
    }

    @Override
    public long getNumOrds() {
        return this.numOrds;
    }

    @Override
    public long getMaxOrd() {
        return this.numOrds + 1L;
    }

    @Override
    public Ordinals.Docs ordinals() {
        return new MultiDocs(this);
    }

    static class MultiDocs
    implements Ordinals.Docs {
        private final MultiOrdinals ordinals;
        private final MonotonicAppendingLongBuffer endOffsets;
        private final AppendingPackedLongBuffer ords;
        private final LongsRef longsScratch;
        private long offset;
        private long limit;
        private long currentOrd;

        MultiDocs(MultiOrdinals ordinals) {
            this.ordinals = ordinals;
            this.endOffsets = ordinals.endOffsets;
            this.ords = ordinals.ords;
            this.longsScratch = new LongsRef(16);
        }

        @Override
        public Ordinals ordinals() {
            return this.ordinals;
        }

        @Override
        public int getNumDocs() {
            return this.ordinals.getNumDocs();
        }

        @Override
        public long getNumOrds() {
            return this.ordinals.getNumOrds();
        }

        @Override
        public long getMaxOrd() {
            return this.ordinals.getMaxOrd();
        }

        @Override
        public boolean isMultiValued() {
            return this.ordinals.isMultiValued();
        }

        @Override
        public long getOrd(int docId) {
            long endOffset;
            long startOffset = docId > 0 ? this.endOffsets.get(docId - 1) : 0L;
            if (startOffset == (endOffset = this.endOffsets.get(docId))) {
                this.currentOrd = 0L;
                return 0L;
            }
            this.currentOrd = 1L + this.ords.get(startOffset);
            return this.currentOrd;
        }

        @Override
        public LongsRef getOrds(int docId) {
            long startOffset = docId > 0 ? this.endOffsets.get(docId - 1) : 0L;
            long endOffset = this.endOffsets.get(docId);
            int numValues = (int)(endOffset - startOffset);
            if (this.longsScratch.length < numValues) {
                this.longsScratch.longs = new long[ArrayUtil.oversize((int)numValues, (int)8)];
            }
            for (int i = 0; i < numValues; ++i) {
                this.longsScratch.longs[i] = 1L + this.ords.get(startOffset + (long)i);
            }
            this.longsScratch.offset = 0;
            this.longsScratch.length = numValues;
            return this.longsScratch;
        }

        @Override
        public long nextOrd() {
            assert (this.offset < this.limit);
            this.currentOrd = 1L + this.ords.get(this.offset++);
            return this.currentOrd;
        }

        @Override
        public int setDocument(int docId) {
            long startOffset = docId > 0 ? this.endOffsets.get(docId - 1) : 0L;
            long endOffset = this.endOffsets.get(docId);
            this.offset = startOffset;
            this.limit = endOffset;
            return (int)(endOffset - startOffset);
        }

        @Override
        public long currentOrd() {
            return this.currentOrd;
        }
    }
}

