/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node.internal;

import java.util.Map;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.Names;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.FailedToResolveConfigException;

public class InternalSettingsPreparer {
    public static Tuple<Settings, Environment> prepareSettings(Settings pSettings, boolean loadConfigSettings) {
        String[] ignorePrefixes = new String[]{"es.default.", "elasticsearch.default."};
        boolean useSystemProperties = pSettings.getAsBoolean("config.ignore_system_properties", (Boolean)false) == false;
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder().put(pSettings);
        if (useSystemProperties) {
            settingsBuilder.putProperties("elasticsearch.default.", System.getProperties()).putProperties("es.default.", System.getProperties()).putProperties("elasticsearch.", System.getProperties(), ignorePrefixes).putProperties("es.", System.getProperties(), ignorePrefixes);
        }
        settingsBuilder.replacePropertyPlaceholders();
        Environment environment = new Environment(settingsBuilder.build());
        if (loadConfigSettings) {
            boolean loadFromEnv = true;
            if (useSystemProperties) {
                if (Strings.hasText(System.getProperty("es.default.config"))) {
                    loadFromEnv = true;
                    settingsBuilder.loadFromUrl(environment.resolveConfig(System.getProperty("es.default.config")));
                }
                if (Strings.hasText(System.getProperty("es.config"))) {
                    loadFromEnv = false;
                    settingsBuilder.loadFromUrl(environment.resolveConfig(System.getProperty("es.config")));
                }
                if (Strings.hasText(System.getProperty("elasticsearch.config"))) {
                    loadFromEnv = false;
                    settingsBuilder.loadFromUrl(environment.resolveConfig(System.getProperty("elasticsearch.config")));
                }
            }
            if (loadFromEnv) {
                try {
                    settingsBuilder.loadFromUrl(environment.resolveConfig("elasticsearch.yml"));
                }
                catch (FailedToResolveConfigException e) {
                }
                catch (NoClassDefFoundError e) {
                    // empty catch block
                }
                try {
                    settingsBuilder.loadFromUrl(environment.resolveConfig("elasticsearch.json"));
                }
                catch (FailedToResolveConfigException e) {
                    // empty catch block
                }
                try {
                    settingsBuilder.loadFromUrl(environment.resolveConfig("elasticsearch.properties"));
                }
                catch (FailedToResolveConfigException e) {
                    // empty catch block
                }
            }
        }
        settingsBuilder.put(pSettings);
        if (useSystemProperties) {
            settingsBuilder.putProperties("elasticsearch.", System.getProperties(), ignorePrefixes).putProperties("es.", System.getProperties(), ignorePrefixes);
        }
        settingsBuilder.replacePropertyPlaceholders();
        for (Map.Entry entry : pSettings.getAsMap().entrySet()) {
            String setting = (String)entry.getKey();
            if (!setting.startsWith("force.")) continue;
            settingsBuilder.remove(setting);
            settingsBuilder.put(setting.substring(".force".length()), (String)entry.getValue());
        }
        settingsBuilder.replacePropertyPlaceholders();
        if (settingsBuilder.get("name") == null) {
            String name = System.getProperty("name");
            if ((name == null || name.isEmpty()) && ((name = settingsBuilder.get("node.name")) == null || name.isEmpty())) {
                name = Names.randomNodeName(environment.resolveConfig("names.txt"));
            }
            if (name != null) {
                settingsBuilder.put("name", name);
            }
        }
        if (settingsBuilder.get("cluster.name") == null) {
            settingsBuilder.put("cluster.name", ClusterName.DEFAULT.value());
        }
        Settings v1 = settingsBuilder.build();
        environment = new Environment(v1);
        settingsBuilder = ImmutableSettings.settingsBuilder().put(v1);
        settingsBuilder.put("path.logs", Strings.cleanPath(environment.logsFile().getAbsolutePath()));
        v1 = settingsBuilder.build();
        return new Tuple<Settings, Environment>(v1, environment);
    }
}

