/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.hppc.FloatArrayList;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.HashedBytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.FilteredCollector;
import org.elasticsearch.common.lucene.search.XCollector;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.percolator.PercolateContext;
import org.elasticsearch.search.aggregations.AggregationPhase;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.bucket.global.GlobalAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.facet.SearchContextFacets;
import org.elasticsearch.search.facet.nested.NestedFacetExecutor;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.highlight.HighlightPhase;

abstract class QueryCollector
extends Collector {
    final IndexFieldData<?> idFieldData;
    final IndexSearcher searcher;
    final ConcurrentMap<HashedBytesRef, Query> queries;
    final ESLogger logger;
    final Lucene.ExistsCollector collector = new Lucene.ExistsCollector();
    final HashedBytesRef spare = new HashedBytesRef(new BytesRef());
    BytesValues values;
    final List<Collector> facetCollectors = new ArrayList<Collector>();
    final Collector facetAndAggregatorCollector;

    QueryCollector(ESLogger logger, PercolateContext context) {
        int size;
        this.logger = logger;
        this.queries = context.percolateQueries();
        this.searcher = context.docSearcher();
        FieldMapper idMapper = context.mapperService().smartNameFieldMapper("_id");
        this.idFieldData = context.fieldData().getForField(idMapper);
        if (context.facets() != null) {
            for (SearchContextFacets.Entry entry : context.facets().entries()) {
                if (entry.isGlobal()) continue;
                XCollector collector = entry.getFacetExecutor().collector();
                if (entry.getFilter() != null) {
                    collector = collector instanceof NestedFacetExecutor.Collector ? new NestedFacetExecutor.Collector((NestedFacetExecutor.Collector)collector, entry.getFilter()) : new FilteredCollector(collector, entry.getFilter());
                }
                this.facetCollectors.add(collector);
            }
        }
        ArrayList<Collector> collectors = new ArrayList<Collector>(this.facetCollectors);
        if (context.aggregations() != null) {
            AggregationContext aggregationContext = new AggregationContext(context);
            context.aggregations().aggregationContext(aggregationContext);
            ArrayList<Aggregator> aggregatorCollectors = new ArrayList<Aggregator>();
            Aggregator[] aggregators = context.aggregations().factories().createTopLevelAggregators(aggregationContext);
            for (int i = 0; i < aggregators.length; ++i) {
                Aggregator aggregator;
                if (aggregators[i] instanceof GlobalAggregator || !(aggregator = aggregators[i]).shouldCollect()) continue;
                aggregatorCollectors.add(aggregator);
            }
            context.aggregations().aggregators(aggregators);
            if (!aggregatorCollectors.isEmpty()) {
                collectors.add(new AggregationPhase.AggregationsCollector(aggregatorCollectors, aggregationContext));
            }
        }
        this.facetAndAggregatorCollector = (size = collectors.size()) == 0 ? null : (size == 1 ? (Collector)collectors.get(0) : MultiCollector.wrap((Collector[])collectors.toArray(new Collector[collectors.size()])));
    }

    public void setScorer(Scorer scorer) throws IOException {
        if (this.facetAndAggregatorCollector != null) {
            this.facetAndAggregatorCollector.setScorer(scorer);
        }
    }

    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.values = this.idFieldData.load(context).getBytesValues(true);
        if (this.facetAndAggregatorCollector != null) {
            this.facetAndAggregatorCollector.setNextReader(context);
        }
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    static Match match(ESLogger logger, PercolateContext context, HighlightPhase highlightPhase) {
        return new Match(logger, context, highlightPhase);
    }

    static Count count(ESLogger logger, PercolateContext context) {
        return new Count(logger, context);
    }

    static MatchAndScore matchAndScore(ESLogger logger, PercolateContext context, HighlightPhase highlightPhase) {
        return new MatchAndScore(logger, context, highlightPhase);
    }

    static MatchAndSort matchAndSort(ESLogger logger, PercolateContext context) {
        return new MatchAndSort(logger, context);
    }

    protected final Query getQuery(int doc) {
        int numValues = this.values.setDocument(doc);
        if (numValues == 0) {
            return null;
        }
        assert (numValues == 1);
        this.spare.reset(this.values.nextValue(), this.values.currentValueHash());
        return (Query)this.queries.get(this.spare);
    }

    static final class Count
    extends QueryCollector {
        private long counter = 0L;

        Count(ESLogger logger, PercolateContext context) {
            super(logger, context);
        }

        public void collect(int doc) throws IOException {
            Query query = this.getQuery(doc);
            if (query == null) {
                return;
            }
            try {
                this.collector.reset();
                this.searcher.search(query, (Collector)this.collector);
                if (this.collector.exists()) {
                    ++this.counter;
                    if (this.facetAndAggregatorCollector != null) {
                        this.facetAndAggregatorCollector.collect(doc);
                    }
                }
            }
            catch (IOException e) {
                this.logger.warn("[" + this.spare.bytes.utf8ToString() + "] failed to execute query", e, new Object[0]);
            }
        }

        long counter() {
            return this.counter;
        }
    }

    static final class MatchAndScore
    extends QueryCollector {
        final PercolateContext context;
        final HighlightPhase highlightPhase;
        final List<BytesRef> matches = new ArrayList<BytesRef>();
        final List<Map<String, HighlightField>> hls = new ArrayList<Map<String, HighlightField>>();
        final FloatArrayList scores = new FloatArrayList();
        final boolean limit;
        final int size;
        long counter = 0L;
        private Scorer scorer;

        MatchAndScore(ESLogger logger, PercolateContext context, HighlightPhase highlightPhase) {
            super(logger, context);
            this.limit = context.limit;
            this.size = context.size;
            this.context = context;
            this.highlightPhase = highlightPhase;
        }

        public void collect(int doc) throws IOException {
            Query query = this.getQuery(doc);
            if (query == null) {
                return;
            }
            try {
                this.collector.reset();
                if (this.context.highlight() != null) {
                    this.context.parsedQuery(new ParsedQuery(query, ImmutableMap.<String, Filter>of()));
                    this.context.hitContext().cache().clear();
                }
                this.searcher.search(query, (Collector)this.collector);
                if (this.collector.exists()) {
                    if (!this.limit || this.counter < (long)this.size) {
                        this.matches.add(this.values.copyShared());
                        this.scores.add(this.scorer.score());
                        if (this.context.highlight() != null) {
                            this.highlightPhase.hitExecute(this.context, this.context.hitContext());
                            this.hls.add(this.context.hitContext().hit().getHighlightFields());
                        }
                    }
                    ++this.counter;
                    if (this.facetAndAggregatorCollector != null) {
                        this.facetAndAggregatorCollector.collect(doc);
                    }
                }
            }
            catch (IOException e) {
                this.logger.warn("[" + this.spare.bytes.utf8ToString() + "] failed to execute query", e, new Object[0]);
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        long counter() {
            return this.counter;
        }

        List<BytesRef> matches() {
            return this.matches;
        }

        FloatArrayList scores() {
            return this.scores;
        }

        List<Map<String, HighlightField>> hls() {
            return this.hls;
        }
    }

    static final class MatchAndSort
    extends QueryCollector {
        private final TopScoreDocCollector topDocsCollector;

        MatchAndSort(ESLogger logger, PercolateContext context) {
            super(logger, context);
            this.topDocsCollector = TopScoreDocCollector.create((int)context.size, (boolean)false);
        }

        public void collect(int doc) throws IOException {
            Query query = this.getQuery(doc);
            if (query == null) {
                return;
            }
            try {
                this.collector.reset();
                this.searcher.search(query, (Collector)this.collector);
                if (this.collector.exists()) {
                    this.topDocsCollector.collect(doc);
                    if (this.facetAndAggregatorCollector != null) {
                        this.facetAndAggregatorCollector.collect(doc);
                    }
                }
            }
            catch (IOException e) {
                this.logger.warn("[" + this.spare.bytes.utf8ToString() + "] failed to execute query", e, new Object[0]);
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            super.setNextReader(context);
            this.topDocsCollector.setNextReader(context);
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.topDocsCollector.setScorer(scorer);
        }

        TopDocs topDocs() {
            return this.topDocsCollector.topDocs();
        }
    }

    static final class Match
    extends QueryCollector {
        final PercolateContext context;
        final HighlightPhase highlightPhase;
        final List<BytesRef> matches = new ArrayList<BytesRef>();
        final List<Map<String, HighlightField>> hls = new ArrayList<Map<String, HighlightField>>();
        final boolean limit;
        final int size;
        long counter = 0L;

        Match(ESLogger logger, PercolateContext context, HighlightPhase highlightPhase) {
            super(logger, context);
            this.limit = context.limit;
            this.size = context.size;
            this.context = context;
            this.highlightPhase = highlightPhase;
        }

        public void collect(int doc) throws IOException {
            Query query = this.getQuery(doc);
            if (query == null) {
                return;
            }
            try {
                this.collector.reset();
                if (this.context.highlight() != null) {
                    this.context.parsedQuery(new ParsedQuery(query, ImmutableMap.<String, Filter>of()));
                    this.context.hitContext().cache().clear();
                }
                this.searcher.search(query, (Collector)this.collector);
                if (this.collector.exists()) {
                    if (!this.limit || this.counter < (long)this.size) {
                        this.matches.add(this.values.copyShared());
                        if (this.context.highlight() != null) {
                            this.highlightPhase.hitExecute(this.context, this.context.hitContext());
                            this.hls.add(this.context.hitContext().hit().getHighlightFields());
                        }
                    }
                    ++this.counter;
                    if (this.facetAndAggregatorCollector != null) {
                        this.facetAndAggregatorCollector.collect(doc);
                    }
                }
            }
            catch (IOException e) {
                this.logger.warn("[" + this.spare.bytes.utf8ToString() + "] failed to execute query", e, new Object[0]);
            }
        }

        long counter() {
            return this.counter;
        }

        List<BytesRef> matches() {
            return this.matches;
        }

        List<Map<String, HighlightField>> hls() {
            return this.hls;
        }
    }
}

