/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.rest.AbstractRestResponse;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class Utf8RestResponse
extends AbstractRestResponse
implements RestResponse {
    public static final BytesRef EMPTY = new BytesRef();
    private final RestStatus status;
    private final BytesRef utf8Result;
    private final BytesRef prefixUtf8Result;
    private final BytesRef suffixUtf8Result;

    public Utf8RestResponse(RestStatus status) {
        this(status, EMPTY);
    }

    public Utf8RestResponse(RestStatus status, BytesRef utf8Result) {
        this(status, utf8Result, null, null);
    }

    public Utf8RestResponse(RestStatus status, BytesRef utf8Result, BytesRef prefixUtf8Result, BytesRef suffixUtf8Result) {
        this.status = status;
        this.utf8Result = utf8Result;
        this.prefixUtf8Result = prefixUtf8Result;
        this.suffixUtf8Result = suffixUtf8Result;
    }

    @Override
    public boolean contentThreadSafe() {
        return true;
    }

    @Override
    public String contentType() {
        return "text/plain; charset=UTF-8";
    }

    @Override
    public byte[] content() {
        return this.utf8Result.bytes;
    }

    @Override
    public int contentLength() {
        return this.utf8Result.length;
    }

    @Override
    public int contentOffset() {
        return this.utf8Result.offset;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    @Override
    public byte[] prefixContent() {
        return this.prefixUtf8Result != null ? this.prefixUtf8Result.bytes : null;
    }

    @Override
    public int prefixContentLength() {
        return this.prefixUtf8Result != null ? this.prefixUtf8Result.length : 0;
    }

    @Override
    public int prefixContentOffset() {
        return this.prefixUtf8Result != null ? this.prefixUtf8Result.offset : 0;
    }

    @Override
    public byte[] suffixContent() {
        return this.suffixUtf8Result != null ? this.suffixUtf8Result.bytes : null;
    }

    @Override
    public int suffixContentLength() {
        return this.suffixUtf8Result != null ? this.suffixUtf8Result.length : 0;
    }

    @Override
    public int suffixContentOffset() {
        return this.suffixUtf8Result != null ? this.suffixUtf8Result.offset : 0;
    }
}

