/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.alias.get;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestGetAliasesAction
extends BaseRestHandler {
    @Inject
    public RestGetAliasesAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_alias/", this);
        controller.registerHandler(RestRequest.Method.GET, "/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_alias", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        String[] aliases = request.paramAsStringArrayOrEmptyIfAll("name");
        final String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        final GetAliasesRequest getAliasesRequest = new GetAliasesRequest(aliases);
        getAliasesRequest.indices(indices);
        getAliasesRequest.indicesOptions(IndicesOptions.fromRequest(request, getAliasesRequest.indicesOptions()));
        getAliasesRequest.local(request.paramAsBoolean("local", getAliasesRequest.local()));
        this.client.admin().indices().getAliases(getAliasesRequest, new ActionListener<GetAliasesResponse>(){

            @Override
            public void onResponse(GetAliasesResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    if (indices.length > 0 && response.getAliases().isEmpty()) {
                        channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, RestXContentBuilder.emptyBuilder(request)));
                        return;
                    }
                    if (response.getAliases().isEmpty()) {
                        String message = String.format(Locale.ROOT, "alias [%s] missing", RestGetAliasesAction.toNamesString(getAliasesRequest.aliases()));
                        builder.startObject().field("error", message).field("status", RestStatus.NOT_FOUND.getStatus()).endObject();
                        channel.sendResponse(new XContentRestResponse(request, RestStatus.NOT_FOUND, builder));
                        return;
                    }
                    builder.startObject();
                    for (ObjectObjectCursor<String, List<AliasMetaData>> objectObjectCursor : response.getAliases()) {
                        builder.startObject((String)objectObjectCursor.key, XContentBuilder.FieldCaseConversion.NONE);
                        builder.startObject(Fields.ALIASES);
                        for (AliasMetaData alias : (List)objectObjectCursor.value) {
                            AliasMetaData.Builder.toXContent(alias, builder, ToXContent.EMPTY_PARAMS);
                        }
                        builder.endObject();
                        builder.endObject();
                    }
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestGetAliasesAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }

    private static String toNamesString(String ... names) {
        if (names == null || names.length == 0) {
            return "";
        }
        if (names.length == 1) {
            return names[0];
        }
        StringBuilder builder = new StringBuilder(names[0]);
        for (int i = 1; i < names.length; ++i) {
            builder.append(',').append(names[i]);
        }
        return builder.toString();
    }

    static class Fields {
        static final XContentBuilderString ALIASES = new XContentBuilderString("aliases");

        Fields() {
        }
    }
}

