/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.elasticsearch;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchParam;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class ElasticSearchConfig
extends ElasticSearchParam {
    private static final long serialVersionUID = -2071296573398352538L;
    private static final ElasticSearchParam.ParameterEnum[] CONFIGURATIONLIST = new ElasticSearchParam.ParameterEnum[]{ElasticSearchParam.ParameterEnum.SERVERLOCATION, ElasticSearchParam.ParameterEnum.USERNAME, ElasticSearchParam.ParameterEnum.PASSWORD, ElasticSearchParam.ParameterEnum.SERVERKEYSTORE, ElasticSearchParam.ParameterEnum.INDEXNAME, ElasticSearchParam.ParameterEnum.INDEXTYPE, ElasticSearchParam.ParameterEnum.USEINGESTATTACHMENT, ElasticSearchParam.ParameterEnum.USEMAPPERATTACHMENTS, ElasticSearchParam.ParameterEnum.PIPELINENAME, ElasticSearchParam.ParameterEnum.CONTENTATTRIBUTENAME, ElasticSearchParam.ParameterEnum.URIATTRIBUTENAME, ElasticSearchParam.ParameterEnum.CREATEDDATEATTRIBUTENAME, ElasticSearchParam.ParameterEnum.MODIFIEDDATEATTRIBUTENAME, ElasticSearchParam.ParameterEnum.INDEXINGDATEATTRIBUTENAME, ElasticSearchParam.ParameterEnum.MIMETYPEATTRIBUTENAME};

    public ElasticSearchConfig(ConfigParams params) {
        super(CONFIGURATIONLIST);
        for (ElasticSearchParam.ParameterEnum param : CONFIGURATIONLIST) {
            boolean isPassword = param.name().endsWith("PASSWORD");
            if (isPassword) {
                this.put(param, params.getObfuscatedParameter(param.name()), param.defaultValue);
                continue;
            }
            this.put(param, params.getParameter(param.name()), param.defaultValue);
        }
    }

    private void put(ElasticSearchParam.ParameterEnum param, String value, String defaultValue) {
        if (value == null) {
            this.put(param, defaultValue);
        } else {
            this.put(param, value);
        }
    }

    public String getUniqueIndexIdentifier() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getServerLocation());
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append(this.getIndexName());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String contextToConfig(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String useMapperAttachmentsPresent;
        String rval = null;
        for (ElasticSearchParam.ParameterEnum param : CONFIGURATIONLIST) {
            String paramName = param.name().toLowerCase(Locale.ROOT);
            boolean isPassword = param.name().endsWith("PASSWORD");
            boolean isKeystore = param.name().endsWith("KEYSTORE");
            if (isKeystore) {
                String keystoreValue = variableContext.getParameter(paramName);
                IKeystoreManager mgr = keystoreValue != null && keystoreValue.length() > 0 ? KeystoreManagerFactory.make((String)"", (String)keystoreValue) : KeystoreManagerFactory.make((String)"");
                String configOp = variableContext.getParameter(paramName + "_op");
                if (configOp != null) {
                    String alias;
                    if (configOp.equals("Delete")) {
                        alias = variableContext.getParameter(paramName + "_alias");
                        mgr.remove(alias);
                    } else if (configOp.equals("Add")) {
                        alias = IDFactory.make((IThreadContext)threadContext);
                        byte[] certificateValue = variableContext.getBinaryBytes(paramName + "_certificate");
                        ByteArrayInputStream is = new ByteArrayInputStream(certificateValue);
                        String certError = null;
                        try {
                            mgr.importCertificate(alias, (InputStream)is);
                        }
                        catch (Throwable e) {
                            certError = e.getMessage();
                        }
                        finally {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (certError != null) {
                            rval = "Illegal certificate: " + certError;
                        }
                    }
                }
                parameters.setParameter(param.name(), mgr.getString());
                continue;
            }
            String p = variableContext.getParameter(paramName);
            if (p == null) continue;
            if (isPassword) {
                parameters.setObfuscatedParameter(param.name(), variableContext.mapKeyToPassword(p));
                continue;
            }
            parameters.setParameter(param.name(), p);
        }
        String useIngestAttachmentPresent = variableContext.getParameter("useingestattachment_present");
        if (useIngestAttachmentPresent != null) {
            String useIngestAttachment = variableContext.getParameter(ElasticSearchParam.ParameterEnum.USEINGESTATTACHMENT.name().toLowerCase(Locale.ROOT));
            if (useIngestAttachment == null || useIngestAttachment.length() == 0) {
                useIngestAttachment = "false";
            }
            parameters.setParameter(ElasticSearchParam.ParameterEnum.USEINGESTATTACHMENT.name(), useIngestAttachment);
        }
        if ((useMapperAttachmentsPresent = variableContext.getParameter("usemapperattachments_present")) != null) {
            String useMapperAttachments = variableContext.getParameter(ElasticSearchParam.ParameterEnum.USEMAPPERATTACHMENTS.name().toLowerCase(Locale.ROOT));
            if (useMapperAttachments == null || useMapperAttachments.length() == 0) {
                useMapperAttachments = "false";
            }
            parameters.setParameter(ElasticSearchParam.ParameterEnum.USEMAPPERATTACHMENTS.name(), useMapperAttachments);
        }
        return rval;
    }

    public final String getServerLocation() {
        return (String)this.get((Object)ElasticSearchParam.ParameterEnum.SERVERLOCATION);
    }

    public final String getUserName() {
        return (String)this.get((Object)ElasticSearchParam.ParameterEnum.USERNAME);
    }

    public final String getPassword() {
        return (String)this.get((Object)ElasticSearchParam.ParameterEnum.PASSWORD);
    }

    public final IKeystoreManager getSSLKeystore() throws ManifoldCFException {
        String packedKeystore = (String)this.get((Object)ElasticSearchParam.ParameterEnum.SERVERKEYSTORE);
        if (packedKeystore == null || packedKeystore.length() == 0) {
            return null;
        }
        return KeystoreManagerFactory.make((String)"", (String)packedKeystore);
    }

    public final String getIndexName() {
        return (String)this.get((Object)ElasticSearchParam.ParameterEnum.INDEXNAME);
    }

    public final String getIndexType() {
        return (String)this.get((Object)ElasticSearchParam.ParameterEnum.INDEXTYPE);
    }

    public final Boolean getUseIngestAttachment() {
        return Boolean.valueOf((String)this.get((Object)ElasticSearchParam.ParameterEnum.USEINGESTATTACHMENT));
    }

    public final Boolean getUseMapperAttachments() {
        return Boolean.valueOf((String)this.get((Object)ElasticSearchParam.ParameterEnum.USEMAPPERATTACHMENTS));
    }

    public final String getPipelineName() {
        return (String)this.get((Object)ElasticSearchParam.ParameterEnum.PIPELINENAME);
    }

    public final String getContentAttributeName() {
        return (String)this.get((Object)ElasticSearchParam.ParameterEnum.CONTENTATTRIBUTENAME);
    }

    public final String getUriAttributeName() {
        return (String)this.get((Object)ElasticSearchParam.ParameterEnum.URIATTRIBUTENAME);
    }

    public final String getCreatedDateAttributeName() {
        return (String)this.get((Object)ElasticSearchParam.ParameterEnum.CREATEDDATEATTRIBUTENAME);
    }

    public final String getModifiedDateAttributeName() {
        return (String)this.get((Object)ElasticSearchParam.ParameterEnum.MODIFIEDDATEATTRIBUTENAME);
    }

    public final String getIndexingDateAttributeName() {
        return (String)this.get((Object)ElasticSearchParam.ParameterEnum.INDEXINGDATEATTRIBUTENAME);
    }

    public final String getMimeTypeAttributeName() {
        return (String)this.get((Object)ElasticSearchParam.ParameterEnum.MIMETYPEATTRIBUTENAME);
    }
}

