/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.alias;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;

@InterfaceAudience.Private
public class JavaKeyStoreProvider
extends CredentialProvider {
    public static final String SCHEME_NAME = "jceks";
    public static final String CREDENTIAL_PASSWORD_NAME = "HADOOP_CREDSTORE_PASSWORD";
    public static final String KEYSTORE_PASSWORD_FILE_KEY = "hadoop.security.credstore.java-keystore-provider.password-file";
    public static final String KEYSTORE_PASSWORD_DEFAULT = "none";
    private final URI uri;
    private final Path path;
    private final FileSystem fs;
    private final FsPermission permissions;
    private final KeyStore keyStore;
    private char[] password = null;
    private boolean changed = false;
    private Lock readLock;
    private Lock writeLock;
    private final Map<String, CredentialProvider.CredentialEntry> cache = new HashMap<String, CredentialProvider.CredentialEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaKeyStoreProvider(URI uri, Configuration conf) throws IOException {
        ClassLoader cl;
        URL pwdFile;
        String pwFile;
        this.uri = uri;
        this.path = ProviderUtils.unnestUri(uri);
        this.fs = this.path.getFileSystem(conf);
        if (System.getenv().containsKey(CREDENTIAL_PASSWORD_NAME)) {
            this.password = System.getenv(CREDENTIAL_PASSWORD_NAME).toCharArray();
        }
        if (this.password == null && (pwFile = conf.get(KEYSTORE_PASSWORD_FILE_KEY)) != null && (pwdFile = (cl = Thread.currentThread().getContextClassLoader()).getResource(pwFile)) != null) {
            InputStream is = pwdFile.openStream();
            try {
                this.password = IOUtils.toString((InputStream)is).trim().toCharArray();
            }
            finally {
                is.close();
            }
        }
        if (this.password == null) {
            this.password = KEYSTORE_PASSWORD_DEFAULT.toCharArray();
        }
        try {
            this.keyStore = KeyStore.getInstance(SCHEME_NAME);
            if (this.fs.exists(this.path)) {
                FileStatus s = this.fs.getFileStatus(this.path);
                this.permissions = s.getPermission();
                this.keyStore.load(this.fs.open(this.path), this.password);
            } else {
                this.permissions = new FsPermission("700");
                this.keyStore.load(null, this.password);
            }
        }
        catch (KeyStoreException e) {
            throw new IOException("Can't create keystore", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Can't load keystore " + this.path, e);
        }
        catch (CertificateException e) {
            throw new IOException("Can't load keystore " + this.path, e);
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CredentialProvider.CredentialEntry getCredentialEntry(String alias) throws IOException {
        this.readLock.lock();
        try {
            SecretKeySpec key;
            block11: {
                key = null;
                if (!this.cache.containsKey(alias)) break block11;
                CredentialProvider.CredentialEntry credentialEntry = this.cache.get(alias);
                return credentialEntry;
            }
            if (!this.keyStore.containsAlias(alias)) {
                CredentialProvider.CredentialEntry credentialEntry = null;
                return credentialEntry;
            }
            try {
                key = (SecretKeySpec)this.keyStore.getKey(alias, this.password);
            }
            catch (KeyStoreException e) {
                throw new IOException("Can't get credential " + alias + " from " + this.path, e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("Can't get algorithm for credential " + alias + " from " + this.path, e);
            }
            catch (UnrecoverableKeyException e) {
                throw new IOException("Can't recover credential " + alias + " from " + this.path, e);
            }
            CredentialProvider.CredentialEntry credentialEntry = new CredentialProvider.CredentialEntry(alias, JavaKeyStoreProvider.bytesToChars(key.getEncoded()));
            return credentialEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static char[] bytesToChars(byte[] bytes) {
        String pass = new String(bytes);
        return pass.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAliases() throws IOException {
        this.readLock.lock();
        try {
            ArrayList<String> list = new ArrayList<String>();
            String alias = null;
            try {
                Enumeration<String> e = this.keyStore.aliases();
                while (e.hasMoreElements()) {
                    alias = e.nextElement();
                    list.add(alias);
                }
            }
            catch (KeyStoreException e) {
                throw new IOException("Can't get alias " + alias + " from " + this.path, e);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public CredentialProvider.CredentialEntry createCredentialEntry(String alias, char[] credential) throws IOException {
        this.writeLock.lock();
        try {
            if (this.keyStore.containsAlias(alias) || this.cache.containsKey(alias)) {
                throw new IOException("Credential " + alias + " already exists in " + this);
            }
            CredentialProvider.CredentialEntry credentialEntry = this.innerSetCredential(alias, credential);
            return credentialEntry;
        }
        catch (KeyStoreException e) {
            throw new IOException("Problem looking up credential " + alias + " in " + this, e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCredentialEntry(String name) throws IOException {
        this.writeLock.lock();
        try {
            try {
                if (!this.keyStore.containsAlias(name)) {
                    throw new IOException("Credential " + name + " does not exist in " + this);
                }
                this.keyStore.deleteEntry(name);
            }
            catch (KeyStoreException e) {
                throw new IOException("Problem removing " + name + " from " + this, e);
            }
            this.cache.remove(name);
            this.changed = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    CredentialProvider.CredentialEntry innerSetCredential(String alias, char[] material) throws IOException {
        this.writeLock.lock();
        try {
            this.keyStore.setKeyEntry(alias, new SecretKeySpec(new String(material).getBytes("UTF-8"), "AES"), this.password, null);
        }
        catch (KeyStoreException e) {
            throw new IOException("Can't store credential " + alias + " in " + this, e);
        }
        finally {
            this.writeLock.unlock();
        }
        this.changed = true;
        return new CredentialProvider.CredentialEntry(alias, material);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        this.writeLock.lock();
        try {
            if (!this.changed) {
                return;
            }
            FSDataOutputStream out = FileSystem.create(this.fs, this.path, this.permissions);
            try {
                this.keyStore.store(out, this.password);
            }
            catch (KeyStoreException e) {
                throw new IOException("Can't store keystore " + this, e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("No such algorithm storing keystore " + this, e);
            }
            catch (CertificateException e) {
                throw new IOException("Certificate exception storing keystore " + this, e);
            }
            out.close();
            this.changed = false;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String toString() {
        return this.uri.toString();
    }

    public static class Factory
    extends CredentialProviderFactory {
        @Override
        public CredentialProvider createProvider(URI providerName, Configuration conf) throws IOException {
            if (JavaKeyStoreProvider.SCHEME_NAME.equals(providerName.getScheme())) {
                return new JavaKeyStoreProvider(providerName, conf);
            }
            return null;
        }
    }
}

