/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;

public class Sinusoidal
extends AbstractCoordTransBuilder {
    @Override
    public String getTransformName() {
        return "sinusoidal";
    }

    @Override
    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    @Override
    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        double centralMeridian = this.readAttributeDouble(ctv, "longitude_of_central_meridian", Double.NaN);
        double false_easting = this.readAttributeDouble(ctv, "false_easting", 0.0);
        double false_northing = this.readAttributeDouble(ctv, "false_northing", 0.0);
        double earth_radius = this.getEarthRadiusInKm(ctv);
        if (false_easting != 0.0 || false_northing != 0.0) {
            double scalef = Sinusoidal.getFalseEastingScaleFactor(ds, ctv);
            false_easting *= scalef;
            false_northing *= scalef;
        }
        ucar.unidata.geoloc.projection.Sinusoidal proj = new ucar.unidata.geoloc.projection.Sinusoidal(centralMeridian, false_easting, false_northing, earth_radius);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

